/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.helper;

import java.util.HashMap;
import java.util.Random;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.hooks.IArmorLootModifier;
import slimeknights.tconstruct.library.tools.capability.TinkerDataCapability;
import slimeknights.tconstruct.library.tools.capability.TinkerDataKeys;
import slimeknights.tconstruct.library.tools.context.EquipmentChangeContext;
import slimeknights.tconstruct.library.tools.context.ToolHarvestContext;
import slimeknights.tconstruct.library.tools.helper.ToolDamageUtil;
import slimeknights.tconstruct.library.tools.nbt.IModifierToolStack;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;

public final class ModifierUtil {
    public static final String TAG_ENCHANTMENTS = "Enchantments";
    @Deprecated
    public static final String TAG_HIDE_FLAGS = "HideFlags";

    @Deprecated
    public static boolean applyHarvestEnchants(ToolStack tool, ItemStack stack, ToolHarvestContext context) {
        return ModifierUtil.applyHarvestEnchantments(tool, stack, context) != null;
    }

    @Nullable
    public static ListNBT applyHarvestEnchantments(ToolStack tool, ItemStack stack, ToolHarvestContext context) {
        ListNBT originalEnchants = null;
        ServerPlayerEntity player = context.getPlayer();
        if (player == null || !player.func_184812_l_()) {
            ItemStack pants;
            HashMap enchantments = new HashMap();
            BiConsumer<Enchantment, Integer> enchantmentConsumer = (ench, add) -> {
                if (ench != null && add != null) {
                    Integer level = (Integer)enchantments.get(ench);
                    if (level != null) {
                        add = add + level;
                    }
                    enchantments.put(ench, add);
                }
            };
            for (ModifierEntry entry : tool.getModifierList()) {
                entry.getModifier().applyHarvestEnchantments(tool, entry.getLevel(), context, enchantmentConsumer);
            }
            if (player != null && TinkerTags.Items.LEGGINGS.func_230235_a_((Object)(pants = player.func_184582_a(EquipmentSlotType.LEGS)).func_77973_b())) {
                ToolStack pantsTool = ToolStack.from(pants);
                for (ModifierEntry entry : pantsTool.getModifierList()) {
                    IArmorLootModifier leggingLuck = entry.getModifier().getModule(IArmorLootModifier.class);
                    if (leggingLuck == null) continue;
                    leggingLuck.applyHarvestEnchantments(tool, entry.getLevel(), context, enchantmentConsumer);
                }
            }
            if (!enchantments.isEmpty()) {
                originalEnchants = stack.func_77986_q();
                EnchantmentHelper.func_82782_a(enchantments, (ItemStack)stack);
            }
        }
        return originalEnchants;
    }

    public static void clearEnchantments(ItemStack stack) {
        CompoundNBT nbt = stack.func_77978_p();
        if (nbt != null) {
            nbt.func_82580_o(TAG_ENCHANTMENTS);
        }
    }

    public static void restoreEnchantments(ItemStack stack, ListNBT originalTag) {
        CompoundNBT nbt = stack.func_77978_p();
        if (nbt != null) {
            if (originalTag.isEmpty()) {
                nbt.func_82580_o(TAG_ENCHANTMENTS);
            } else {
                nbt.func_218657_a(TAG_ENCHANTMENTS, (INBT)originalTag);
            }
        }
    }

    public static int getLootingLevel(IModifierToolStack tool, LivingEntity holder, Entity target, @Nullable DamageSource damageSource) {
        if (tool.isBroken()) {
            return 0;
        }
        int looting = 0;
        for (ModifierEntry entry : tool.getModifierList()) {
            looting = entry.getModifier().getLootingValue(tool, entry.getLevel(), holder, target, damageSource, looting);
        }
        return looting;
    }

    public static int getLeggingsLootingLevel(LivingEntity holder, Entity target, @Nullable DamageSource damageSource, int toolLooting) {
        ToolStack pantsTool;
        ItemStack pants = holder.func_184582_a(EquipmentSlotType.LEGS);
        if (!pants.func_190926_b() && TinkerTags.Items.LEGGINGS.func_230235_a_((Object)pants.func_77973_b()) && !(pantsTool = ToolStack.from(pants)).isBroken()) {
            for (ModifierEntry entry : pantsTool.getModifierList()) {
                IArmorLootModifier leggingLuck = entry.getModifier().getModule(IArmorLootModifier.class);
                if (leggingLuck == null) continue;
                toolLooting = leggingLuck.getLootingValue(pantsTool, entry.getLevel(), holder, target, damageSource, toolLooting);
            }
        }
        return toolLooting;
    }

    public static void dropItem(Entity target, ItemStack stack) {
        World world = target.func_130014_f_();
        if (!stack.func_190926_b() && !target.func_130014_f_().func_201670_d()) {
            ItemEntity ent = new ItemEntity(world, target.func_226277_ct_(), target.func_226278_cu_() + 1.0, target.func_226281_cx_(), stack);
            ent.func_174869_p();
            Random rand = target.field_70170_p.field_73012_v;
            ent.func_213317_d(ent.func_213322_ci().func_72441_c((double)((rand.nextFloat() - rand.nextFloat()) * 0.1f), (double)(rand.nextFloat() * 0.05f), (double)((rand.nextFloat() - rand.nextFloat()) * 0.1f)));
            world.func_217376_c((Entity)ent);
        }
    }

    public static int getModifierLevel(ItemStack stack, Modifier modifier) {
        ListNBT list;
        int size;
        CompoundNBT nbt;
        if (!stack.func_190926_b() && TinkerTags.Items.MODIFIABLE.func_230235_a_((Object)stack.func_77973_b()) && !ToolDamageUtil.isBroken(stack) && (nbt = stack.func_77978_p()) != null && nbt.func_150297_b("tic_modifiers", 9) && (size = (list = nbt.func_150295_c("tic_modifiers", 10)).size()) > 0) {
            String key = modifier.getId().toString();
            for (int i = 0; i < size; ++i) {
                CompoundNBT entry = list.func_150305_b(i);
                if (!key.equals(entry.func_74779_i("name"))) continue;
                return entry.func_74762_e("level");
            }
        }
        return 0;
    }

    public static void addTotalArmorModifierLevel(IModifierToolStack tool, EquipmentChangeContext context, TinkerDataCapability.TinkerDataKey<Integer> key, int amount, boolean allowBroken) {
        if (context.getChangedSlot().func_188453_a() == EquipmentSlotType.Group.ARMOR && (allowBroken || !tool.isBroken())) {
            context.getTinkerData().ifPresent(data -> {
                int totalLevels = data.get(key, 0) + amount;
                if (totalLevels <= 0) {
                    data.remove(key);
                } else {
                    data.put(key, totalLevels);
                }
            });
        }
    }

    public static void addTotalArmorModifierLevel(IModifierToolStack tool, EquipmentChangeContext context, TinkerDataCapability.TinkerDataKey<Integer> key, int amount) {
        ModifierUtil.addTotalArmorModifierLevel(tool, context, key, amount, false);
    }

    public static void addTotalArmorModifierFloat(IModifierToolStack tool, EquipmentChangeContext context, TinkerDataCapability.TinkerDataKey<Float> key, float amount) {
        if (context.getChangedSlot().func_188453_a() == EquipmentSlotType.Group.ARMOR && !tool.isBroken()) {
            context.getTinkerData().ifPresent(data -> {
                float totalLevels = data.get(key, Float.valueOf(0.0f)).floatValue() + amount;
                if (totalLevels <= 0.005f) {
                    data.remove(key);
                } else {
                    data.put(key, Float.valueOf(totalLevels));
                }
            });
        }
    }

    public static int getTotalModifierLevel(LivingEntity living, TinkerDataCapability.TinkerDataKey<Integer> key) {
        return living.getCapability(TinkerDataCapability.CAPABILITY).resolve().map(data -> (Integer)data.get(key)).orElse(0);
    }

    public static float getTotalModifierFloat(LivingEntity living, TinkerDataCapability.TinkerDataKey<Float> key) {
        return living.getCapability(TinkerDataCapability.CAPABILITY).resolve().map(data -> (Float)data.get(key)).orElse(Float.valueOf(0.0f)).floatValue();
    }

    public static boolean hasAquaAffinity(LivingEntity living) {
        return ModifierUtil.getTotalModifierLevel(living, TinkerDataKeys.AQUA_AFFINITY) > 0 || EnchantmentHelper.func_185287_i((LivingEntity)living);
    }

    public static boolean checkVolatileFlag(ItemStack stack, ResourceLocation flag) {
        CompoundNBT nbt = stack.func_77978_p();
        if (nbt != null && nbt.func_150297_b("tic_volatile_data", 10)) {
            return nbt.func_74775_l("tic_volatile_data").func_74767_n(flag.toString());
        }
        return false;
    }

    public static int getVolatileInt(ItemStack stack, ResourceLocation flag) {
        CompoundNBT nbt = stack.func_77978_p();
        if (nbt != null && nbt.func_150297_b("tic_volatile_data", 10)) {
            return nbt.func_74775_l("tic_volatile_data").func_74762_e(flag.toString());
        }
        return 0;
    }

    public static int getPersistentInt(ItemStack stack, ResourceLocation flag, int defealtValue) {
        String flagString;
        CompoundNBT persistent;
        CompoundNBT nbt = stack.func_77978_p();
        if (nbt != null && nbt.func_150297_b("tic_persistent_data", 10) && (persistent = nbt.func_74775_l("tic_persistent_data")).func_150297_b(flagString = flag.toString(), 3)) {
            return persistent.func_74762_e(flagString);
        }
        return defealtValue;
    }

    public static String getPersistentString(ItemStack stack, ResourceLocation flag) {
        CompoundNBT nbt = stack.func_77978_p();
        if (nbt != null && nbt.func_150297_b("tic_persistent_data", 10)) {
            return nbt.func_74775_l("tic_persistent_data").func_74779_i(flag.toString());
        }
        return "";
    }

    private ModifierUtil() {
    }
}

