/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.definition;

import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.IArmorMaterial;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import slimeknights.tconstruct.library.tools.ToolDefinition;
import slimeknights.tconstruct.library.tools.definition.IToolStatProvider;
import slimeknights.tconstruct.library.tools.definition.ToolDefinitionData;
import slimeknights.tconstruct.library.tools.stat.FloatToolStat;
import slimeknights.tconstruct.library.tools.stat.ToolStats;
import slimeknights.tconstruct.tools.item.ArmorSlotType;

public class ModifiableArmorMaterial
implements IArmorMaterial {
    public static final EquipmentSlotType[] ARMOR_SLOTS = new EquipmentSlotType[]{EquipmentSlotType.FEET, EquipmentSlotType.LEGS, EquipmentSlotType.CHEST, EquipmentSlotType.HEAD};
    private final ResourceLocation name;
    private final ToolDefinition[] armorDefinitions;
    private final SoundEvent soundEvent;

    public ModifiableArmorMaterial(ResourceLocation name, SoundEvent soundEvent, ToolDefinition ... armorDefinitions) {
        this.name = name;
        this.soundEvent = soundEvent;
        if (armorDefinitions.length != 4) {
            throw new IllegalArgumentException("Must have an armor definition for each slot");
        }
        this.armorDefinitions = armorDefinitions;
    }

    @Nullable
    public ToolDefinition getArmorDefinition(ArmorSlotType slotType) {
        return this.armorDefinitions[slotType.getIndex()];
    }

    private float getStat(FloatToolStat toolStat, @Nullable ArmorSlotType slotType) {
        ToolDefinition toolDefinition = slotType == null ? null : this.getArmorDefinition(slotType);
        float defaultValue = toolStat.getDefaultValue();
        if (toolDefinition == null) {
            return defaultValue;
        }
        ToolDefinitionData data = toolDefinition.getData();
        return data.getBaseStat(toolStat) * data.getMultiplier(toolStat);
    }

    public String func_200897_d() {
        return this.name.toString();
    }

    public ResourceLocation getNameLocation() {
        return this.name;
    }

    public int func_200896_a(EquipmentSlotType slotIn) {
        return (int)this.getStat(ToolStats.DURABILITY, ArmorSlotType.fromEquipment(slotIn));
    }

    public int func_200902_b(EquipmentSlotType slotIn) {
        return (int)this.getStat(ToolStats.ARMOR, ArmorSlotType.fromEquipment(slotIn));
    }

    public float func_200901_e() {
        return this.getStat(ToolStats.ARMOR_TOUGHNESS, ArmorSlotType.CHESTPLATE);
    }

    public float func_230304_f_() {
        return this.getStat(ToolStats.KNOCKBACK_RESISTANCE, ArmorSlotType.CHESTPLATE);
    }

    public int func_200900_a() {
        return 0;
    }

    public Ingredient func_200898_c() {
        return Ingredient.field_193370_a;
    }

    public static Builder builder(ResourceLocation name, ArmorSlotType ... slotTypes) {
        return new Builder(name, slotTypes);
    }

    public static Builder builder(ResourceLocation name) {
        return ModifiableArmorMaterial.builder(name, ArmorSlotType.values());
    }

    public SoundEvent func_200899_b() {
        return this.soundEvent;
    }

    public static class Builder {
        private final ResourceLocation name;
        private final ToolDefinition.Builder[] builders;
        private final ArmorSlotType[] slotTypes;
        private SoundEvent soundEvent = SoundEvents.field_187728_s;

        protected Builder(ResourceLocation baseName, ArmorSlotType[] slotTypes) {
            this.name = baseName;
            this.builders = new ToolDefinition.Builder[4];
            this.slotTypes = slotTypes;
            for (ArmorSlotType slot : slotTypes) {
                this.builders[slot.getIndex()] = ToolDefinition.builder(new ResourceLocation(baseName.func_110624_b(), baseName.func_110623_a() + "_" + slot.func_176610_l()));
            }
        }

        private ToolDefinition.Builder getBuilder(ArmorSlotType slotType) {
            ToolDefinition.Builder builder = this.builders[slotType.getIndex()];
            if (builder == null) {
                throw new IllegalArgumentException("Unsupported slot type " + (Object)((Object)slotType) + " for material " + this.name);
            }
            return builder;
        }

        public Builder set(ArmorSlotType slot, Consumer<ToolDefinition.Builder> builderConsumer) {
            builderConsumer.accept(this.getBuilder(slot));
            return this;
        }

        public Builder set(Consumer<ToolDefinition.Builder> builderConsumer) {
            for (ArmorSlotType slotType : this.slotTypes) {
                this.set(slotType, builderConsumer);
            }
            return this;
        }

        public Builder setStatsProvider(ArmorSlotType slot, IToolStatProvider statProvider) {
            this.getBuilder(slot).setStatsProvider(statProvider);
            return this;
        }

        public Builder setStatsProvider(IToolStatProvider statProvider) {
            for (ArmorSlotType slotType : this.slotTypes) {
                this.setStatsProvider(slotType, statProvider);
            }
            return this;
        }

        public Builder skipRegister() {
            for (ArmorSlotType slotType : this.slotTypes) {
                this.getBuilder(slotType).skipRegister();
            }
            return this;
        }

        public ModifiableArmorMaterial build() {
            ToolDefinition[] toolDefinitions = new ToolDefinition[4];
            for (ArmorSlotType slotType : this.slotTypes) {
                toolDefinitions[slotType.getIndex()] = this.builders[slotType.getIndex()].build();
            }
            return new ModifiableArmorMaterial(this.name, this.soundEvent, toolDefinitions);
        }

        public Builder setSoundEvent(SoundEvent soundEvent) {
            this.soundEvent = soundEvent;
            return this;
        }
    }
}

