/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.context;

import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.server.ServerWorld;

public class ToolHarvestContext {
    private final ServerWorld world;
    private final LivingEntity living;
    @Nullable
    private final ServerPlayerEntity player;
    private final BlockState state;
    private final BlockPos pos;
    private final Direction sideHit;
    private final boolean canHarvest;
    private final boolean isEffective;
    private final boolean isAOE;
    private final BlockPos targetedPos;
    private final BlockState targetedState;

    public ToolHarvestContext(ServerWorld world, ServerPlayerEntity player, BlockState state, BlockPos pos, Direction sideHit, boolean canHarvest, boolean isEffective) {
        this.world = world;
        this.living = player;
        this.player = player;
        this.state = state;
        this.pos = pos;
        this.canHarvest = canHarvest;
        this.isEffective = isEffective;
        this.sideHit = sideHit;
        this.isAOE = false;
        this.targetedPos = pos;
        this.targetedState = state;
    }

    public ToolHarvestContext(ServerWorld world, LivingEntity living, BlockState state, BlockPos pos, Direction sideHit, boolean canHarvest, boolean isEffective) {
        this.world = world;
        this.living = living;
        this.player = living instanceof ServerPlayerEntity ? (ServerPlayerEntity)living : null;
        this.state = state;
        this.pos = pos;
        this.canHarvest = canHarvest;
        this.isEffective = isEffective;
        this.sideHit = sideHit;
        this.isAOE = false;
        this.targetedPos = pos;
        this.targetedState = state;
    }

    public ToolHarvestContext forPosition(BlockPos pos, BlockState state) {
        return new ToolHarvestContext(this.world, this.living, this.player, state, pos, this.sideHit, state.canHarvestBlock((IBlockReader)this.world, pos, (PlayerEntity)this.player), true, true, this.targetedPos, this.targetedState);
    }

    public ServerWorld getWorld() {
        return this.world;
    }

    public LivingEntity getLiving() {
        return this.living;
    }

    @Nullable
    public ServerPlayerEntity getPlayer() {
        return this.player;
    }

    public BlockState getState() {
        return this.state;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public Direction getSideHit() {
        return this.sideHit;
    }

    public boolean canHarvest() {
        return this.canHarvest;
    }

    public boolean isEffective() {
        return this.isEffective;
    }

    public boolean isAOE() {
        return this.isAOE;
    }

    public BlockPos getTargetedPos() {
        return this.targetedPos;
    }

    public BlockState getTargetedState() {
        return this.targetedState;
    }

    private ToolHarvestContext(ServerWorld world, LivingEntity living, @Nullable ServerPlayerEntity player, BlockState state, BlockPos pos, Direction sideHit, boolean canHarvest, boolean isEffective, boolean isAOE, BlockPos targetedPos, BlockState targetedState) {
        this.world = world;
        this.living = living;
        this.player = player;
        this.state = state;
        this.pos = pos;
        this.sideHit = sideHit;
        this.canHarvest = canHarvest;
        this.isEffective = isEffective;
        this.isAOE = isAOE;
        this.targetedPos = targetedPos;
        this.targetedState = targetedState;
    }
}

