/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.capability;

import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.inventory.container.SimpleNamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.recipe.partbuilder.Pattern;
import slimeknights.tconstruct.library.tools.ToolDefinition;
import slimeknights.tconstruct.library.tools.capability.ToolCapabilityProvider;
import slimeknights.tconstruct.library.tools.helper.TooltipUtil;
import slimeknights.tconstruct.library.tools.nbt.IModifierToolStack;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;
import slimeknights.tconstruct.tools.inventory.ToolContainer;

public class ToolInventoryCapability
implements IItemHandlerModifiable {
    public static final ResourceLocation TOTAL_SLOTS = TConstruct.getResource("total_item_slots");
    public static final ResourceLocation INCLUDE_OFFHAND = TConstruct.getResource("inventory_show_offhand");
    private final Supplier<? extends IModifierToolStack> tool;
    private ItemStack[] cachedStacks;
    private int slots = -1;
    private int startForSlot = 0;
    private int modifierLevel = 0;

    public int getSlots() {
        if (this.slots == -1) {
            this.slots = this.tool.get().getVolatileData().getInt(TOTAL_SLOTS);
        }
        return this.slots;
    }

    @Nullable
    private IInventoryModifier getInventory(int slot) {
        IModifierToolStack tool = this.tool.get();
        if (slot < this.getSlots()) {
            int start = 0;
            for (ModifierEntry entry : tool.getModifierList()) {
                IInventoryModifier inventory = entry.getModifier().getModule(IInventoryModifier.class);
                if (inventory == null) continue;
                int slots = inventory.getSlots(tool, entry.getLevel());
                if (slot < slots + start) {
                    this.startForSlot = start;
                    this.modifierLevel = entry.getLevel();
                    return inventory;
                }
                start += slots;
            }
        }
        return null;
    }

    public static boolean isBlacklisted(ItemStack stack) {
        return TinkerTags.Items.TOOL_INVENTORY_BLACKLIST.func_230235_a_((Object)stack.func_77973_b()) || stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).isPresent();
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        if (!stack.func_190926_b() && ToolInventoryCapability.isBlacklisted(stack)) {
            return false;
        }
        IInventoryModifier inventory = this.getInventory(slot);
        if (inventory != null) {
            return inventory.isItemValid(this.tool.get(), slot - this.startForSlot, stack);
        }
        return false;
    }

    public int getSlotLimit(int slot) {
        IInventoryModifier inventory = this.getInventory(slot);
        if (inventory != null) {
            return inventory.getSlotLimit(this.tool.get(), slot - this.startForSlot);
        }
        return 0;
    }

    private void clearCache() {
        this.slots = -1;
        this.cachedStacks = null;
    }

    private void cacheStack(int slot, ItemStack stack) {
        int slots;
        if (slot >= 0 && slot < (slots = this.getSlots())) {
            if (this.cachedStacks == null) {
                this.cachedStacks = new ItemStack[this.getSlots()];
            }
            this.cachedStacks[slot] = stack;
        }
    }

    @Nullable
    private ItemStack getCachedStack(int slot) {
        if (this.cachedStacks != null && slot >= 0 && slot < this.getSlots()) {
            return this.cachedStacks[slot];
        }
        return null;
    }

    private void setAndCache(IInventoryModifier inventory, int localSlot, int globalSlot, ItemStack stack) {
        inventory.setStack(this.tool.get(), this.modifierLevel, localSlot, stack);
        this.cacheStack(globalSlot, stack);
    }

    public void setStackInSlot(int slot, ItemStack stack) {
        IInventoryModifier inventory = this.getInventory(slot);
        if (inventory != null) {
            this.setAndCache(inventory, slot - this.startForSlot, slot, stack);
        }
    }

    private ItemStack getAndCache(IInventoryModifier inventory, int localSlot, int globalSlot) {
        ItemStack stack = inventory.getStack(this.tool.get(), this.modifierLevel, localSlot);
        this.cacheStack(globalSlot, stack);
        return stack;
    }

    private ItemStack getCached(IInventoryModifier inventory, int localSlot, int globalSlot) {
        ItemStack stack = this.getCachedStack(globalSlot);
        if (stack == null) {
            stack = this.getAndCache(inventory, localSlot, globalSlot);
        }
        return stack;
    }

    public ItemStack getStackInSlot(int slot) {
        ItemStack cached = this.getCachedStack(slot);
        if (cached != null) {
            return cached;
        }
        IInventoryModifier inventory = this.getInventory(slot);
        if (inventory != null) {
            return this.getAndCache(inventory, slot - this.startForSlot, slot);
        }
        return ItemStack.field_190927_a;
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        int leftover;
        if (stack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        if (ToolInventoryCapability.isBlacklisted(stack)) {
            return stack;
        }
        IInventoryModifier inventory = this.getInventory(slot);
        if (inventory == null) {
            return stack;
        }
        int localSlot = slot - this.startForSlot;
        IModifierToolStack tool = this.tool.get();
        if (!inventory.isItemValid(tool, localSlot, stack)) {
            return stack;
        }
        ItemStack current = this.getCached(inventory, localSlot, slot);
        int slotLimit = inventory.getSlotLimit(tool, localSlot);
        if (current.func_190926_b()) {
            int canInsert = Math.min(stack.func_190916_E(), Math.min(stack.func_77976_d(), slotLimit));
            leftover = stack.func_190916_E() - canInsert;
            if (!simulate) {
                this.setAndCache(inventory, localSlot, slot, ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)canInsert));
            }
        } else {
            int limit = Math.min(current.func_77976_d(), slotLimit);
            if (current.func_190916_E() >= limit || !current.func_77969_a(stack)) {
                return stack;
            }
            int maxSize = current.func_190916_E() + stack.func_190916_E();
            int newSize = Math.min(maxSize, limit);
            leftover = maxSize - newSize;
            if (!simulate) {
                current.func_190920_e(newSize);
                inventory.setStack(tool, this.modifierLevel, localSlot, current);
            }
        }
        if (leftover == 0) {
            return ItemStack.field_190927_a;
        }
        return ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)leftover);
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (amount <= 0) {
            return ItemStack.field_190927_a;
        }
        IInventoryModifier inventory = this.getInventory(slot);
        if (inventory == null) {
            return ItemStack.field_190927_a;
        }
        int localSlot = slot - this.startForSlot;
        ItemStack current = this.getCached(inventory, localSlot, slot);
        if (current.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        if (amount > current.func_190916_E()) {
            amount = current.func_190916_E();
        }
        ItemStack result = ItemHandlerHelper.copyStackWithSize((ItemStack)current, (int)amount);
        if (!simulate) {
            if (amount == current.func_190916_E()) {
                this.setAndCache(inventory, localSlot, slot, ItemStack.field_190927_a);
            } else {
                current.func_190918_g(amount);
                inventory.setStack(this.tool.get(), this.modifierLevel, localSlot, current);
            }
        }
        return result;
    }

    public static void addSlots(ModDataNBT volatileData, int count) {
        volatileData.putInt(TOTAL_SLOTS, volatileData.getInt(TOTAL_SLOTS) + count);
    }

    public static ActionResultType tryOpenContainer(ItemStack stack, IModifierToolStack tool, PlayerEntity player, EquipmentSlotType slotType) {
        return ToolInventoryCapability.tryOpenContainer(stack, tool, tool.getDefinition(), player, slotType);
    }

    public static ActionResultType tryOpenContainer(ItemStack stack, @Nullable IModifierToolStack tool, ToolDefinition definition, PlayerEntity player, EquipmentSlotType slotType) {
        IItemHandler handler = stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).filter(cap -> cap instanceof IItemHandlerModifiable).orElse(null);
        if (handler != null) {
            if (player instanceof ServerPlayerEntity) {
                NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)new SimpleNamedContainerProvider((id, inventory, p) -> new ToolContainer(id, inventory, stack, (IItemHandlerModifiable)handler, slotType), TooltipUtil.getDisplayName(stack, tool, definition)), buf -> buf.func_179249_a((Enum)slotType));
            }
            return ActionResultType.func_233537_a_((boolean)player.field_70170_p.field_72995_K);
        }
        return ActionResultType.PASS;
    }

    public ToolInventoryCapability(Supplier<? extends IModifierToolStack> tool) {
        this.tool = tool;
    }

    public static class Provider
    implements ToolCapabilityProvider.IToolCapabilityProvider {
        private final LazyOptional<ToolInventoryCapability> handler = LazyOptional.of(() -> new ToolInventoryCapability(tool));

        public Provider(ItemStack stack, Supplier<? extends IModifierToolStack> tool) {
        }

        @Override
        public <T> LazyOptional<T> getCapability(IModifierToolStack tool, Capability<T> cap) {
            if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && tool.getVolatileData().getInt(TOTAL_SLOTS) > 0) {
                return this.handler.cast();
            }
            return LazyOptional.empty();
        }

        @Override
        public void clearCache() {
            this.handler.ifPresent(rec$ -> ((ToolInventoryCapability)rec$).clearCache());
        }
    }

    public static interface IInventoryModifier {
        public int getSlots(IModifierToolStack var1, int var2);

        public ItemStack getStack(IModifierToolStack var1, int var2, int var3);

        public void setStack(IModifierToolStack var1, int var2, int var3, ItemStack var4);

        default public int getSlotLimit(IModifierToolStack tool, int slot) {
            return 64;
        }

        default public boolean isItemValid(IModifierToolStack tool, int slot, ItemStack stack) {
            return true;
        }

        @Nullable
        default public Pattern getPattern(IModifierToolStack tool, int level, int slot, boolean hasStack) {
            return null;
        }
    }
}

