/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.partbuilder;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.util.ResourceLocation;
import slimeknights.mantle.recipe.data.AbstractRecipeBuilder;
import slimeknights.tconstruct.library.tools.part.IMaterialItem;
import slimeknights.tconstruct.tables.TinkerTables;

public class PartRecipeBuilder
extends AbstractRecipeBuilder<PartRecipeBuilder> {
    private final IMaterialItem output;
    private final int outputAmount;
    private int cost = 1;
    private ResourceLocation pattern = null;

    public static PartRecipeBuilder partRecipe(IMaterialItem output) {
        return PartRecipeBuilder.partRecipe(output, 1);
    }

    public void build(Consumer<IFinishedRecipe> consumerIn) {
        this.build(consumerIn, Objects.requireNonNull(this.output.func_199767_j().getRegistryName()));
    }

    public void build(Consumer<IFinishedRecipe> consumerIn, ResourceLocation id) {
        if (this.outputAmount <= 0) {
            throw new IllegalStateException("recipe " + id + " must output at least 1");
        }
        if (this.cost <= 0) {
            throw new IllegalStateException("recipe " + id + " has no cost associated with it");
        }
        if (this.pattern == null) {
            throw new IllegalStateException("recipe " + id + " has no pattern associated with it");
        }
        ResourceLocation advancementId = this.buildOptionalAdvancement(id, "parts");
        consumerIn.accept((IFinishedRecipe)new Result(id, advancementId));
    }

    private PartRecipeBuilder(IMaterialItem output, int outputAmount) {
        this.output = output;
        this.outputAmount = outputAmount;
    }

    public static PartRecipeBuilder partRecipe(IMaterialItem output, int outputAmount) {
        return new PartRecipeBuilder(output, outputAmount);
    }

    public PartRecipeBuilder setCost(int cost) {
        this.cost = cost;
        return this;
    }

    public PartRecipeBuilder setPattern(ResourceLocation pattern) {
        this.pattern = pattern;
        return this;
    }

    private class Result
    extends AbstractRecipeBuilder.AbstractFinishedRecipe {
        public Result(@Nullable ResourceLocation ID, ResourceLocation advancementID) {
            super((AbstractRecipeBuilder)PartRecipeBuilder.this, ID, advancementID);
        }

        public void func_218610_a(JsonObject json) {
            if (!PartRecipeBuilder.this.group.isEmpty()) {
                json.addProperty("group", PartRecipeBuilder.this.group);
            }
            json.addProperty("pattern", PartRecipeBuilder.this.pattern.toString());
            json.addProperty("cost", (Number)PartRecipeBuilder.this.cost);
            JsonObject jsonOutput = new JsonObject();
            jsonOutput.addProperty("item", Objects.requireNonNull(PartRecipeBuilder.this.output.func_199767_j().getRegistryName()).toString());
            if (PartRecipeBuilder.this.outputAmount > 1) {
                jsonOutput.addProperty("count", (Number)PartRecipeBuilder.this.outputAmount);
            }
            json.add("result", (JsonElement)jsonOutput);
        }

        public IRecipeSerializer<?> func_218609_c() {
            return (IRecipeSerializer)TinkerTables.partRecipeSerializer.get();
        }
    }
}

