/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.modifiers.adding;

import com.google.gson.JsonObject;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.util.ResourceLocation;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.recipe.modifiers.ModifierMatch;
import slimeknights.tconstruct.library.recipe.modifiers.adding.ModifierRecipeBuilder;
import slimeknights.tconstruct.tools.TinkerModifiers;

public class SwappableModifierRecipeBuilder
extends ModifierRecipeBuilder {
    private final String value;

    protected SwappableModifierRecipeBuilder(Modifier modifier, String value) {
        super(new ModifierEntry(modifier, 1));
        this.value = value;
    }

    public static SwappableModifierRecipeBuilder modifier(Modifier modifier, String value) {
        return new SwappableModifierRecipeBuilder(modifier, value);
    }

    @Override
    public ModifierRecipeBuilder setMaxLevel(int level) {
        throw new UnsupportedOperationException("Max level is always 1 for a swappable modifier recipe");
    }

    @Override
    public void build(Consumer<IFinishedRecipe> consumer, ResourceLocation id) {
        if (this.inputs.isEmpty()) {
            throw new IllegalStateException("Must have at least 1 input");
        }
        ResourceLocation advancementId = this.buildOptionalAdvancement(id, "modifiers");
        consumer.accept((IFinishedRecipe)new Finished(id, advancementId, false));
        if (this.includeUnarmed) {
            if (this.requirements != ModifierMatch.ALWAYS) {
                throw new IllegalStateException("Cannot use includeUnarmed with requirements");
            }
            consumer.accept((IFinishedRecipe)new Finished(new ResourceLocation(id.func_110624_b(), id.func_110623_a() + "_unarmed"), null, true));
        }
    }

    private class Finished
    extends ModifierRecipeBuilder.FinishedRecipe {
        public Finished(@Nullable ResourceLocation ID, ResourceLocation advancementID, boolean withUnarmed) {
            super(SwappableModifierRecipeBuilder.this, ID, advancementID, withUnarmed);
        }

        @Override
        public IRecipeSerializer<?> func_218609_c() {
            return (IRecipeSerializer)TinkerModifiers.swappableModifierSerializer.get();
        }

        @Override
        public void func_218610_a(JsonObject json) {
            super.func_218610_a(json);
            JsonObject result = json.getAsJsonObject("result");
            result.remove("level");
            result.addProperty("value", SwappableModifierRecipeBuilder.this.value);
        }
    }
}

