/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.melting;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import slimeknights.mantle.recipe.RecipeHelper;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.tconstruct.common.recipe.LoggingRecipeSerializer;
import slimeknights.tconstruct.library.recipe.melting.IMeltingInventory;
import slimeknights.tconstruct.library.recipe.melting.IMeltingRecipe;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;

public class MeltingRecipe
implements IMeltingRecipe {
    private final ResourceLocation id;
    private final String group;
    private final Ingredient input;
    private final FluidStack output;
    private final int temperature;
    private final int time;
    protected final List<FluidStack> byproducts;
    private List<List<FluidStack>> outputWithByproducts;

    public boolean matches(IMeltingInventory inv, World world) {
        return this.input.test(inv.getStack());
    }

    @Override
    public int getTemperature(IMeltingInventory inv) {
        return this.temperature;
    }

    @Override
    public int getTime(IMeltingInventory inv) {
        return this.time;
    }

    @Override
    public FluidStack getOutput(IMeltingInventory inv) {
        return this.output.copy();
    }

    public NonNullList<Ingredient> func_192400_c() {
        return NonNullList.func_193580_a((Object)Ingredient.field_193370_a, (Object[])new Ingredient[]{this.input});
    }

    public IRecipeSerializer<?> func_199559_b() {
        return (IRecipeSerializer)TinkerSmeltery.meltingSerializer.get();
    }

    public boolean isOre() {
        return false;
    }

    @Override
    public void handleByproducts(IMeltingInventory inv, IFluidHandler handler) {
        for (FluidStack fluidStack : this.byproducts) {
            handler.fill(fluidStack.copy(), IFluidHandler.FluidAction.EXECUTE);
        }
    }

    public List<List<FluidStack>> getDisplayOutput() {
        return Collections.singletonList(Collections.singletonList(this.output));
    }

    public List<List<FluidStack>> getOutputWithByproducts() {
        if (this.outputWithByproducts == null) {
            this.outputWithByproducts = Stream.concat(Stream.of(this.output), this.byproducts.stream()).map(Collections::singletonList).collect(Collectors.toList());
        }
        return this.outputWithByproducts;
    }

    public MeltingRecipe(ResourceLocation id, String group, Ingredient input, FluidStack output, int temperature, int time, List<FluidStack> byproducts) {
        this.id = id;
        this.group = group;
        this.input = input;
        this.output = output;
        this.temperature = temperature;
        this.time = time;
        this.byproducts = byproducts;
    }

    public ResourceLocation func_199560_c() {
        return this.id;
    }

    public String func_193358_e() {
        return this.group;
    }

    protected FluidStack getOutput() {
        return this.output;
    }

    public int getTemperature() {
        return this.temperature;
    }

    public int getTime() {
        return this.time;
    }

    public static class Serializer<T extends MeltingRecipe>
    extends LoggingRecipeSerializer<T> {
        private final IFactory<T> factory;

        public T read(ResourceLocation id, JsonObject json) {
            String group = JSONUtils.func_151219_a((JsonObject)json, (String)"group", (String)"");
            Ingredient input = Ingredient.func_199802_a((JsonElement)json.get("ingredient"));
            FluidStack output = RecipeHelper.deserializeFluidStack((JsonObject)JSONUtils.func_152754_s((JsonObject)json, (String)"result"));
            int temperature = JSONUtils.func_151203_m((JsonObject)json, (String)"temperature");
            int time = JSONUtils.func_151203_m((JsonObject)json, (String)"time");
            if (temperature < 0) {
                throw new JsonSyntaxException("Melting temperature must be greater than zero");
            }
            if (time <= 0) {
                throw new JsonSyntaxException("Melting time must be greater than zero");
            }
            List byproducts = Collections.emptyList();
            if (json.has("byproducts")) {
                byproducts = JsonHelper.parseList((JsonObject)json, (String)"byproducts", RecipeHelper::deserializeFluidStack);
            }
            return this.factory.create(id, group, input, output, temperature, time, byproducts);
        }

        @Override
        @Nullable
        protected T readSafe(ResourceLocation id, PacketBuffer buffer) {
            String group = buffer.func_150789_c(Short.MAX_VALUE);
            Ingredient input = Ingredient.func_199566_b((PacketBuffer)buffer);
            FluidStack output = FluidStack.readFromPacket((PacketBuffer)buffer);
            int temperature = buffer.readInt();
            int time = buffer.func_150792_a();
            ImmutableList.Builder builder = ImmutableList.builder();
            int byproductCount = buffer.func_150792_a();
            for (int i = 0; i < byproductCount; ++i) {
                builder.add((Object)FluidStack.readFromPacket((PacketBuffer)buffer));
            }
            return this.factory.create(id, group, input, output, temperature, time, (List<FluidStack>)builder.build());
        }

        @Override
        protected void writeSafe(PacketBuffer buffer, MeltingRecipe recipe) {
            buffer.func_180714_a(recipe.group);
            recipe.input.func_199564_a(buffer);
            recipe.output.writeToPacket(buffer);
            buffer.writeInt(recipe.temperature);
            buffer.func_150787_b(recipe.time);
            buffer.func_150787_b(recipe.byproducts.size());
            for (FluidStack fluidStack : recipe.byproducts) {
                fluidStack.writeToPacket(buffer);
            }
        }

        public Serializer(IFactory<T> factory) {
            this.factory = factory;
        }
    }

    @FunctionalInterface
    public static interface IFactory<T extends MeltingRecipe> {
        public T create(ResourceLocation var1, String var2, Ingredient var3, FluidStack var4, int var5, int var6, List<FluidStack> var7);
    }
}

