/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.materials.definition;

import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.text.Color;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import slimeknights.tconstruct.library.materials.definition.IMaterial;
import slimeknights.tconstruct.library.materials.definition.MaterialId;

public class Material
implements IMaterial {
    protected static final Color WHITE = Color.func_240743_a_((int)0xFFFFFF);
    private final MaterialId identifier;
    private final int tier;
    private final int sortOrder;
    private final boolean craftable;
    private final String translationKey;
    private final Color color;
    private final boolean hidden;
    private ITextComponent displayName = null;
    private ITextComponent coloredDisplayName = null;

    public Material(ResourceLocation identifier, int tier, int order, boolean craftable, Color color, boolean hidden) {
        this.identifier = new MaterialId(identifier);
        this.tier = tier;
        this.sortOrder = order;
        this.craftable = craftable;
        this.translationKey = Util.func_200697_a((String)"material", (ResourceLocation)identifier);
        this.color = color;
        this.hidden = hidden;
    }

    protected Material(ResourceLocation identifier, boolean craftable, boolean hidden) {
        this(identifier, 0, -1, craftable, WHITE, hidden);
    }

    @Override
    public ITextComponent getDisplayName() {
        if (this.displayName == null) {
            this.displayName = new TranslationTextComponent(this.getTranslationKey());
        }
        return this.displayName;
    }

    @Override
    public ITextComponent getColoredDisplayName() {
        if (this.coloredDisplayName == null) {
            this.coloredDisplayName = new TranslationTextComponent(this.getTranslationKey()).func_240700_a_(style -> style.func_240718_a_(this.getColor()));
        }
        return this.coloredDisplayName;
    }

    public String toString() {
        return "Material{" + (Object)((Object)this.identifier) + '}';
    }

    @Override
    public MaterialId getIdentifier() {
        return this.identifier;
    }

    @Override
    public int getTier() {
        return this.tier;
    }

    @Override
    public int getSortOrder() {
        return this.sortOrder;
    }

    @Override
    public boolean isCraftable() {
        return this.craftable;
    }

    @Override
    public String getTranslationKey() {
        return this.translationKey;
    }

    @Override
    public Color getColor() {
        return this.color;
    }

    @Override
    public boolean isHidden() {
        return this.hidden;
    }
}

