/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.fluid;

import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BucketItem;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.DrinkHelper;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.EmptyFluidHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import slimeknights.tconstruct.TConstruct;

public class FluidTransferUtil {
    private static final String KEY_FILLED = TConstruct.makeTranslationKey("block", "tank.filled");
    private static final String KEY_DRAINED = TConstruct.makeTranslationKey("block", "tank.drained");

    public static FluidStack tryTransfer(IFluidHandler input, IFluidHandler output, int maxFill) {
        int simulatedFill;
        FluidStack simulated = input.drain(maxFill, IFluidHandler.FluidAction.SIMULATE);
        if (!simulated.isEmpty() && (simulatedFill = output.fill(simulated, IFluidHandler.FluidAction.SIMULATE)) > 0) {
            int actualFill;
            FluidStack drainedFluid = input.drain(simulatedFill, IFluidHandler.FluidAction.EXECUTE);
            if (!drainedFluid.isEmpty() && (actualFill = output.fill(drainedFluid.copy(), IFluidHandler.FluidAction.EXECUTE)) != drainedFluid.getAmount()) {
                TConstruct.LOG.error("Lost {} fluid during transfer", (Object)(drainedFluid.getAmount() - actualFill));
            }
            return drainedFluid;
        }
        return FluidStack.EMPTY;
    }

    public static boolean interactWithBucket(World world, BlockPos pos, PlayerEntity player, Hand hand, Direction hit, Direction offset) {
        BucketItem bucket;
        Fluid fluid;
        ItemStack held = player.func_184586_b(hand);
        if (held.func_77973_b() instanceof BucketItem && (fluid = (bucket = (BucketItem)held.func_77973_b()).getFluid()) != Fluids.field_204541_a) {
            TileEntity te;
            if (!world.field_72995_K && (te = world.func_175625_s(pos)) != null) {
                te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, hit).ifPresent(handler -> {
                    FluidStack fluidStack = new FluidStack(bucket.getFluid(), 1000);
                    if (handler.fill(fluidStack, IFluidHandler.FluidAction.SIMULATE) == 1000) {
                        handler.fill(fluidStack, IFluidHandler.FluidAction.EXECUTE);
                        bucket.func_203792_a(world, held, pos.func_177972_a(offset));
                        world.func_184133_a(null, pos, fluid.getAttributes().getEmptySound(), SoundCategory.BLOCKS, 1.0f, 1.0f);
                        player.func_146105_b((ITextComponent)new TranslationTextComponent(KEY_FILLED, new Object[]{1000, fluidStack.getDisplayName()}), true);
                        if (!player.func_184812_l_()) {
                            player.func_184611_a(hand, held.getContainerItem());
                        }
                    }
                });
            }
            return true;
        }
        return false;
    }

    public static boolean interactWithFluidItem(World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        ItemStack stack = player.func_184586_b(hand);
        Direction face = hit.func_216354_b();
        if (!stack.func_190926_b() && stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).isPresent()) {
            LazyOptional teCapability;
            TileEntity te;
            if (!world.field_72995_K && (te = world.func_175625_s(pos)) != null && (teCapability = te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, face)).isPresent()) {
                IFluidHandler teHandler = (IFluidHandler)teCapability.orElse((Object)EmptyFluidHandler.INSTANCE);
                ItemStack copy = ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)1);
                copy.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).ifPresent(itemHandler -> {
                    FluidStack transferred = FluidTransferUtil.tryTransfer((IFluidHandler)itemHandler, teHandler, Integer.MAX_VALUE);
                    if (!transferred.isEmpty()) {
                        world.func_184133_a(null, pos, transferred.getFluid().getAttributes().getEmptySound(transferred), SoundCategory.BLOCKS, 1.0f, 1.0f);
                        player.func_146105_b((ITextComponent)new TranslationTextComponent(KEY_FILLED, new Object[]{transferred.getAmount(), transferred.getDisplayName()}), true);
                    } else {
                        transferred = FluidTransferUtil.tryTransfer(teHandler, (IFluidHandler)itemHandler, Integer.MAX_VALUE);
                        if (!transferred.isEmpty()) {
                            world.func_184133_a(null, pos, transferred.getFluid().getAttributes().getFillSound(transferred), SoundCategory.BLOCKS, 1.0f, 1.0f);
                            player.func_146105_b((ITextComponent)new TranslationTextComponent(KEY_DRAINED, new Object[]{transferred.getAmount(), transferred.getDisplayName()}), true);
                        }
                    }
                    if (!transferred.isEmpty()) {
                        player.func_184611_a(hand, DrinkHelper.func_242398_a((ItemStack)stack, (PlayerEntity)player, (ItemStack)itemHandler.getContainer()));
                    }
                });
            }
            return true;
        }
        return false;
    }

    public static boolean interactWithTank(World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        return FluidTransferUtil.interactWithFluidItem(world, pos, player, hand, hit) || FluidTransferUtil.interactWithBucket(world, pos, player, hand, hit.func_216354_b(), hit.func_216354_b());
    }

    private FluidTransferUtil() {
    }
}

