/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.data;

import com.google.common.annotations.VisibleForTesting;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonSyntaxException;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.resources.IResourceManagerReloadListener;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class MergingJsonDataLoader<B>
implements IResourceManagerReloadListener {
    private static final Logger log = LogManager.getLogger(MergingJsonDataLoader.class);
    private static final int JSON_LENGTH = ".json".length();
    @VisibleForTesting
    protected final Gson gson;
    @VisibleForTesting
    protected final String folder;
    @VisibleForTesting
    protected final Function<ResourceLocation, B> builderConstructor;

    protected abstract void parse(B var1, ResourceLocation var2, JsonElement var3) throws JsonSyntaxException;

    protected abstract void finishLoad(Map<ResourceLocation, B> var1, IResourceManager var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void func_195410_a(IResourceManager manager) {
        HashMap<ResourceLocation, B> map = new HashMap<ResourceLocation, B>();
        for (ResourceLocation filePath : manager.func_199003_a(this.folder, fileName -> fileName.endsWith(".json"))) {
            String path = filePath.func_110623_a();
            ResourceLocation id = new ResourceLocation(filePath.func_110624_b(), path.substring(this.folder.length() + 1, path.length() - JSON_LENGTH));
            try {
                for (IResource resource : manager.func_199004_b(filePath)) {
                    try {
                        InputStream inputstream = resource.func_199027_b();
                        Throwable throwable = null;
                        try {
                            BufferedReader reader = new BufferedReader(new InputStreamReader(inputstream, StandardCharsets.UTF_8));
                            Throwable throwable2 = null;
                            try {
                                JsonElement json = (JsonElement)JSONUtils.func_193839_a((Gson)this.gson, (Reader)reader, JsonElement.class);
                                if (json == null) {
                                    log.error("Couldn't load data file {} from {} in data pack {} as its null or empty", (Object)id, (Object)filePath, (Object)resource.func_199026_d());
                                    continue;
                                }
                                B builder = map.computeIfAbsent(id, this.builderConstructor);
                                this.parse(builder, id, json);
                            }
                            catch (Throwable throwable3) {
                                throwable2 = throwable3;
                                throw throwable3;
                            }
                            finally {
                                if (reader == null) continue;
                                if (throwable2 != null) {
                                    try {
                                        ((Reader)reader).close();
                                    }
                                    catch (Throwable throwable4) {
                                        throwable2.addSuppressed(throwable4);
                                    }
                                    continue;
                                }
                                ((Reader)reader).close();
                            }
                        }
                        catch (Throwable throwable5) {
                            throwable = throwable5;
                            throw throwable5;
                        }
                        finally {
                            if (inputstream == null) continue;
                            if (throwable != null) {
                                try {
                                    inputstream.close();
                                }
                                catch (Throwable throwable6) {
                                    throwable.addSuppressed(throwable6);
                                }
                                continue;
                            }
                            inputstream.close();
                        }
                    }
                    catch (IOException | RuntimeException ex) {
                        log.error("Couldn't parse data file {} from {} in data pack {}", (Object)id, (Object)filePath, (Object)resource.func_199026_d(), (Object)ex);
                    }
                    finally {
                        IOUtils.closeQuietly((Closeable)resource);
                    }
                }
            }
            catch (IOException ex) {
                log.error("Couldn't read material trait mapping {} from {}", (Object)id, (Object)filePath, (Object)ex);
            }
        }
        this.finishLoad(map, manager);
    }

    public MergingJsonDataLoader(Gson gson, String folder, Function<ResourceLocation, B> builderConstructor) {
        this.gson = gson;
        this.folder = folder;
        this.builderConstructor = builderConstructor;
    }
}

