/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.client.model.block;

import com.google.gson.JsonObject;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.client.renderer.model.BlockFaceUV;
import net.minecraft.client.renderer.model.BlockPart;
import net.minecraft.client.renderer.model.BlockPartFace;
import net.minecraft.util.Direction;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.math.vector.Vector3f;
import slimeknights.mantle.client.model.fluid.FluidCuboid;
import slimeknights.mantle.client.model.util.ModelHelper;

public class IncrementalFluidCuboid
extends FluidCuboid {
    private final int increments;

    public IncrementalFluidCuboid(Vector3f from, Vector3f to, Map<Direction, FluidCuboid.FluidFace> faces, int increments) {
        super(from, to, faces);
        this.increments = increments;
    }

    public BlockPart getPart(int amount, boolean gas) {
        Vector3f from = this.getFrom();
        Vector3f to = this.getTo();
        float minY = from.func_195900_b();
        float maxY = to.func_195900_b();
        if (gas) {
            from = from.func_229195_e_();
            from.setY(maxY + (float)amount * (minY - maxY) / (float)this.increments);
        } else {
            to = to.func_229195_e_();
            to.setY(minY + (float)amount * (maxY - minY) / (float)this.increments);
        }
        EnumMap<Direction, BlockPartFace> faces = new EnumMap<Direction, BlockPartFace>(Direction.class);
        for (Map.Entry entry : this.getFaces().entrySet()) {
            Direction dir = (Direction)entry.getKey();
            FluidCuboid.FluidFace face = (FluidCuboid.FluidFace)entry.getValue();
            boolean isFlowing = face.isFlowing();
            faces.put(dir, new BlockPartFace(null, 0, isFlowing ? "flowing_fluid" : "fluid", IncrementalFluidCuboid.getFaceUvs(from, to, dir, face.getRotation(), isFlowing ? 0.5f : 1.0f)));
        }
        return new BlockPart(from, to, faces, null, false);
    }

    private static BlockFaceUV getFaceUvs(Vector3f from, Vector3f to, Direction side, int rotation, float scale) {
        float temp;
        float v2;
        float u2;
        float v1;
        float u1;
        switch (side) {
            case DOWN: {
                u1 = from.func_195899_a();
                v1 = 16.0f - to.func_195902_c();
                u2 = to.func_195899_a();
                v2 = 16.0f - from.func_195902_c();
                break;
            }
            case UP: {
                u1 = from.func_195899_a();
                v1 = from.func_195902_c();
                u2 = to.func_195899_a();
                v2 = to.func_195902_c();
                break;
            }
            default: {
                u1 = 16.0f - to.func_195899_a();
                v1 = 16.0f - to.func_195900_b();
                u2 = 16.0f - from.func_195899_a();
                v2 = 16.0f - from.func_195900_b();
                break;
            }
            case SOUTH: {
                u1 = from.func_195899_a();
                v1 = 16.0f - to.func_195900_b();
                u2 = to.func_195899_a();
                v2 = 16.0f - from.func_195900_b();
                break;
            }
            case WEST: {
                u1 = from.func_195902_c();
                v1 = 16.0f - to.func_195900_b();
                u2 = to.func_195902_c();
                v2 = 16.0f - from.func_195900_b();
                break;
            }
            case EAST: {
                u1 = 16.0f - to.func_195902_c();
                v1 = 16.0f - to.func_195900_b();
                u2 = 16.0f - from.func_195902_c();
                v2 = 16.0f - from.func_195900_b();
            }
        }
        if (rotation >= 180) {
            temp = v1;
            v1 = 16.0f - v2;
            v2 = 16.0f - temp;
        }
        if (rotation == 90 || rotation == 180) {
            temp = u1;
            u1 = 16.0f - u2;
            u2 = 16.0f - temp;
        }
        float[] uv = rotation % 180 == 90 ? new float[]{v1 * scale, u1 * scale, v2 * scale, u2 * scale} : new float[]{u1 * scale, v1 * scale, u2 * scale, v2 * scale};
        return new BlockFaceUV(uv, rotation);
    }

    public static IncrementalFluidCuboid fromJson(JsonObject json) {
        Vector3f from = ModelHelper.arrayToVector((JsonObject)json, (String)"from");
        Vector3f to = ModelHelper.arrayToVector((JsonObject)json, (String)"to");
        Map faces = IncrementalFluidCuboid.getFaces((JsonObject)json);
        int increments = JSONUtils.func_151203_m((JsonObject)json, (String)"increments");
        return new IncrementalFluidCuboid(from, to, faces, increments);
    }

    public int getIncrements() {
        return this.increments;
    }
}

