/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.client.model.block;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import java.util.Collection;
import java.util.EnumMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IModelTransform;
import net.minecraft.client.renderer.model.IUnbakedModel;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.BakedModelWrapper;
import net.minecraftforge.client.model.IModelConfiguration;
import net.minecraftforge.client.model.IModelLoader;
import net.minecraftforge.client.model.geometry.IModelGeometry;
import slimeknights.mantle.client.model.fluid.FluidCuboid;
import slimeknights.mantle.client.model.util.SimpleBlockModel;

public class ChannelModel
implements IModelGeometry<ChannelModel> {
    public static final Loader LOADER = new Loader();
    private final SimpleBlockModel model;
    private final Map<ChannelModelPart, FluidCuboid> fluids;

    public ChannelModel(SimpleBlockModel model, Map<ChannelModelPart, FluidCuboid> fluids) {
        this.model = model;
        this.fluids = fluids;
    }

    public Collection<RenderMaterial> getTextures(IModelConfiguration owner, Function<ResourceLocation, IUnbakedModel> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
        return this.model.getTextures(owner, modelGetter, missingTextureErrors);
    }

    public IBakedModel bake(IModelConfiguration owner, ModelBakery bakery, Function<RenderMaterial, TextureAtlasSprite> spriteGetter, IModelTransform transform, ItemOverrideList overrides, ResourceLocation location) {
        IBakedModel baked = this.model.bakeModel(owner, transform, overrides, spriteGetter, location);
        return new BakedModel(baked, this.fluids);
    }

    private static enum ChannelModelPart {
        CENTER_STILL,
        CENTER_FLOWING,
        SIDE_STILL,
        SIDE_IN,
        SIDE_OUT,
        SIDE_EDGE,
        DOWN;

    }

    private static class Loader
    implements IModelLoader<ChannelModel> {
        private Loader() {
        }

        public void func_195410_a(IResourceManager resourceManager) {
        }

        public ChannelModel read(JsonDeserializationContext deserializationContext, JsonObject modelContents) {
            SimpleBlockModel model = SimpleBlockModel.deserialize((JsonDeserializationContext)deserializationContext, (JsonObject)modelContents);
            JsonObject fluidJson = JSONUtils.func_152754_s((JsonObject)modelContents, (String)"fluids");
            EnumMap<ChannelModelPart, FluidCuboid> fluids = new EnumMap<ChannelModelPart, FluidCuboid>(ChannelModelPart.class);
            fluids.put(ChannelModelPart.DOWN, FluidCuboid.fromJson((JsonObject)JSONUtils.func_152754_s((JsonObject)fluidJson, (String)"down")));
            JsonObject centerJson = JSONUtils.func_152754_s((JsonObject)fluidJson, (String)"center");
            fluids.put(ChannelModelPart.CENTER_STILL, FluidCuboid.fromJson((JsonObject)JSONUtils.func_152754_s((JsonObject)centerJson, (String)"still")));
            fluids.put(ChannelModelPart.CENTER_FLOWING, FluidCuboid.fromJson((JsonObject)JSONUtils.func_152754_s((JsonObject)centerJson, (String)"flowing")));
            JsonObject sideJson = JSONUtils.func_152754_s((JsonObject)fluidJson, (String)"side");
            fluids.put(ChannelModelPart.SIDE_STILL, FluidCuboid.fromJson((JsonObject)JSONUtils.func_152754_s((JsonObject)sideJson, (String)"still")));
            fluids.put(ChannelModelPart.SIDE_IN, FluidCuboid.fromJson((JsonObject)JSONUtils.func_152754_s((JsonObject)sideJson, (String)"in")));
            fluids.put(ChannelModelPart.SIDE_OUT, FluidCuboid.fromJson((JsonObject)JSONUtils.func_152754_s((JsonObject)sideJson, (String)"out")));
            fluids.put(ChannelModelPart.SIDE_EDGE, FluidCuboid.fromJson((JsonObject)JSONUtils.func_152754_s((JsonObject)sideJson, (String)"edge")));
            return new ChannelModel(model, fluids);
        }
    }

    public static class BakedModel
    extends BakedModelWrapper<IBakedModel> {
        private final Map<ChannelModelPart, FluidCuboid> fluids;

        private BakedModel(IBakedModel originalModel, Map<ChannelModelPart, FluidCuboid> fluids) {
            super(originalModel);
            this.fluids = fluids;
        }

        public FluidCuboid getDownFluid() {
            return this.fluids.get((Object)ChannelModelPart.DOWN);
        }

        public FluidCuboid getCenterFluid(boolean flowing) {
            return this.fluids.get((Object)(flowing ? ChannelModelPart.CENTER_FLOWING : ChannelModelPart.CENTER_STILL));
        }

        public FluidCuboid getSideFlow(boolean out) {
            return this.fluids.get((Object)(out ? ChannelModelPart.SIDE_OUT : ChannelModelPart.SIDE_IN));
        }

        public FluidCuboid getSideStill() {
            return this.fluids.get((Object)ChannelModelPart.SIDE_STILL);
        }

        public FluidCuboid getSideEdge() {
            return this.fluids.get((Object)ChannelModelPart.SIDE_EDGE);
        }
    }
}

