/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.client.data.material;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.util.ResourceLocation;
import slimeknights.tconstruct.library.client.data.util.AbstractSpriteReader;
import slimeknights.tconstruct.library.materials.stats.MaterialStatsId;
import slimeknights.tconstruct.tools.stats.ExtraMaterialStats;
import slimeknights.tconstruct.tools.stats.HandleMaterialStats;
import slimeknights.tconstruct.tools.stats.HeadMaterialStats;

public abstract class AbstractPartSpriteProvider {
    private final List<PartSpriteInfo> sprites = new ArrayList<PartSpriteInfo>();
    private final List<ToolSpriteBuilder> toolSprites = new ArrayList<ToolSpriteBuilder>();
    private boolean added = false;
    private final String modID;

    public abstract String getName();

    protected abstract void addAllSpites();

    protected void addSprite(ResourceLocation sprite, MaterialStatsId requiredStats) {
        this.sprites.add(new PartSpriteInfo(sprite, requiredStats, null));
    }

    protected void addSprite(String name, MaterialStatsId requiredStats) {
        this.addSprite(new ResourceLocation(this.modID, name), requiredStats);
    }

    protected void addTexture(ResourceLocation sprite, MaterialStatsId requiredStats) {
        this.sprites.add(new PartSpriteInfo(sprite, requiredStats, true));
    }

    protected void addTexture(String name, MaterialStatsId requiredStats) {
        this.addTexture(new ResourceLocation(this.modID, name), requiredStats);
    }

    protected void addPart(String name, MaterialStatsId requiredStats) {
        this.addSprite("parts/" + name, requiredStats);
    }

    protected void addHead(String name) {
        this.addPart(name, HeadMaterialStats.ID);
    }

    protected void addHandle(String name) {
        this.addPart(name, HandleMaterialStats.ID);
    }

    protected void addBinding(String name) {
        this.addPart(name, ExtraMaterialStats.ID);
    }

    protected ToolSpriteBuilder buildTool(ResourceLocation name) {
        ToolSpriteBuilder builder = new ToolSpriteBuilder(name);
        this.toolSprites.add(builder);
        return builder;
    }

    protected ToolSpriteBuilder buildTool(String name) {
        return this.buildTool(new ResourceLocation(this.modID, name));
    }

    private void ensureSpritesAdded() {
        if (!this.added) {
            this.addAllSpites();
            this.toolSprites.forEach(rec$ -> ((ToolSpriteBuilder)rec$).build());
            this.toolSprites.clear();
            this.added = true;
        }
    }

    public List<PartSpriteInfo> getSprites() {
        this.ensureSpritesAdded();
        return this.sprites;
    }

    public void cleanCache() {
        this.sprites.clear();
        this.added = false;
    }

    public AbstractPartSpriteProvider(String modID) {
        this.modID = modID;
    }

    protected class ToolSpriteBuilder {
        private final ResourceLocation name;
        private final Map<String, MaterialStatsId> parts = new HashMap<String, MaterialStatsId>();
        private boolean hasLarge = false;

        public ToolSpriteBuilder addPart(String name, MaterialStatsId statTypes) {
            this.parts.put(name, statTypes);
            return this;
        }

        public ToolSpriteBuilder addBreakablePart(String name, MaterialStatsId statTypes) {
            this.addPart(name, statTypes);
            this.addPart("broken_" + name, statTypes);
            return this;
        }

        public ToolSpriteBuilder addHead(String name) {
            return this.addPart(name, HeadMaterialStats.ID);
        }

        public ToolSpriteBuilder addBreakableHead(String name) {
            return this.addBreakablePart(name, HeadMaterialStats.ID);
        }

        public ToolSpriteBuilder addHandle(String name) {
            return this.addPart(name, HandleMaterialStats.ID);
        }

        public ToolSpriteBuilder addBinding(String name) {
            return this.addPart(name, ExtraMaterialStats.ID);
        }

        public ToolSpriteBuilder withLarge() {
            this.hasLarge = true;
            return this;
        }

        private void addParts(String path) {
            for (Map.Entry<String, MaterialStatsId> entry : this.parts.entrySet()) {
                AbstractPartSpriteProvider.this.addSprite(new ResourceLocation(this.name.func_110624_b(), path + "/" + entry.getKey()), entry.getValue());
            }
        }

        private void build() {
            this.addParts(this.name.func_110623_a());
            if (this.hasLarge) {
                this.addParts(this.name.func_110623_a() + "/large");
            }
        }

        private ToolSpriteBuilder(ResourceLocation name) {
            this.name = name;
        }
    }

    public static class PartSpriteInfo {
        private final ResourceLocation path;
        private final MaterialStatsId statType;
        private final Boolean baseFolder;
        private final transient Map<String, NativeImage> sprites = new HashMap<String, NativeImage>();
        private transient ResourceLocation computedPath;

        public PartSpriteInfo(ResourceLocation path, MaterialStatsId statType) {
            this(path, statType, null);
        }

        public ResourceLocation getPath() {
            if (this.computedPath == null) {
                this.computedPath = this.baseFolder == Boolean.TRUE ? this.path : new ResourceLocation(this.path.func_110624_b(), "item/tool/" + this.path.func_110623_a());
            }
            return this.computedPath;
        }

        @Nullable
        public NativeImage getTexture(AbstractSpriteReader spriteReader, String name) {
            ResourceLocation path;
            if (this.sprites.containsKey(name)) {
                return this.sprites.get(name);
            }
            ResourceLocation fallbackPath = path = this.getPath();
            if (!name.isEmpty()) {
                fallbackPath = new ResourceLocation(path.func_110624_b(), path.func_110623_a() + "_" + name);
            }
            NativeImage image = spriteReader.readIfExists(fallbackPath);
            this.sprites.put(name, image);
            return image;
        }

        public PartSpriteInfo(ResourceLocation path, MaterialStatsId statType, Boolean baseFolder) {
            this.path = path;
            this.statType = statType;
            this.baseFolder = baseFolder;
        }

        public MaterialStatsId getStatType() {
            return this.statType;
        }
    }
}

