/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.book.content;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.crafting.IShapedRecipe;
import net.minecraftforge.registries.ForgeRegistries;
import slimeknights.mantle.client.book.data.BookData;
import slimeknights.mantle.client.book.data.content.PageContent;
import slimeknights.mantle.client.book.data.element.ImageData;
import slimeknights.mantle.client.book.data.element.TextData;
import slimeknights.mantle.client.screen.book.BookScreen;
import slimeknights.mantle.client.screen.book.element.BookElement;
import slimeknights.mantle.client.screen.book.element.ImageElement;
import slimeknights.mantle.client.screen.book.element.TextElement;
import slimeknights.mantle.util.ItemStackList;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.book.content.ContentModifier;
import slimeknights.tconstruct.library.book.elements.TinkerItemElement;
import slimeknights.tconstruct.library.tools.ToolDefinition;
import slimeknights.tconstruct.library.tools.definition.PartRequirement;
import slimeknights.tconstruct.library.tools.helper.ToolBuildHandler;
import slimeknights.tconstruct.library.tools.item.IModifiableDisplay;
import slimeknights.tconstruct.library.tools.part.IToolPart;

@OnlyIn(value=Dist.CLIENT)
public class ContentTool
extends PageContent {
    public static final transient String ID = "tool";
    private static final transient String KEY_PROPERTIES = TConstruct.makeTranslationKey("book", "tool.properties");
    private static final transient ImageData IMG_SLOT_1x1 = ContentModifier.IMG_SLOT_1;
    private static final transient ImageData IMG_SLOT_1x2 = new ImageData(ContentModifier.BOOK_MODIFY, 40, 75, 22, 40, 256, 256);
    private static final transient ImageData IMG_SLOT_1x3 = new ImageData(ContentModifier.BOOK_MODIFY, 62, 75, 22, 58, 256, 256);
    private static final transient ImageData IMG_SLOT_2x1 = ContentModifier.IMG_SLOT_2;
    private static final transient ImageData IMG_SLOT_2x2 = ContentModifier.IMG_SLOT_4;
    private static final transient ImageData IMG_SLOT_2x3 = new ImageData(ContentModifier.BOOK_MODIFY, 84, 75, 40, 58, 256, 256);
    private static final transient ImageData IMG_SLOT_3x1 = ContentModifier.IMG_SLOT_3;
    private static final transient ImageData IMG_SLOT_3x2 = new ImageData(ContentModifier.BOOK_MODIFY, 58, 133, 58, 40, 256, 256);
    private static final transient ImageData IMG_SLOT_3x3 = new ImageData(ContentModifier.BOOK_MODIFY, 58, 173, 58, 58, 256, 256);
    private static final transient ImageData[] IMG_SLOTS_SHAPELESS = new ImageData[]{IMG_SLOT_1x1, IMG_SLOT_2x1, IMG_SLOT_3x1, IMG_SLOT_2x2, ContentModifier.IMG_SLOT_5, IMG_SLOT_3x2, IMG_SLOT_3x3, IMG_SLOT_3x3, IMG_SLOT_3x3};
    private static final transient ImageData[][] IMG_SLOTS_SHAPED = new ImageData[][]{{IMG_SLOT_1x1, IMG_SLOT_2x1, IMG_SLOT_3x1}, {IMG_SLOT_1x2, IMG_SLOT_2x2, IMG_SLOT_3x2}, {IMG_SLOT_1x3, IMG_SLOT_2x3, IMG_SLOT_3x3}};
    private static final transient SlotPos[] SLOTS_WIDTH_3 = new SlotPos[]{new SlotPos(3, 3), new SlotPos(21, 3), new SlotPos(39, 3), new SlotPos(3, 22), new SlotPos(21, 22), new SlotPos(39, 22), new SlotPos(3, 40), new SlotPos(21, 40), new SlotPos(39, 40)};
    private static final transient SlotPos[] SLOTS_WIDTH_2 = new SlotPos[]{SLOTS_WIDTH_3[0], SLOTS_WIDTH_3[1], SLOTS_WIDTH_3[3], SLOTS_WIDTH_3[4], SLOTS_WIDTH_3[6], SLOTS_WIDTH_3[7]};
    private static final transient SlotPos[] SLOTS_WIDTH_1 = new SlotPos[]{SLOTS_WIDTH_3[0], SLOTS_WIDTH_3[3], SLOTS_WIDTH_3[6]};
    private static final transient SlotPos[][] SLOTS_WIDTH = new SlotPos[][]{SLOTS_WIDTH_1, SLOTS_WIDTH_2, SLOTS_WIDTH_3};
    private static final transient SlotPos[] SLOTS_5 = new SlotPos[]{SLOTS_WIDTH_3[0], SLOTS_WIDTH_3[1], SLOTS_WIDTH_3[2], new SlotPos(12, 22), new SlotPos(30, 22)};
    private transient IModifiableDisplay tool;
    private transient List<ItemStackList> parts;
    private transient ImageData imgSlots;
    private transient SlotPos[] slotPos;
    public TextData[] text = new TextData[0];
    public String[] properties = new String[0];
    @SerializedName(value="tool")
    public String toolName;

    public ContentTool() {
    }

    public ContentTool(IModifiableDisplay tool) {
        this.tool = tool;
        this.toolName = Objects.requireNonNull(tool.func_199767_j().getRegistryName()).toString();
    }

    public void load() {
        if (this.toolName == null) {
            this.toolName = this.parent.name;
        }
        if (this.tool == null) {
            Item tool = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(this.toolName));
            this.tool = tool instanceof IModifiableDisplay ? (IModifiableDisplay)tool : new Fallback((IItemProvider)(tool == null ? Items.field_221803_eL : tool));
        }
        if (this.parts == null || this.slotPos == null) {
            List<PartRequirement> required = this.tool.getToolDefinition().getData().getParts();
            if (required.isEmpty()) {
                IRecipe recipe = Optional.ofNullable(Minecraft.func_71410_x().field_71441_e).flatMap(world -> world.func_199532_z().func_215366_a(IRecipeType.field_222149_a).values().stream().filter(r -> r.func_77571_b().func_77973_b() == this.tool.func_199767_j()).findFirst()).orElse(null);
                if (recipe != null) {
                    this.parts = recipe.func_192400_c().stream().map(ingredient -> ItemStackList.of((ItemStack[])ingredient.func_193365_a())).collect(Collectors.toList());
                    if (recipe instanceof IShapedRecipe) {
                        IShapedRecipe shaped = (IShapedRecipe)recipe;
                        int width = MathHelper.func_76125_a((int)(shaped.getRecipeWidth() - 1), (int)0, (int)2);
                        this.imgSlots = IMG_SLOTS_SHAPED[MathHelper.func_76125_a((int)(shaped.getRecipeHeight() - 1), (int)0, (int)2)][width];
                        this.slotPos = SLOTS_WIDTH[width];
                    }
                } else {
                    this.parts = Collections.emptyList();
                }
            } else {
                ImmutableList.Builder partBuilder = ImmutableList.builder();
                for (int i = 0; i < required.size(); ++i) {
                    IToolPart part = required.get(i).getPart();
                    if (part == null) continue;
                    ItemStack stack = part.withMaterialForDisplay(ToolBuildHandler.getRenderMaterial(i));
                    stack.func_196082_o().func_74757_a("tic_display", true);
                    partBuilder.add((Object)ItemStackList.of((ItemStack[])new ItemStack[]{stack}));
                }
                this.parts = partBuilder.build();
            }
            if (this.slotPos == null) {
                int size = this.parts.size();
                switch (size) {
                    case 4: {
                        this.slotPos = SLOTS_WIDTH_2;
                        break;
                    }
                    case 5: {
                        this.slotPos = SLOTS_5;
                        break;
                    }
                    default: {
                        this.slotPos = SLOTS_WIDTH_3;
                    }
                }
                if (size > 0) {
                    this.imgSlots = IMG_SLOTS_SHAPELESS[Math.min(size - 1, 9)];
                }
            }
        }
    }

    public void build(BookData book, ArrayList<BookElement> list, boolean brightSide) {
        this.addTitle(list, this.tool.getLocalizedName().getString());
        int padding = 5;
        int h = BookScreen.PAGE_WIDTH / 3 - 10;
        int y = this.getTitleHeight();
        list.add((BookElement)new TextElement(padding, y, BookScreen.PAGE_WIDTH - padding * 2, h, this.text));
        int imgWidth = 0;
        int imgHeight = 0;
        int partsSize = this.parts.size();
        if (partsSize > 0 && this.imgSlots != null) {
            imgWidth = this.imgSlots.width;
            imgHeight = this.imgSlots.height;
        }
        int imgX = BookScreen.PAGE_WIDTH / 2 + 20;
        int imgY = BookScreen.PAGE_HEIGHT / 2 + 30;
        imgX = imgX + 29 - imgWidth / 2;
        imgY = imgY + 20 - imgHeight / 2;
        if (this.properties.length > 0) {
            TextData head = new TextData(I18n.func_135052_a((String)KEY_PROPERTIES, (Object[])new Object[0]));
            head.underlined = true;
            list.add((BookElement)new TextElement(padding, 30 + h, 86 - padding, BookScreen.PAGE_HEIGHT - h - 20, new TextData[]{head}));
            ArrayList effectData = Lists.newArrayList();
            for (String e : this.properties) {
                effectData.add(new TextData("\u25cf "));
                effectData.add(new TextData(e));
                effectData.add(new TextData("\n"));
            }
            list.add((BookElement)new TextElement(padding, 44 + h, BookScreen.PAGE_WIDTH / 2 + 5, BookScreen.PAGE_HEIGHT - h - 20, (Collection)effectData));
        }
        list.add((BookElement)new ImageElement(imgX + (imgWidth - ContentModifier.IMG_TABLE.width) / 2, imgY + 28, -1, -1, ContentModifier.IMG_TABLE));
        if (this.imgSlots != null) {
            list.add((BookElement)new ImageElement(imgX, imgY, -1, -1, this.imgSlots, book.appearance.slotColor));
        }
        ItemStack demo = this.tool.getRenderTool();
        TinkerItemElement toolItem = new TinkerItemElement(imgX + (imgWidth - 16) / 2, imgY - 24, 1.0f, demo);
        list.add((BookElement)toolItem);
        list.add((BookElement)new ImageElement(imgX + (imgWidth - 22) / 2, imgY - 27, -1, -1, IMG_SLOT_1x1, 0xFFFFFF));
        for (int i = 0; i < partsSize; ++i) {
            SlotPos pos = this.slotPos[i];
            TinkerItemElement partItem = new TinkerItemElement(imgX + pos.getX(), imgY + pos.getY(), 1.0f, (Collection)this.parts.get(i));
            list.add((BookElement)partItem);
        }
    }

    private static class Fallback
    implements IModifiableDisplay {
        private final Item item;
        private final ItemStack renderTool;

        private Fallback(IItemProvider item) {
            this.item = item.func_199767_j();
            this.renderTool = new ItemStack(item);
        }

        public Item func_199767_j() {
            return this.item;
        }

        @Override
        public ToolDefinition getToolDefinition() {
            return ToolDefinition.EMPTY;
        }

        @Override
        public ItemStack getRenderTool() {
            return this.renderTool;
        }
    }

    private static class SlotPos {
        private final int x;
        private final int y;

        public SlotPos(int x, int y) {
            this.x = x;
            this.y = y;
        }

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }
    }
}

