/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.book.content;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fml.ForgeI18n;
import slimeknights.mantle.client.book.data.BookData;
import slimeknights.mantle.client.book.data.element.TextData;
import slimeknights.mantle.client.screen.book.BookScreen;
import slimeknights.mantle.client.screen.book.element.BookElement;
import slimeknights.mantle.client.screen.book.element.ItemElement;
import slimeknights.mantle.client.screen.book.element.TextElement;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.book.content.ContentMaterial;
import slimeknights.tconstruct.library.book.elements.TinkerItemElement;
import slimeknights.tconstruct.library.materials.definition.IMaterial;
import slimeknights.tconstruct.library.materials.definition.MaterialId;
import slimeknights.tconstruct.library.materials.stats.MaterialStatsId;
import slimeknights.tconstruct.library.recipe.RecipeTypes;
import slimeknights.tconstruct.library.recipe.casting.IDisplayableCastingRecipe;
import slimeknights.tconstruct.library.tools.nbt.MaterialIdNBT;
import slimeknights.tconstruct.tools.TinkerToolParts;
import slimeknights.tconstruct.tools.TinkerTools;
import slimeknights.tconstruct.tools.item.ArmorSlotType;
import slimeknights.tconstruct.tools.item.RepairKitItem;
import slimeknights.tconstruct.tools.stats.SkullStats;

public class ContentMaterialSkull
extends ContentMaterial {
    private static final String SKULL_FROM = TConstruct.makeTranslationKey("book", "material.skull_from");
    protected transient IDisplayableCastingRecipe skullRecipe = null;
    private transient boolean searchedSkullRecipe = false;
    protected transient List<ItemStack> skullStacks = null;

    public ContentMaterialSkull(IMaterial material, boolean detailed) {
        super(material, detailed);
    }

    @Nullable
    private IDisplayableCastingRecipe getSkullRecipe() {
        ClientWorld world = Minecraft.func_71410_x().field_71441_e;
        if (!this.searchedSkullRecipe && world != null) {
            this.skullRecipe = world.func_199532_z().func_241447_a_(RecipeTypes.CASTING_BASIN).stream().filter(recipe -> recipe instanceof IDisplayableCastingRecipe).map(recipe -> (IDisplayableCastingRecipe)((Object)recipe)).filter(recipe -> {
                ItemStack output = recipe.getOutput();
                return output.func_77973_b() == TinkerTools.slimesuit.get((Enum)ArmorSlotType.HELMET) && MaterialIdNBT.from(output).getMaterial(0).toString().equals(this.materialName);
            }).findFirst().orElse(null);
            this.searchedSkullRecipe = true;
        }
        return this.skullRecipe;
    }

    @Override
    public ITextComponent getTitle() {
        IDisplayableCastingRecipe skullRecipe = this.getSkullRecipe();
        if (skullRecipe != null) {
            return skullRecipe.getOutput().func_200301_q();
        }
        return super.getTitle();
    }

    @Override
    public List<ItemStack> getDisplayStacks() {
        List<ItemStack> skulls;
        IDisplayableCastingRecipe skullRecipe = this.getSkullRecipe();
        if (skullRecipe != null && !(skulls = skullRecipe.getCastItems()).isEmpty()) {
            return skulls;
        }
        return super.getDisplayStacks();
    }

    @Override
    protected boolean supportsStatType(MaterialStatsId statsId) {
        return statsId.equals((Object)SkullStats.ID);
    }

    @Override
    protected void addPrimaryDisplayItems(List<ItemElement> displayTools, MaterialId materialId) {
        List<ItemStack> casts;
        displayTools.add(new TinkerItemElement(((RepairKitItem)TinkerToolParts.repairKit.get()).withMaterialForDisplay(materialId)));
        super.addPrimaryDisplayItems(displayTools, materialId);
        IDisplayableCastingRecipe skullRecipe = this.getSkullRecipe();
        if (skullRecipe != null && !(casts = skullRecipe.getCastItems()).isEmpty()) {
            TinkerItemElement elementItem = new TinkerItemElement(0, 0, 1.0f, casts);
            elementItem.tooltip = ImmutableList.of((Object)new TranslationTextComponent(SKULL_FROM, new Object[]{casts.get(0).func_200301_q()}));
            displayTools.add(elementItem);
        }
    }

    @Override
    public void build(BookData book, ArrayList<BookElement> list, boolean rightSide) {
        IMaterial material = this.getMaterial();
        this.addTitle(list, this.getTitle().getString(), true, material.getColor().func_240742_a_());
        this.addDisplayItems(list, rightSide ? BookScreen.PAGE_WIDTH - 18 : 0, material.getIdentifier());
        int top = this.getTitleHeight();
        int left = rightSide ? 0 : 22;
        int y = top + 5;
        int x = left + 5;
        int w = BookScreen.PAGE_WIDTH - 20;
        int skullTraits = this.addStatsDisplay(x, y, w, list, material, SkullStats.ID);
        y += 65;
        MaterialId id = material.getIdentifier();
        String textKey = String.format(this.detailed ? "material.%s.%s.skull_encyclopedia" : "material.%s.%s.skull_flavor", id.func_110624_b(), id.func_110623_a());
        if (I18n.func_188566_a((String)textKey)) {
            String translated = ForgeI18n.getPattern((String)textKey);
            if (!this.detailed) {
                translated = '\"' + translated + '\"';
            }
            TextData flavourData = new TextData(translated);
            flavourData.italic = !this.detailed;
            list.add((BookElement)new TextElement(x, y + 10 * skullTraits, w, 60, new TextData[]{flavourData}));
        }
    }
}

