/*
 * Decompiled with CFR 0.152.
 */
package tfar.tanknull.network;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.network.NetworkEvent;
import tfar.tanknull.container.ItemStackTankNullMenu;

public class S2CSetFluidStackMessage {
    private int windowId = 0;
    private int slotId = 0;
    private FluidStack stack = FluidStack.EMPTY;

    public S2CSetFluidStackMessage() {
    }

    public S2CSetFluidStackMessage(int windowId, int slotId, FluidStack stack) {
        this.windowId = windowId;
        this.stack = stack;
    }

    public S2CSetFluidStackMessage(PacketBuffer buf) {
        this.windowId = buf.readInt();
        this.slotId = buf.readInt();
        this.stack = buf.readFluidStack();
    }

    public void encode(PacketBuffer buf) {
        buf.writeByte(this.windowId);
        buf.writeFluidStack(this.stack);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        PlayerEntity player = (PlayerEntity)DistExecutor.callWhenOn((Dist)Dist.CLIENT, () -> () -> Minecraft.func_71410_x().field_71439_g);
        if (player == null) {
            return;
        }
        ctx.get().enqueueWork(() -> {
            Container container = player.field_71070_bA;
            if (!(container instanceof ItemStackTankNullMenu) || this.windowId == container.field_75152_c) {
                // empty if block
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

