/*
 * Decompiled with CFR 0.152.
 */
package tfar.tanknull.inventory;

import javax.annotation.Nonnull;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import tfar.tanknull.TankNullItem;
import tfar.tanknull.Utils;
import tfar.tanknull.inventory.ItemStackFluidStackHandler;

public class TankNullItemStackFluidStackHandler
extends ItemStackFluidStackHandler {
    public int selectedTank = 0;
    public boolean isFill = false;
    public boolean sponge = false;
    public boolean smartPlacing = true;

    public TankNullItemStackFluidStackHandler(int tanks, int capacity, ItemStack container) {
        super(tanks, capacity, container);
    }

    @Override
    public void onContentsChanged(int slot) {
        super.onContentsChanged(slot);
        this.saveToItemStack();
    }

    public void saveToItemStack() {
        CompoundNBT nbt = this.serializeNBT();
        this.tank.func_196082_o().func_218657_a("fluidinv", (INBT)nbt);
    }

    @Nonnull
    public TankNullItemStackFluidStackHandler loadFromItemStack(ItemStack stack) {
        CompoundNBT nbt = stack.func_190925_c("fluidinv");
        this.deserializeNBT(nbt);
        return this;
    }

    public boolean hasRoomForFluid(FluidStack toPickup) {
        return this.fill(toPickup, IFluidHandler.FluidAction.SIMULATE) == toPickup.getAmount();
    }

    public boolean hasRoomForFluidBlock(Fluid toPickup) {
        return this.hasRoomForFluid(new FluidStack(toPickup, 1000));
    }

    public FluidStack drain1000(IFluidHandler.FluidAction action) {
        return this.drain(this.selectedTank, 1000, action);
    }

    public int fill1000(IFluidHandler.FluidAction action, Fluid toPickup) {
        return this.fill(new FluidStack(toPickup, 1000), action);
    }

    public FluidStack getSelectedFluid() {
        return this.getFluidInTank(this.selectedTank);
    }

    public void toggleFill() {
        this.isFill = !this.isFill;
        this.saveToItemStack();
    }

    public void scroll(boolean right) {
        if (right) {
            ++this.selectedTank;
            if (this.selectedTank >= this.getTanks()) {
                this.selectedTank = 0;
            }
        } else {
            --this.selectedTank;
            if (this.selectedTank < 0) {
                this.selectedTank = this.getTanks() - 1;
            }
        }
        this.saveToItemStack();
    }

    @Override
    public CompoundNBT serializeNBT() {
        CompoundNBT nbt = super.serializeNBT();
        nbt.func_74768_a("SelectedTank", this.selectedTank);
        nbt.func_74757_a("fill", this.isFill);
        nbt.func_74757_a("sponge", this.sponge);
        return nbt;
    }

    @Override
    public void deserializeNBT(CompoundNBT nbt) {
        ListNBT tagList = nbt.func_150295_c("Fluids", 10);
        for (int i = 0; i < tagList.size(); ++i) {
            CompoundNBT fluidTags = tagList.func_150305_b(i);
            int tank = fluidTags.func_74762_e("Tank");
            if (tank < 0 || tank >= this.stacks.size()) continue;
            this.stacks.set(tank, (Object)FluidStack.loadFluidStackFromNBT((CompoundNBT)fluidTags));
        }
        this.selectedTank = nbt.func_74762_e("SelectedTank");
        this.isFill = nbt.func_74767_n("fill");
        this.sponge = nbt.func_74767_n("sponge");
    }

    public static TankNullItemStackFluidStackHandler create(ItemStack stack) {
        if (stack.func_77973_b() instanceof TankNullItem) {
            TankNullItemStackFluidStackHandler handler = new TankNullItemStackFluidStackHandler(Utils.getTanks(stack), Utils.getCapacity(stack), stack);
            return handler.loadFromItemStack(stack);
        }
        throw new IllegalStateException("not a tank null");
    }

    public void toggleSponge() {
        this.sponge = !this.sponge;
        this.saveToItemStack();
    }
}

