/*
 * Decompiled with CFR 0.152.
 */
package tfar.tanknull.container;

import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import tfar.tanknull.RegistryObjects;
import tfar.tanknull.TankStats;
import tfar.tanknull.Utils;
import tfar.tanknull.container.BlockTankNullMenu;
import tfar.tanknull.container.LockedSlot;
import tfar.tanknull.inventory.FluidStackHandler;
import tfar.tanknull.inventory.TankNullItemStackFluidStackHandler;

public class ItemStackTankNullMenu
extends BlockTankNullMenu {
    public ItemStackTankNullMenu(ContainerType<?> type, int id, PlayerInventory inv, TankStats stats) {
        super(type, id, inv, stats, ItemStackTankNullMenu.read(inv));
        this.addPlayerSlots(inv.field_70461_c);
    }

    public ItemStackTankNullMenu(ContainerType<?> type, int id, PlayerInventory inv, TankStats stats, FluidStackHandler fluidStackHandler) {
        super(type, id, inv, stats, fluidStackHandler);
        this.addPlayerSlots(inv.field_70461_c);
    }

    protected void addPlayerSlots(int locked) {
        int row;
        int yStart = 86;
        for (row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                int x = 8 + col * 18;
                int y = row * 18 + yStart;
                this.func_75146_a(new Slot((IInventory)this.inv, col + row * 9 + 9, x, y));
            }
        }
        for (row = 0; row < 9; ++row) {
            int x = 8 + row * 18;
            int y = yStart + 58;
            if (row != locked) {
                this.func_75146_a(new Slot((IInventory)this.inv, row, x, y));
                continue;
            }
            this.func_75146_a(new LockedSlot(this.inv, row, x, y));
        }
    }

    public static ItemStackTankNullMenu t1c(int i, PlayerInventory playerInventory) {
        return new ItemStackTankNullMenu(RegistryObjects.tank_1_portable, i, playerInventory, TankStats.one);
    }

    public static ItemStackTankNullMenu t2c(int i, PlayerInventory playerInventory) {
        return new ItemStackTankNullMenu(RegistryObjects.tank_2_portable, i, playerInventory, TankStats.two);
    }

    public static ItemStackTankNullMenu t3c(int i, PlayerInventory playerInventory) {
        return new ItemStackTankNullMenu(RegistryObjects.tank_3_portable, i, playerInventory, TankStats.three);
    }

    public static ItemStackTankNullMenu t4c(int i, PlayerInventory playerInventory) {
        return new ItemStackTankNullMenu(RegistryObjects.tank_4_portable, i, playerInventory, TankStats.four);
    }

    public static ItemStackTankNullMenu t5c(int i, PlayerInventory playerInventory) {
        return new ItemStackTankNullMenu(RegistryObjects.tank_5_portable, i, playerInventory, TankStats.five);
    }

    public static ItemStackTankNullMenu t6c(int i, PlayerInventory playerInventory) {
        return new ItemStackTankNullMenu(RegistryObjects.tank_6_portable, i, playerInventory, TankStats.six);
    }

    public static ItemStackTankNullMenu t7c(int i, PlayerInventory playerInventory) {
        return new ItemStackTankNullMenu(RegistryObjects.tank_7_portable, i, playerInventory, TankStats.seven);
    }

    public static FluidStackHandler read(PlayerInventory inv) {
        ItemStack stack = inv.field_70458_d.func_184614_ca();
        CompoundNBT nbt = stack.func_77978_p();
        if (nbt == null) {
            TankStats stats = Utils.getStats(stack);
            return new FluidStackHandler(stats.slots, stats.capacity);
        }
        TankStats stats = Utils.getStats(stack);
        TankNullItemStackFluidStackHandler handler = new TankNullItemStackFluidStackHandler(stats.slots, stats.capacity, stack);
        ((FluidStackHandler)handler).deserializeNBT(nbt.func_74775_l("fluidinv"));
        return handler;
    }

    public static ItemStackTankNullMenu t1s(int i, PlayerInventory playerInventory, FluidStackHandler fluidStackHandler) {
        return new ItemStackTankNullMenu(RegistryObjects.tank_1_portable, i, playerInventory, TankStats.one, fluidStackHandler);
    }

    public static ItemStackTankNullMenu t2s(int i, PlayerInventory playerInventory, FluidStackHandler fluidStackHandler) {
        return new ItemStackTankNullMenu(RegistryObjects.tank_2_portable, i, playerInventory, TankStats.two, fluidStackHandler);
    }

    public static ItemStackTankNullMenu t3s(int i, PlayerInventory playerInventory, FluidStackHandler fluidStackHandler) {
        return new ItemStackTankNullMenu(RegistryObjects.tank_3_portable, i, playerInventory, TankStats.three, fluidStackHandler);
    }

    public static ItemStackTankNullMenu t4s(int i, PlayerInventory playerInventory, FluidStackHandler fluidStackHandler) {
        return new ItemStackTankNullMenu(RegistryObjects.tank_4_portable, i, playerInventory, TankStats.four, fluidStackHandler);
    }

    public static ItemStackTankNullMenu t5s(int i, PlayerInventory playerInventory, FluidStackHandler fluidStackHandler) {
        return new ItemStackTankNullMenu(RegistryObjects.tank_5_portable, i, playerInventory, TankStats.five, fluidStackHandler);
    }

    public static ItemStackTankNullMenu t6s(int i, PlayerInventory playerInventory, FluidStackHandler fluidStackHandler) {
        return new ItemStackTankNullMenu(RegistryObjects.tank_6_portable, i, playerInventory, TankStats.six, fluidStackHandler);
    }

    public static ItemStackTankNullMenu t7s(int i, PlayerInventory playerInventory, FluidStackHandler fluidStackHandler) {
        return new ItemStackTankNullMenu(RegistryObjects.tank_7_portable, i, playerInventory, TankStats.seven, fluidStackHandler);
    }
}

