/*
 * Decompiled with CFR 0.152.
 */
package tfar.tanknull;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.text.DecimalFormat;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.fluid.Fluid;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.IContainerListener;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fluids.FluidStack;
import tfar.tanknull.container.BlockTankNullMenu;
import tfar.tanknull.inventory.FluidStackHandler;

public class BlockTankNullScreen
extends ContainerScreen<BlockTankNullMenu>
implements IContainerListener {
    private final ResourceLocation TEXTURE;
    private static final DecimalFormat decimalFormat = new DecimalFormat("0.#");

    public BlockTankNullScreen(BlockTankNullMenu screenContainer, PlayerInventory inv, ITextComponent titleIn) {
        super((Container)screenContainer, inv, titleIn);
        this.TEXTURE = new ResourceLocation("tanknull", "textures/container/gui/tank" + screenContainer.stats.ordinal() + ".png");
        this.field_147000_g += 4;
    }

    public void func_230430_a_(MatrixStack stack, int p_render_1_, int p_render_2_, float p_render_3_) {
        this.func_230446_a_(stack);
        super.func_230430_a_(stack, p_render_1_, p_render_2_, p_render_3_);
        this.func_230459_a_(stack, p_render_1_, p_render_2_);
    }

    protected void func_230450_a_(MatrixStack matrixStack, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_230706_i_.func_110434_K().func_110577_a(this.getBackground());
        int i = (this.field_230708_k_ - this.field_146999_f) / 2;
        int j = (this.field_230709_l_ - this.field_147000_g) / 2;
        this.func_238474_b_(matrixStack, i, j, 0, 0, this.field_146999_f, this.field_147000_g);
        this.drawFluids(matrixStack);
    }

    public ResourceLocation getBackground() {
        return this.TEXTURE;
    }

    protected void drawFluids(MatrixStack stack) {
        FluidStackHandler fluidStackHandler = ((BlockTankNullMenu)this.field_147002_h).fluidStackHandler;
        int column = fluidStackHandler.getTanks() / 3;
        int xPos = this.field_147003_i + 89 - column * 9;
        int yPos = this.field_147009_r + 18;
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < column; ++x) {
                FluidStack fluidStack = fluidStackHandler.getFluidInTank(x + column * y);
                if (fluidStack.isEmpty()) continue;
                this.field_230706_i_.field_71446_o.func_110577_a(AtlasTexture.field_110575_b);
                int color = fluidStack.getFluid().getAttributes().getColor(fluidStack);
                TextureAtlasSprite textureAtlasSprite = BlockTankNullScreen.getFluidTexture(fluidStack);
                RenderSystem.color3f((float)((float)(color >> 16 & 0xFF) / 255.0f), (float)((float)(color >> 8 & 0xFF) / 255.0f), (float)((float)(color & 0xFF) / 255.0f));
                BlockTankNullScreen.func_238470_a_((MatrixStack)stack, (int)(xPos + x * 18), (int)(yPos + y * 18), (int)0, (int)16, (int)16, (TextureAtlasSprite)textureAtlasSprite);
                this.field_230712_o_.func_238405_a_(stack, this.getStringFromInt(fluidStack.getAmount()), (float)(xPos + x * 18), (float)(yPos + y * 18 + 9), 0xFFFFFF);
            }
        }
    }

    public String getStringFromInt(int number) {
        if (number >= 1000000000) {
            return decimalFormat.format((float)number / 1.0E9f) + "b";
        }
        if (number >= 1000000) {
            return decimalFormat.format((float)number / 1000000.0f) + "m";
        }
        if (number >= 1000) {
            return decimalFormat.format((float)number / 1000.0f) + "k";
        }
        return Float.toString(number).replaceAll("\\.?0*$", "");
    }

    public static TextureAtlasSprite getFluidTexture(@Nonnull FluidStack fluidStack) {
        Fluid fluid = fluidStack.getFluid();
        ResourceLocation spriteLocation = fluid.getAttributes().getStillTexture(fluidStack);
        return BlockTankNullScreen.getSprite(spriteLocation);
    }

    public static TextureAtlasSprite getSprite(ResourceLocation spriteLocation) {
        return (TextureAtlasSprite)Minecraft.func_71410_x().func_228015_a_(AtlasTexture.field_110575_b).apply(spriteLocation);
    }

    public void func_71110_a(Container containerToSend, NonNullList<ItemStack> itemsList) {
    }

    public void func_71111_a(Container containerToSend, int slotInd, ItemStack stack) {
    }

    public void func_71112_a(Container containerIn, int varToUpdate, int newValue) {
    }
}

