/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.reg;

import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import java.util.Collection;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import net.mehvahdjukaar.moonlight.api.item.WoodBasedBlockItem;
import net.mehvahdjukaar.moonlight.api.item.additional_placements.AdditionalItemPlacement;
import net.mehvahdjukaar.moonlight.api.item.additional_placements.AdditionalItemPlacementsAPI;
import net.mehvahdjukaar.moonlight.api.misc.RegSupplier;
import net.mehvahdjukaar.moonlight.api.misc.Registrator;
import net.mehvahdjukaar.moonlight.api.platform.RegHelper;
import net.mehvahdjukaar.moonlight.api.set.BlockSetAPI;
import net.mehvahdjukaar.moonlight.api.set.BlocksColorAPI;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.common.block.blocks.CandleHolderBlock;
import net.mehvahdjukaar.supplementaries.common.block.blocks.FlagBlock;
import net.mehvahdjukaar.supplementaries.common.events.overrides.SuppAdditionalPlacement;
import net.mehvahdjukaar.supplementaries.common.items.FlagItem;
import net.mehvahdjukaar.supplementaries.common.items.PresentItem;
import net.mehvahdjukaar.supplementaries.common.items.SignPostItem;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.integration.BuzzierBeesCompat;
import net.mehvahdjukaar.supplementaries.integration.CaveEnhancementsCompat;
import net.mehvahdjukaar.supplementaries.integration.CompatHandler;
import net.mehvahdjukaar.supplementaries.integration.CompatObjects;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.mehvahdjukaar.supplementaries.reg.ModSounds;
import net.minecraft.class_1747;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_2248;
import net.minecraft.class_2498;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2960;
import net.minecraft.class_3619;
import net.minecraft.class_3620;
import net.minecraft.class_4970;

public class RegUtils {
    public static void initDynamicRegistry() {
        BlockSetAPI.addDynamicItemRegistration(RegUtils::registerSignPostItems, WoodType.class);
        AdditionalItemPlacementsAPI.addRegistration(RegUtils::registerPlacements);
    }

    private static void registerPlacements(AdditionalItemPlacementsAPI.Event event) {
        if (CommonConfigs.Tweaks.WRITTEN_BOOKS.get().booleanValue()) {
            SuppAdditionalPlacement horizontalPlacement = new SuppAdditionalPlacement(ModRegistry.BOOK_PILE_H.get());
            event.register(class_1802.field_8529, (AdditionalItemPlacement)horizontalPlacement);
            event.register(class_1802.field_8674, (AdditionalItemPlacement)horizontalPlacement);
            event.register(class_1802.field_8360, (AdditionalItemPlacement)horizontalPlacement);
        }
        if (CommonConfigs.Tweaks.PLACEABLE_BOOKS.get().booleanValue()) {
            class_1792 gene;
            SuppAdditionalPlacement verticalPlacement = new SuppAdditionalPlacement(ModRegistry.BOOK_PILE.get());
            event.register(class_1802.field_8598, (AdditionalItemPlacement)verticalPlacement);
            class_1792 tome = CompatObjects.TOME.get();
            if (tome != null) {
                event.register(tome, (AdditionalItemPlacement)verticalPlacement);
            }
            if ((gene = CompatObjects.GENE_BOOK.get()) != null) {
                event.register(gene, (AdditionalItemPlacement)verticalPlacement);
            }
        }
        event.registerSimple(ModRegistry.PANCAKE_ITEM.get(), ModRegistry.PANCAKE.get());
        if (CommonConfigs.Tweaks.PLACEABLE_STICKS.get().booleanValue()) {
            event.register(class_1802.field_8600, (AdditionalItemPlacement)new SuppAdditionalPlacement(ModRegistry.STICK_BLOCK.get()));
        }
        if (CommonConfigs.Tweaks.PLACEABLE_RODS.get().booleanValue()) {
            event.register(class_1802.field_8894, (AdditionalItemPlacement)new SuppAdditionalPlacement(ModRegistry.BLAZE_ROD_BLOCK.get()));
        }
        if (CommonConfigs.Tweaks.PLACEABLE_GUNPOWDER.get().booleanValue()) {
            event.register(class_1802.field_8054, (AdditionalItemPlacement)new SuppAdditionalPlacement(ModRegistry.GUNPOWDER_BLOCK.get()));
        }
    }

    public static <T extends class_1792> Supplier<T> regItem(String name, Supplier<T> sup) {
        return RegHelper.registerItem((class_2960)Supplementaries.res(name), sup);
    }

    public static <T extends class_2591<E>, E extends class_2586> Supplier<T> regTile(String name, Supplier<T> sup) {
        return RegHelper.registerBlockEntityType((class_2960)Supplementaries.res(name), sup);
    }

    public static <T extends class_2248> RegSupplier<T> regBlock(String name, Supplier<T> sup) {
        return RegHelper.registerBlock((class_2960)Supplementaries.res(name), sup);
    }

    public static <T extends class_2248> RegSupplier<T> regWithItem(String name, Supplier<T> blockFactory) {
        return RegUtils.regWithItem(name, blockFactory, 0);
    }

    public static <T extends class_2248> RegSupplier<T> regWithItem(String name, Supplier<T> blockFactory, int burnTime) {
        return RegUtils.regWithItem(name, blockFactory, new class_1792.class_1793(), burnTime);
    }

    public static <T extends class_2248> RegSupplier<T> regWithItem(String name, Supplier<T> blockFactory, class_1792.class_1793 properties, int burnTime) {
        RegSupplier<T> block = RegUtils.regBlock(name, blockFactory);
        RegUtils.regBlockItem(name, block, properties, burnTime);
        return block;
    }

    public static RegSupplier<class_1747> regBlockItem(String name, Supplier<? extends class_2248> blockSup, class_1792.class_1793 properties, int burnTime) {
        return RegHelper.registerItem((class_2960)Supplementaries.res(name), () -> burnTime == 0 ? new class_1747((class_2248)blockSup.get(), properties) : new WoodBasedBlockItem((class_2248)blockSup.get(), properties, burnTime));
    }

    public static Map<class_1767, Supplier<class_2248>> registerCandleHolders(class_2960 baseName) {
        Object2ObjectLinkedOpenHashMap map = new Object2ObjectLinkedOpenHashMap();
        class_4970.class_2251 prop = class_4970.class_2251.method_9637().method_9634().method_50012(class_3619.field_15971).method_22488().method_9618().method_9626(class_2498.field_17734);
        RegSupplier block = RegHelper.registerBlockWithItem((class_2960)baseName, () -> new CandleHolderBlock(null, prop));
        map.put(null, block);
        for (class_1767 color : BlocksColorAPI.SORTED_COLORS) {
            String name = baseName.method_12832() + "_" + color.method_7792();
            RegSupplier coloredBlock = RegHelper.registerBlockWithItem((class_2960)new class_2960(baseName.method_12836(), name), () -> new CandleHolderBlock(color, prop));
            map.put(color, coloredBlock);
        }
        if (CompatHandler.BUZZIER_BEES) {
            BuzzierBeesCompat.registerCandle(baseName);
        }
        if (CompatHandler.CAVE_ENHANCEMENTS) {
            CaveEnhancementsCompat.registerCandle(baseName);
        }
        return map;
    }

    public static Map<class_1767, Supplier<class_2248>> registerFlags(String baseName) {
        Object2ObjectLinkedOpenHashMap map = new Object2ObjectLinkedOpenHashMap();
        for (class_1767 color : BlocksColorAPI.SORTED_COLORS) {
            String name = baseName + "_" + color.method_7792();
            RegSupplier<class_2248> block = RegUtils.regBlock(name, () -> new FlagBlock(color, class_4970.class_2251.method_9637().method_50013().method_31710(color.method_7794()).method_9632(1.0f).method_22488().method_9626(class_2498.field_11547)));
            map.put(color, block);
            RegUtils.regItem(name, () -> new FlagItem((class_2248)block.get(), new class_1792.class_1793().method_7889(16)));
        }
        return map;
    }

    public static Map<class_1767, Supplier<class_2248>> registerPresents(String baseName, BiFunction<class_1767, class_4970.class_2251, class_2248> presentFactory) {
        Object2ObjectLinkedOpenHashMap map = new Object2ObjectLinkedOpenHashMap();
        RegSupplier<class_2248> block = RegUtils.regBlock(baseName, () -> (class_2248)presentFactory.apply(null, class_4970.class_2251.method_9637().method_31710(class_3620.field_15996).method_50012(class_3619.field_15971).method_9632(1.0f).method_9626((class_2498)ModSounds.PRESENT)));
        map.put(null, block);
        RegUtils.regItem(baseName, () -> new PresentItem((class_2248)block.get(), new class_1792.class_1793()));
        for (class_1767 color : BlocksColorAPI.SORTED_COLORS) {
            String name = baseName + "_" + color.method_7792();
            RegSupplier<class_2248> bb = RegUtils.regBlock(name, () -> (class_2248)presentFactory.apply(color, class_4970.class_2251.method_9637().method_31710(color.method_7794()).method_9632(1.0f).method_9626((class_2498)ModSounds.PRESENT)));
            map.put(color, bb);
            RegUtils.regItem(name, () -> new PresentItem((class_2248)bb.get(), new class_1792.class_1793()));
        }
        return map;
    }

    private static void registerSignPostItems(Registrator<class_1792> event, Collection<WoodType> woodTypes) {
        for (WoodType wood : woodTypes) {
            String name = wood.getVariantId("sign_post");
            SignPostItem item = new SignPostItem(new class_1792.class_1793().method_7889(16), wood);
            wood.addChild("supplementaries:sign_post", (Object)item);
            event.register(Supplementaries.res(name), (Object)item);
            ModRegistry.SIGN_POST_ITEMS.put(wood, item);
        }
    }
}

