/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.utils;

import com.google.common.base.Suppliers;
import java.util.Calendar;
import java.util.function.Supplier;
import net.mehvahdjukaar.supplementaries.configs.ClientConfigs;
import net.mehvahdjukaar.supplementaries.integration.CompatHandler;
import net.mehvahdjukaar.supplementaries.integration.TetraCompat;
import net.mehvahdjukaar.supplementaries.reg.ModTags;
import net.minecraft.class_1766;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1829;
import net.minecraft.class_1835;
import net.minecraft.class_1836;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2627;

public class MiscUtils {
    public static final Festivity FESTIVITY = Festivity.get();
    private static final Supplier<class_2627> SHULKER_TILE = Suppliers.memoize(() -> new class_2627(class_2338.field_10980, class_2246.field_10603.method_9564()));

    public static boolean showsHints(class_1922 worldIn, class_1836 flagIn) {
        if (worldIn instanceof class_1937) {
            class_1937 l = (class_1937)worldIn;
            if (l.field_9236) {
                return ClientConfigs.General.TOOLTIP_HINTS.get();
            }
        }
        return false;
    }

    public static boolean isSword(class_1792 i) {
        if (i.method_40131().method_40220(ModTags.STATUE_SWORDS)) {
            return true;
        }
        if (CompatHandler.TETRA && TetraCompat.isTetraSword(i)) {
            return true;
        }
        return i instanceof class_1829;
    }

    public static boolean isTool(class_1792 i) {
        if (i.method_40131().method_40220(ModTags.STATUE_TOOLS)) {
            return true;
        }
        if (CompatHandler.TETRA && TetraCompat.isTetraTool(i)) {
            return true;
        }
        return i instanceof class_1766 || i instanceof class_1835;
    }

    public static class_238 getDirectionBB(class_2338 pos, class_2350 facing, int offset) {
        class_2338 endPos = pos.method_10079(facing, offset);
        switch (facing) {
            case field_11043: {
                endPos = endPos.method_10069(1, 1, 0);
                break;
            }
            case field_11035: {
                endPos = endPos.method_10069(1, 1, 1);
                pos = pos.method_10069(0, 0, 1);
                break;
            }
            case field_11036: {
                endPos = endPos.method_10069(1, 1, 1);
                pos = pos.method_10069(0, 1, 0);
                break;
            }
            case field_11034: {
                endPos = endPos.method_10069(1, 1, 1);
                pos = pos.method_10069(1, 0, 0);
                break;
            }
            case field_11039: {
                endPos = endPos.method_10069(0, 1, 1);
                break;
            }
            case field_11033: {
                endPos = endPos.method_10069(1, 0, 1);
            }
        }
        return new class_238(pos, endPos);
    }

    public static boolean isAllowedInShulker(class_1799 stack, class_1937 level) {
        class_2627 te = SHULKER_TILE.get();
        te.method_31662(level);
        boolean r = te.method_5492(0, stack, null);
        te.method_31662(null);
        return r;
    }

    public static boolean withinDistanceDown(class_2338 pos, class_243 vector, double distW, double distDown) {
        double dx = vector.method_10216() - ((double)pos.method_10263() + 0.5);
        double dy = vector.method_10214() - ((double)pos.method_10264() + 0.5);
        double dz = vector.method_10215() - ((double)pos.method_10260() + 0.5);
        double myDistW = dx * dx + dz * dz;
        return myDistW < distW * distW && dy < distW && dy > -distDown;
    }

    public static enum Festivity {
        NONE,
        HALLOWEEN,
        APRILS_FOOL,
        CHRISTMAS,
        EARTH_DAY,
        ST_VALENTINE,
        MY_BIRTHDAY,
        MOD_BIRTHDAY;


        public boolean isHalloween() {
            return this == HALLOWEEN;
        }

        public boolean isAprilsFool() {
            return this == APRILS_FOOL;
        }

        public boolean isStValentine() {
            return this == ST_VALENTINE;
        }

        public boolean isChristmas() {
            return this == CHRISTMAS;
        }

        public boolean isEarthDay() {
            return this == EARTH_DAY;
        }

        public boolean isBirthday() {
            return this == MOD_BIRTHDAY || this == MY_BIRTHDAY;
        }

        public float getCandyWrappingIndex() {
            return switch (this) {
                default -> 0.0f;
                case HALLOWEEN -> 0.5f;
                case CHRISTMAS -> 1.0f;
            };
        }

        private static Festivity get() {
            Calendar calendar = Calendar.getInstance();
            int month = calendar.get(2);
            int date = calendar.get(5);
            if (month == 9 && date >= 29 || month == 10 && date <= 1) {
                return HALLOWEEN;
            }
            if (month == 3 && date == 1) {
                return APRILS_FOOL;
            }
            if (month == 1 && date == 14) {
                return ST_VALENTINE;
            }
            if (month == 3 && date == 22) {
                return EARTH_DAY;
            }
            if (month == 11 && date >= 20) {
                return CHRISTMAS;
            }
            if (month == 1 && date == 7) {
                return MY_BIRTHDAY;
            }
            if (month == 9 && date == 9) {
                return MOD_BIRTHDAY;
            }
            return NONE;
        }
    }
}

