/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.misc.mob_container;

import java.util.Optional;
import java.util.UUID;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluid;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.api.CapturedMobInstance;
import net.mehvahdjukaar.supplementaries.api.ICatchableMob;
import net.mehvahdjukaar.supplementaries.common.block.ModBlockProperties;
import net.mehvahdjukaar.supplementaries.common.misc.mob_container.BucketHelper;
import net.mehvahdjukaar.supplementaries.common.misc.mob_container.CapturedMobHandler;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1420;
import net.minecraft.class_1422;
import net.minecraft.class_1646;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3468;
import net.minecraft.class_3612;
import net.minecraft.class_4019;
import net.minecraft.class_5321;
import net.minecraft.class_5761;
import net.minecraft.class_6880;
import net.minecraft.class_7298;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MobContainer {
    private final float width;
    private final float height;
    private final boolean isAquarium;
    @Nullable
    private MobNBTData data;
    @Nullable
    private CapturedMobInstance<?> mobInstance;
    private ICatchableMob mobProperties;
    private boolean needsInitialization = false;

    public MobContainer(float width, float height, boolean isAquarium) {
        this.width = width;
        this.height = height;
        this.isAquarium = isAquarium;
    }

    public class_2487 save(class_2487 tag) {
        if (this.data != null) {
            this.data.save(tag, this.isAquarium);
        }
        return tag;
    }

    public void load(class_2487 tag) {
        MobNBTData d = MobNBTData.load(tag);
        this.setData(d);
    }

    private void setData(@Nullable MobNBTData data) {
        this.data = data;
        this.mobInstance = null;
        this.needsInitialization = true;
    }

    private void initializeEntity(class_1937 level, class_2338 pos) {
        this.needsInitialization = false;
        if (this.data != null && level != null && pos != null) {
            MobNBTData mobNBTData = this.data;
            if (mobNBTData instanceof MobNBTData.Bucket) {
                MobNBTData.Bucket bucketData = (MobNBTData.Bucket)mobNBTData;
                type = BucketHelper.getEntityTypeFromBucket(bucketData.filledBucket.method_7909());
                this.mobProperties = CapturedMobHandler.getDataCap(type, true);
            } else {
                MobNBTData.Entity entityData;
                class_1297 entity;
                type = this.data;
                if (type instanceof MobNBTData.Entity && (entity = MobContainer.createStaticMob(entityData = (MobNBTData.Entity)type, level, pos)) != null) {
                    this.mobProperties = CapturedMobHandler.getCatchableMobCapOrDefault(entity);
                    this.mobInstance = this.mobProperties.createCapturedMobInstance(entity, this.width, this.height);
                    this.mobInstance.onContainerWaterlogged(level.method_8316(pos).method_15772() != class_3612.field_15906);
                    this.updateLightLevel(level, pos);
                }
            }
        }
    }

    public void updateLightLevel(class_1937 level, class_2338 pos) {
        int light = 0;
        if (level != null && !level.field_9236 && this.data != null) {
            class_2680 state;
            if (this.mobProperties != null) {
                light = this.mobProperties.getLightLevel(level, pos);
            }
            if ((Integer)(state = level.method_8320(pos)).method_11654((class_2769)ModBlockProperties.LIGHT_LEVEL_0_15) != light) {
                level.method_8652(pos, (class_2680)state.method_11657((class_2769)ModBlockProperties.LIGHT_LEVEL_0_15, (Comparable)Integer.valueOf(light)), 22);
            }
        }
    }

    @Nullable
    public static class_1297 createStaticMob(MobNBTData.Entity data, @NotNull class_1937 world, class_2338 pos) {
        class_1297 entity = null;
        if (data != null) {
            entity = MobContainer.createEntityFromNBT(data.mobTag, data.uuid, world);
            if (entity == null) {
                return null;
            }
            double px = (double)pos.method_10263() + entity.method_23317();
            double py = (double)pos.method_10264() + entity.method_23318();
            double pz = (double)pos.method_10260() + entity.method_23321();
            entity.method_5814(px, py, pz);
            entity.field_6038 = px;
            entity.field_5971 = py;
            entity.field_5989 = pz;
            entity.field_6014 = px;
            entity.field_6036 = py;
            entity.field_5969 = pz;
        }
        return entity;
    }

    @Nullable
    public static class_1297 createEntityFromNBT(class_2487 tag, @Nullable UUID id, class_1937 world) {
        if (tag != null && tag.method_10545("id")) {
            class_1297 entity = class_1299.method_17842((class_2487)tag, (class_1937)world, o -> o);
            if (id != null && entity != null) {
                entity.method_5826(id);
                if (entity.method_16914()) {
                    entity.method_5665(entity.method_5797());
                }
            }
            return entity;
        }
        return null;
    }

    public boolean interactWithBucket(class_1799 stack, class_1937 world, class_2338 pos, @Nullable class_1657 player, class_1268 hand) {
        class_1792 item = stack.method_7909();
        class_1799 returnStack = class_1799.field_8037;
        if (this.isEmpty()) {
            if (BucketHelper.isFishBucket(item)) {
                world.method_8396(null, pos, class_3417.field_14912, class_3419.field_15245, 1.0f, 1.0f);
                returnStack = new class_1799((class_1935)class_1802.field_8550);
                class_1299<?> type = BucketHelper.getEntityTypeFromBucket(stack.method_7909());
                ICatchableMob cap = CapturedMobHandler.getDataCap(type, true);
                Optional<class_6880<SoftFluid>> f = cap.shouldRenderWithFluid();
                class_2960 fluidId = f.map(h -> ((class_5321)h.method_40230().get()).method_29177()).orElse(null);
                if (stack.method_7960()) {
                    Supplementaries.LOGGER.error("Bucket error 3: name none, bucket " + stack + " fluid, " + fluidId);
                }
                MobNBTData.Bucket data = new MobNBTData.Bucket(null, stack.method_7972(), cap.getFishTextureIndex(), fluidId);
                this.setData(data);
            }
        } else if (item == class_1802.field_8550) {
            class_1799 bucket;
            Object temp;
            MobNBTData cap = this.data;
            if (cap instanceof MobNBTData.Bucket) {
                MobNBTData.Bucket bucketData = (MobNBTData.Bucket)cap;
                world.method_8396(null, pos, class_3417.field_14568, class_3419.field_15245, 1.0f, 1.0f);
                returnStack = bucketData.filledBucket.method_7972();
                this.setData(null);
            } else if (this.data instanceof MobNBTData.Entity && this.mobInstance != null && (temp = this.mobInstance.getEntityForRenderer()) != null && !(bucket = BucketHelper.getBucketFromEntity(temp)).method_7960()) {
                world.method_8396(null, pos, class_3417.field_14568, class_3419.field_15245, 1.0f, 1.0f);
                returnStack = bucket.method_7972();
                this.setData(null);
            }
        }
        if (!returnStack.method_7960()) {
            if (player != null) {
                player.method_7259(class_3468.field_15372.method_14956((Object)item));
                if (!player.method_7337()) {
                    Utils.swapItem((class_1657)player, (class_1268)hand, (class_1799)returnStack);
                }
            }
            return true;
        }
        return false;
    }

    public boolean isEmpty() {
        return this.data == null;
    }

    public void tick(class_1937 pLevel, class_2338 pPos) {
        MobNBTData mobNBTData;
        if (this.needsInitialization) {
            this.initializeEntity(pLevel, pPos);
        }
        if (this.mobInstance != null && (mobNBTData = this.data) instanceof MobNBTData.Entity) {
            MobNBTData.Entity entityData = (MobNBTData.Entity)mobNBTData;
            this.mobInstance.containerTick(pLevel, pPos, entityData.scale, entityData.mobTag);
        }
    }

    public class_1269 onInteract(class_1937 world, class_2338 pos, class_1657 player, class_1268 hand) {
        MobNBTData mobNBTData;
        if (this.mobInstance != null && (mobNBTData = this.data) instanceof MobNBTData.Entity) {
            MobNBTData.Entity entityData = (MobNBTData.Entity)mobNBTData;
            return this.mobInstance.onPlayerInteract(world, pos, player, hand, entityData.mobTag);
        }
        return class_1269.field_5811;
    }

    @Nullable
    public MobNBTData getData() {
        return this.data;
    }

    @Nullable
    public class_1297 getDisplayedMob() {
        if (this.mobInstance != null) {
            return this.mobInstance.getEntityForRenderer();
        }
        return null;
    }

    public Optional<class_6880<SoftFluid>> shouldRenderWithFluid() {
        if (this.data == null || !this.isAquarium || this.mobProperties == null) {
            return Optional.empty();
        }
        return this.mobProperties.shouldRenderWithFluid();
    }

    public static class_2487 createMobHolderItemTag(class_1297 mob, float blockW, float blockH, class_1799 bucketStack, boolean isAquarium) {
        MobNBTData data;
        String name = mob.method_5477().getString();
        ICatchableMob cap = CapturedMobHandler.getCatchableMobCapOrDefault(mob);
        if (isAquarium && !bucketStack.method_7960() && cap.renderAs2DFish()) {
            Optional<class_6880<SoftFluid>> f = cap.shouldRenderWithFluid();
            class_2960 fluidId = f.map(h -> ((class_5321)h.method_40230().get()).method_29177()).orElse(null);
            if (bucketStack.method_7960()) {
                Supplementaries.LOGGER.error("Bucket error 2: name " + name + ", bucket " + bucketStack + " fluid, " + fluidId);
            }
            data = new MobNBTData.Bucket(name, bucketStack, cap.getFishTextureIndex(), fluidId);
        } else {
            Pair<Float, Float> dimensions = MobContainer.calculateMobDimensionsForContainer(mob, blockW, blockH, false);
            float scale = ((Float)dimensions.getLeft()).floatValue();
            float yOffset = ((Float)dimensions.getRight()).floatValue();
            class_2487 mobTag = MobContainer.prepareMobTagForContainer(mob, yOffset);
            if (mobTag == null) {
                return null;
            }
            UUID id = mob.method_5667();
            data = new MobNBTData.Entity(name, mobTag, scale, id);
        }
        class_2487 cmp = new class_2487();
        ((MobNBTData)data).save(cmp, isAquarium && cap.renderAs2DFish());
        return cmp;
    }

    @Nullable
    private static class_2487 prepareMobTagForContainer(class_1297 entity, double yOffset) {
        class_1308 mob;
        double px = 0.5;
        double py = yOffset + 1.0E-4;
        double pz = 0.5;
        entity.method_5814(px, py, pz);
        entity.field_6038 = px;
        entity.field_5971 = py;
        entity.field_5989 = pz;
        if (entity.method_5765()) {
            entity.method_5854().method_5772();
        }
        if (entity instanceof class_1308 && !((mob = (class_1308)entity) instanceof class_7298) && entity instanceof class_5761) {
            mob.method_5971();
        }
        if (entity instanceof class_5761) {
            class_5761 bucketable = (class_5761)entity;
            bucketable.method_6454(true);
        }
        if (entity instanceof class_1309) {
            class_1309 le = (class_1309)entity;
            le.field_6259 = 0.0f;
            le.field_6241 = 0.0f;
            le.field_42108.method_48567(0.0f);
            le.field_42108.method_48568(-le.field_42108.method_48569(), 1.0f);
            le.field_42108.method_48567(0.0f);
            le.field_6254 = 0;
            le.field_6235 = 0;
            le.field_6251 = 0.0f;
        }
        entity.method_36456(0.0f);
        entity.field_5982 = 0.0f;
        entity.field_6004 = 0.0f;
        entity.method_36457(0.0f);
        entity.method_5646();
        entity.field_6008 = 0;
        if (entity instanceof class_1420) {
            class_1420 bat = (class_1420)entity;
            bat.method_6449(true);
        }
        if (entity instanceof class_4019) {
            class_4019 fox = (class_4019)entity;
            fox.method_18302(true);
        }
        if (entity instanceof class_1422) {
            class_1422 abstractFish = (class_1422)entity;
            abstractFish.method_6454(true);
        }
        class_2487 mobTag = new class_2487();
        entity.method_5662(mobTag);
        if (mobTag.method_33133()) {
            Supplementaries.LOGGER.error("failed to capture entity " + entity + "Something went wrong :/");
            return null;
        }
        mobTag.method_10551("Passengers");
        mobTag.method_10551("Leash");
        mobTag.method_10551("UUID");
        if (mobTag.method_10545("FromBucket")) {
            mobTag.method_10556("FromBucket", true);
        }
        if (mobTag.method_10545("FromPot")) {
            mobTag.method_10556("FromPot", true);
        }
        return mobTag;
    }

    public static Pair<Float, Float> calculateMobDimensionsForContainer(class_1297 mob, float blockW, float blockH, boolean waterlogged) {
        float yOffset;
        String name;
        class_1309 livingEntity;
        ICatchableMob cap = CapturedMobHandler.getCatchableMobCapOrDefault(mob);
        float babyScale = 1.0f;
        if (mob instanceof class_1309 && (livingEntity = (class_1309)mob).method_6109()) {
            babyScale = mob instanceof class_1646 ? 1.125f : (mob instanceof class_1296 ? 2.0f : 1.125f);
        }
        float scale = 1.0f;
        float w = mob.method_17681() * babyScale;
        float h = mob.method_17682() * babyScale;
        boolean isAir = cap.shouldHover(mob, waterlogged);
        float aW = w + cap.getHitBoxWidthIncrement(mob);
        float aH = h + cap.getHitBoxHeightIncrement(mob);
        float margin = 0.125f;
        float yMargin = 0.0625f;
        float maxH = blockH - 2.0f * (isAir ? margin : yMargin);
        float maxW = blockW - 2.0f * margin;
        if (aW > maxW || aH > maxH) {
            scale = aW - maxW > aH - maxH ? maxW / aW : maxH / aH;
        }
        if ((name = Utils.getID((class_1299)mob.method_5864()).toString()).equals("iceandfire:fire_dragon") || name.equals("iceandfire:ice_dragon") || name.equals("iceandfire:lightning_dragon")) {
            scale = (float)((double)scale * 0.45);
        }
        float f = yOffset = isAir ? blockH / 2.0f - aH * scale / 2.0f : yMargin;
        if (mob instanceof class_1420) {
            yOffset *= 1.5f;
        }
        return new ImmutablePair((Object)Float.valueOf(scale), (Object)Float.valueOf(yOffset));
    }

    public void clear() {
        this.setData(null);
    }

    public static abstract class MobNBTData {
        protected final String name;
        protected int fishTexture;
        @Nullable
        protected class_2960 fluidID;

        private MobNBTData(String name, int fishTexture, @Nullable class_2960 fluidID) {
            this.name = name;
            this.fishTexture = fishTexture;
            this.fluidID = fluidID;
        }

        public boolean is2DFish() {
            return this.fishTexture != 0;
        }

        public int getFishTexture() {
            return this.fishTexture;
        }

        @Nullable
        public class_2960 getFluidID() {
            return this.fluidID;
        }

        protected abstract void save(class_2487 var1, boolean var2);

        @Nullable
        protected static MobNBTData load(class_2487 tag) {
            if (tag.method_10545("BucketHolder")) {
                return Bucket.of(tag.method_10562("BucketHolder"));
            }
            if (tag.method_10545("MobHolder")) {
                return Entity.of(tag.method_10562("MobHolder"));
            }
            return null;
        }

        @Nullable
        public String getName() {
            return this.name;
        }

        protected static class Bucket
        extends MobNBTData {
            private final class_1799 filledBucket;

            protected Bucket(@Nullable String name, class_1799 filledBucket, int fishTexture, @Nullable class_2960 fluidId) {
                super(Bucket.getDefaultName(name, filledBucket), fishTexture, fluidId);
                this.filledBucket = filledBucket;
            }

            private static String getDefaultName(@Nullable String name, @NotNull class_1799 filledBucket) {
                if (name == null) {
                    class_1299<?> type = BucketHelper.getEntityTypeFromBucket(filledBucket.method_7909());
                    name = type == null ? "Mob" : type.method_5882();
                }
                return name;
            }

            @Override
            protected void save(class_2487 tag, boolean rendersAsFish) {
                class_2487 cmp = new class_2487();
                cmp.method_10582("Name", this.name);
                cmp.method_10566("Bucket", (class_2520)this.filledBucket.method_7953(new class_2487()));
                if (rendersAsFish) {
                    cmp.method_10569("FishTexture", this.fishTexture);
                    if (this.fluidID != null) {
                        cmp.method_10582("Fluid", this.fluidID.toString());
                    }
                }
                tag.method_10566("BucketHolder", (class_2520)cmp);
            }

            private static Bucket of(class_2487 cmp) {
                String name = cmp.method_10558("Name");
                int fish = cmp.method_10550("FishTexture");
                class_1799 bucket = class_1799.method_7915((class_2487)cmp.method_10562("Bucket"));
                class_2960 fluid = null;
                if (cmp.method_10545("Fluid")) {
                    fluid = new class_2960(cmp.method_10558("Fluid"));
                }
                if (bucket.method_7960()) {
                    Supplementaries.LOGGER.error("Bucket error 1: name " + name + ", bucket " + bucket + " fluid, " + fluid);
                }
                return new Bucket(name, bucket, fish, fluid);
            }
        }

        public static class Entity
        extends MobNBTData {
            public final class_2487 mobTag;
            private final float scale;
            @Nullable
            private final UUID uuid;

            protected Entity(String name, class_2487 tag, float scale, UUID uuid) {
                this(name, 0, null, tag, scale, uuid);
            }

            protected Entity(String name, int fishTexture, @Nullable class_2960 fishFluid, class_2487 tag, float scale, UUID uuid) {
                super(name, fishTexture, fishFluid);
                this.mobTag = tag;
                this.scale = scale;
                this.uuid = uuid;
            }

            private static Entity of(class_2487 cmp) {
                String name = cmp.method_10558("Name");
                int fish = cmp.method_10550("FishTexture");
                class_2960 fluid = null;
                if (cmp.method_10545("Fluid")) {
                    fluid = new class_2960(cmp.method_10558("Fluid"));
                }
                class_2487 entityData = cmp.method_10562("EntityData");
                float scale = cmp.method_10583("Scale");
                UUID uuid = cmp.method_10545("UUID") ? cmp.method_25926("UUID") : null;
                return new Entity(name, fish, fluid, entityData, scale, uuid);
            }

            public float getScale() {
                return this.scale;
            }

            @Override
            protected void save(class_2487 tag, boolean isAquarium) {
                class_2487 cmp = new class_2487();
                cmp.method_10582("Name", this.name);
                if (isAquarium) {
                    cmp.method_10569("FishTexture", this.fishTexture);
                    if (this.fluidID != null) {
                        cmp.method_10582("Fluid", this.fluidID.toString());
                    }
                }
                cmp.method_10566("EntityData", (class_2520)this.mobTag);
                cmp.method_10548("Scale", this.scale);
                if (this.uuid != null) {
                    cmp.method_25927("UUID", this.uuid);
                }
                tag.method_10566("MobHolder", (class_2520)cmp);
            }
        }
    }
}

