/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.items;

import java.util.ArrayList;
import java.util.function.Predicate;
import net.mehvahdjukaar.moonlight.api.item.IFirstPersonAnimationProvider;
import net.mehvahdjukaar.moonlight.api.item.IThirdPersonAnimationProvider;
import net.mehvahdjukaar.moonlight.api.item.additional_placements.AdditionalItemPlacementsAPI;
import net.mehvahdjukaar.moonlight.api.util.math.MthUtils;
import net.mehvahdjukaar.supplementaries.common.entities.SlingshotProjectileEntity;
import net.mehvahdjukaar.supplementaries.common.events.overrides.InteractEventsHandler;
import net.mehvahdjukaar.supplementaries.common.items.BombItem;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.mehvahdjukaar.supplementaries.reg.ModSounds;
import net.mehvahdjukaar.supplementaries.reg.ModTags;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1306;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1764;
import net.minecraft.class_1776;
import net.minecraft.class_1778;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1811;
import net.minecraft.class_1823;
import net.minecraft.class_1839;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3468;
import net.minecraft.class_3532;
import net.minecraft.class_4537;
import net.minecraft.class_4587;
import net.minecraft.class_5150;
import net.minecraft.class_5633;
import net.minecraft.class_572;
import net.minecraft.class_5819;
import net.minecraft.class_630;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class SlingshotItem
extends class_1811
implements class_5150,
IFirstPersonAnimationProvider,
IThirdPersonAnimationProvider {
    public SlingshotItem(class_1792.class_1793 properties) {
        super(properties);
    }

    public void method_7840(class_1799 stack, class_1937 world, class_1309 entity, int timeLeft) {
        float power;
        class_1657 player;
        class_1799 projectileStack;
        if (entity instanceof class_1657 && !(projectileStack = (player = (class_1657)entity).method_18808(stack)).method_7960() && this.method_19268().test(projectileStack) && (double)(power = this.getPowerForTime(stack, timeLeft)) >= 0.085) {
            int maxProjectiles = class_1890.method_8225((class_1887)class_1893.field_9108, (class_1799)stack) > 0 ? 3 : 1;
            ArrayList<class_1799> projectiles = new ArrayList<class_1799>();
            for (int p = 0; p < maxProjectiles && this.method_19268().test(projectileStack); ++p) {
                projectiles.add(projectileStack.method_7972());
                if (!player.method_31549().field_7477) {
                    projectileStack.method_7934(1);
                    if (projectileStack.method_7960()) {
                        player.method_31548().method_7378(projectileStack);
                    }
                }
                projectileStack = player.method_18808(stack);
            }
            if (!world.field_9236) {
                float[] pitches = SlingshotItem.getShotPitches(world.method_8409());
                int count = projectiles.size();
                float angle = 10.0f;
                for (int j = 0; j < count; ++j) {
                    boolean stasis = class_1890.method_8225((class_1887)ModRegistry.STASIS_ENCHANTMENT.get(), (class_1799)stack) != 0;
                    class_1268 hand = player.method_6058();
                    power = (float)((double)power * ((CommonConfigs.Tools.SLINGSHOT_RANGE.get() + (stasis ? 0.5 : 0.0)) * 1.1));
                    SlingshotItem.shootProjectile(world, entity, hand, stack, (class_1799)projectiles.get(j), count == 1 ? 1.0f : pitches[j], power, 1.0f, angle * ((float)j - (float)(count - 1) / 2.0f));
                }
            }
            player.method_7259(class_3468.field_15372.method_14956((Object)this));
        }
    }

    private static void shootProjectile(class_1937 level, class_1309 entity, class_1268 hand, class_1799 stack, class_1799 projectileStack, float soundPitch, float power, float accuracy, float yaw) {
        projectileStack.method_7939(1);
        SlingshotProjectileEntity projectile = new SlingshotProjectileEntity(entity, level, projectileStack, stack);
        class_243 vector3d1 = entity.method_18864(1.0f);
        Quaternionf quaternionf = new Quaternionf().setAngleAxis((double)(yaw * ((float)Math.PI / 180)), vector3d1.method_10216(), vector3d1.method_10214(), vector3d1.method_10215());
        Vector3f vector3f = entity.method_5828(1.0f).method_46409();
        vector3f.rotate((Quaternionfc)quaternionf);
        projectile.method_7485(vector3f.x(), vector3f.y(), vector3f.z(), power, accuracy);
        stack.method_7956(1, entity, p -> p.method_20236(hand));
        level.method_8649((class_1297)projectile);
        level.method_43129(null, (class_1297)entity, ModSounds.SLINGSHOT_SHOOT.get(), class_3419.field_15248, 1.0f, soundPitch * (1.0f / (level.field_9229.method_43057() * 0.3f + 0.9f) + power * 0.6f));
    }

    private static float[] getShotPitches(class_5819 random) {
        boolean flag = random.method_43056();
        return new float[]{SlingshotItem.getRandomShotPitch(random, flag), 1.0f, SlingshotItem.getRandomShotPitch(random, !flag)};
    }

    private static float getRandomShotPitch(class_5819 random, boolean left) {
        float f = left ? 0.63f : 0.43f;
        return 1.0f / (random.method_43057() * 0.5f + 1.8f) + f;
    }

    public float getPowerForTime(class_1799 stack, float timeLeft) {
        float useTime = (float)this.method_7881(stack) - timeLeft;
        float f = useTime / (float)SlingshotItem.getChargeDuration(stack);
        if ((f = (f * f + f * 2.0f) / 3.0f) > 1.0f) {
            f = 1.0f;
        }
        return f;
    }

    public int method_7881(class_1799 stack) {
        return 72000;
    }

    public static int getChargeDuration(class_1799 stack) {
        int i = class_1890.method_8225((class_1887)class_1893.field_9098, (class_1799)stack);
        int maxCharge = CommonConfigs.Tools.SLINGSHOT_CHARGE.get();
        return i == 0 ? maxCharge : maxCharge - maxCharge / 4 * i;
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 player, class_1268 hand) {
        class_1799 itemstack = player.method_5998(hand);
        boolean flag = this.method_19268().test(player.method_18808(itemstack));
        if (!flag) {
            return class_1271.method_22431((Object)itemstack);
        }
        player.method_6019(hand);
        player.method_37908().method_43129(player, (class_1297)player, this.getChargeSound(itemstack), class_3419.field_15248, 1.0f, 1.0f * (1.0f / (world.field_9229.method_43057() * 0.3f + 0.9f)));
        return class_1271.method_22428((Object)itemstack);
    }

    public class_3414 getChargeSound(class_1799 stack) {
        int i = class_1890.method_8225((class_1887)class_1893.field_9098, (class_1799)stack);
        return switch (i) {
            case 0 -> ModSounds.SLINGSHOT_CHARGE_0.get();
            case 1 -> ModSounds.SLINGSHOT_CHARGE_1.get();
            case 2 -> ModSounds.SLINGSHOT_CHARGE_2.get();
            default -> ModSounds.SLINGSHOT_CHARGE_3.get();
        };
    }

    public Predicate<class_1799> method_19268() {
        return s -> {
            class_1792 i = s.method_7909();
            if (i instanceof class_4537) {
                return CommonConfigs.Tools.SLINGSHOT_POTIONS.get();
            }
            if (i instanceof BombItem) {
                return CommonConfigs.Tools.SLINGSHOT_BOMBS.get();
            }
            if (i instanceof class_1823) {
                return CommonConfigs.Tools.SLINGSHOT_SNOWBALL.get();
            }
            if (i instanceof class_1776) {
                return CommonConfigs.Tools.SLINGSHOT_ENDERPEARLS.get();
            }
            if (i instanceof class_1778) {
                return CommonConfigs.Tools.SLINGSHOT_FIRECHARGE.get();
            }
            return !(i instanceof class_5633) && !s.method_31573(ModTags.SLINGSHOT_BLACKLIST) && i instanceof class_1747 || AdditionalItemPlacementsAPI.hasBehavior((class_1792)i) || InteractEventsHandler.hasBlockPlacementAssociated(i);
        };
    }

    public int method_24792() {
        return 10;
    }

    public class_1839 method_7853(class_1799 stack) {
        return class_1839.field_8952;
    }

    public <T extends class_1309> boolean poseLeftArm(class_1799 stack, class_572<T> model, T entity, class_1306 mainHand) {
        if (entity.method_6014() > 0 && entity.method_6030().method_7909() == this) {
            model.field_27433.field_3675 = MthUtils.wrapRad((float)(0.1f + model.field_3398.field_3675));
            model.field_27433.field_3654 = MthUtils.wrapRad((float)(-1.5707964f + model.field_3398.field_3654));
            return true;
        }
        return false;
    }

    public <T extends class_1309> boolean poseRightArm(class_1799 stack, class_572<T> model, T entity, class_1306 mainHand) {
        if (entity.method_6014() > 0 && entity.method_6030().method_7909() == this) {
            model.field_3401.field_3675 = MthUtils.wrapRad((float)(-0.1f + model.field_3398.field_3675));
            model.field_3401.field_3654 = MthUtils.wrapRad((float)(-1.5707964f + model.field_3398.field_3654));
            return true;
        }
        return false;
    }

    public void animateItemFirstPerson(class_1309 entity, class_1799 stack, class_1268 hand, class_4587 matrixStack, float partialTicks, float pitch, float attackAnim, float handHeight) {
        if (entity.method_6115() && entity.method_6014() > 0 && entity.method_6058() == hand) {
            float timeLeft = (float)stack.method_7935() - ((float)entity.method_6014() - partialTicks + 1.0f);
            float f12 = this.getPowerForTime(stack, timeLeft);
            if (f12 > 0.1f) {
                float f15 = class_3532.method_15374((float)((timeLeft - 0.1f) * 1.3f));
                float f18 = f12 - 0.1f;
                float f20 = f15 * f18;
                matrixStack.method_46416(0.0f, f20 * 0.004f, 0.0f);
            }
            matrixStack.method_46416(0.0f, 0.0f, f12 * 0.04f);
            matrixStack.method_22905(1.0f, 1.0f, 1.0f + f12 * 0.2f);
        }
    }

    public static void animateCrossbowCharge(class_630 offHand, class_630 mainHand, class_1309 entity, boolean right) {
        offHand.field_3654 = mainHand.field_3654;
        float f = class_1764.method_7775((class_1799)entity.method_6030());
        float f1 = class_3532.method_15363((float)entity.method_6048(), (float)0.0f, (float)f);
        float f2 = f1 / f;
        offHand.field_3675 = class_3532.method_16439((float)f2, (float)0.4f, (float)0.85f) * (float)(right ? 1 : -1);
        offHand.field_3654 = class_3532.method_16439((float)f2, (float)offHand.field_3654, (float)-1.5707964f);
    }
}

