/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.tiles;

import java.util.List;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.supplementaries.SuppPlatformStuff;
import net.mehvahdjukaar.supplementaries.common.block.ModBlockProperties;
import net.mehvahdjukaar.supplementaries.common.block.blocks.EndermanSkullBlock;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.mehvahdjukaar.supplementaries.reg.ModSounds;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2484;
import net.minecraft.class_2487;
import net.minecraft.class_2549;
import net.minecraft.class_2591;
import net.minecraft.class_2631;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import org.jetbrains.annotations.Nullable;

public class EndermanSkullBlockTile
extends class_2631 {
    private float prevMouthAnim;
    private float mouthAnim;
    private int watchTime;

    public EndermanSkullBlockTile(class_2338 blockPos, class_2680 blockState) {
        super(blockPos, blockState);
    }

    public class_2591<?> method_11017() {
        return ModRegistry.ENDERMAN_SKULL_TILE.get();
    }

    public float getMouthAnimation(float partialTicks) {
        return class_3532.method_16439((float)partialTicks, (float)this.prevMouthAnim, (float)this.mouthAnim);
    }

    public static void tick(class_1937 level, class_2338 pos, class_2680 state, EndermanSkullBlockTile tile) {
        if (level.field_9236) {
            boolean watched = (Boolean)state.method_11654((class_2769)ModBlockProperties.WATCHED);
            tile.prevMouthAnim = tile.mouthAnim;
            tile.mouthAnim = class_3532.method_15363((float)(tile.mouthAnim + (watched ? 0.5f : -0.5f)), (float)0.0f, (float)1.0f);
        } else {
            boolean watched = EndermanSkullBlockTile.isBeingWatched(level, pos, state);
            tile.watchTime = !watched ? 0 : ++tile.watchTime;
            int wantedPower = class_3532.method_15340((int)(watched ? 1 + tile.watchTime / CommonConfigs.Redstone.ENDERMAN_HEAD_INCREMENT.get() : 0), (int)0, (int)15);
            if ((Boolean)state.method_11654((class_2769)ModBlockProperties.WATCHED) != watched || (Integer)state.method_11654((class_2769)EndermanSkullBlock.POWER) != wantedPower) {
                level.method_8501(pos, (class_2680)((class_2680)state.method_11657((class_2769)ModBlockProperties.WATCHED, (Comparable)Boolean.valueOf(watched))).method_11657((class_2769)EndermanSkullBlock.POWER, (Comparable)Integer.valueOf(wantedPower)));
            }
        }
    }

    public static boolean isBeingWatched(class_1937 level, class_2338 pos, class_2680 state) {
        int range = 20;
        List players = level.method_18467(class_1657.class, new class_238(pos.method_10069(-range, -range, -range), pos.method_10069(range, range, range)));
        for (class_1657 player : players) {
            class_3965 hit;
            class_239 result;
            class_1799 itemstack;
            if (SuppPlatformStuff.isEndermanMask(null, player, itemstack = (class_1799)player.method_31548().field_7548.get(3)) || !((result = Utils.rayTrace((class_1297)player, (class_1937)level, (class_3959.class_3960)class_3959.class_3960.field_17559, (class_3959.class_242)class_3959.class_242.field_1348, (double)64.0)) instanceof class_3965) || !(hit = (class_3965)result).method_17777().equals((Object)pos) || !EndermanSkullBlockTile.isLookingAtFace(pos, state, result.method_17784(), hit.method_17780())) continue;
            return true;
        }
        return false;
    }

    private static boolean isLookingAtFace(class_2338 pos, class_2680 state, class_243 location, class_2350 face) {
        if (CommonConfigs.Redstone.ENDERMAN_HEAD_WORKS_FROM_ANY_SIDE.get().booleanValue()) {
            return true;
        }
        if (face.method_10166() == class_2350.class_2351.field_11052) {
            return false;
        }
        if (state.method_28498((class_2769)class_2549.field_11724)) {
            class_2350 f = (class_2350)state.method_11654((class_2769)class_2549.field_11724);
            return f == face;
        }
        if (state.method_28498((class_2769)class_2484.field_11505)) {
            Integer r = (Integer)state.method_11654((class_2769)class_2484.field_11505);
            float angle = (float)r.intValue() * 22.5f;
            if (angle % 90.0f == 0.0f) {
                return class_2350.method_10150((double)angle).method_10153() == face;
            }
            location = location.method_1020(class_243.method_24953((class_2382)pos));
            class_243 relative = location.method_1024(angle * ((float)Math.PI / 180));
            if (relative.field_1352 < -0.25 || relative.field_1352 > 0.25) {
                return false;
            }
            if (relative.field_1350 > 0.0) {
                return false;
            }
        }
        return true;
    }

    protected void method_11007(class_2487 tag) {
        super.method_11007(tag);
        tag.method_10569("WatchTime", this.watchTime);
    }

    public void method_11014(class_2487 tag) {
        super.method_11014(tag);
        this.watchTime = tag.method_10550("WatchTime");
    }

    @Nullable
    public class_2960 method_47888() {
        return ModSounds.IMITATE_ENDERMAN.getId();
    }
}

