/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.tiles;

import com.mojang.authlib.GameProfile;
import java.util.Optional;
import java.util.UUID;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.util.FakePlayerManager;
import net.mehvahdjukaar.moonlight.api.util.math.MthUtils;
import net.mehvahdjukaar.moonlight.core.misc.DummyWorld;
import net.mehvahdjukaar.supplementaries.client.cannon.CannonController;
import net.mehvahdjukaar.supplementaries.common.block.tiles.OpeneableContainerBlockEntity;
import net.mehvahdjukaar.supplementaries.common.entities.SlingshotProjectileEntity;
import net.mehvahdjukaar.supplementaries.common.inventories.CannonContainerMenu;
import net.mehvahdjukaar.supplementaries.reg.ModParticles;
import net.mehvahdjukaar.supplementaries.reg.ModSounds;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1676;
import net.minecraft.class_1703;
import net.minecraft.class_1744;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3908;
import net.minecraft.class_3965;
import net.minecraft.class_4587;
import net.minecraft.class_5819;
import net.minecraft.class_7833;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector4f;

public class CannonBlockTile
extends OpeneableContainerBlockEntity {
    private static final int TIME_TO_FIRE = 40;
    private static final int FIRE_COOLDOWN = 60;
    private float pitch = 0.0f;
    private float prevPitch = 0.0f;
    private float yaw = 0.0f;
    private float prevYaw = 0.0f;
    private float cooldown = 0.0f;
    private float chargeTimer = 0.0f;
    private byte firePower = 1;
    private float projectileDrag = 0.0f;
    private float projectileGravity = 0.0f;
    private static final GameProfile FAKE_PLAYER = new GameProfile(UUID.fromString("11242C44-14d5-1f22-3d27-13D2C45CA355"), "[CANNON_TESTER]");

    public CannonBlockTile(class_2338 pos, class_2680 blockState) {
        super(null, pos, blockState, 2);
    }

    @Override
    protected void method_11007(class_2487 tag) {
        super.method_11007(tag);
        tag.method_10548("yaw", this.yaw);
        tag.method_10548("pitch", this.pitch);
        tag.method_10548("cooldown", this.cooldown);
        tag.method_10548("fire_timer", this.chargeTimer);
        tag.method_10567("fire_power", this.firePower);
    }

    @Override
    public void method_11014(class_2487 tag) {
        super.method_11014(tag);
        this.yaw = tag.method_10583("yaw");
        this.pitch = tag.method_10583("pitch");
        this.cooldown = tag.method_10583("cooldown");
        this.chargeTimer = tag.method_10583("fire_timer");
        this.firePower = tag.method_10571("fire_power");
        if (this.field_11863 != null) {
            this.recalculateProjectileStats();
        }
    }

    public void method_5431() {
        if (this.field_11863 != null) {
            this.recalculateProjectileStats();
        }
    }

    public boolean readyToFire() {
        return this.cooldown == 0.0f && this.chargeTimer == 0.0f && this.hasFuelAndProjectiles();
    }

    public boolean hasFuelAndProjectiles() {
        return !this.getProjectile().method_7960() && !this.getFuel().method_7960() && this.getFuel().method_7947() >= this.firePower;
    }

    public float getCooldown() {
        return this.cooldown;
    }

    public float getFireTimer() {
        return this.chargeTimer;
    }

    public class_2622 getUpdatePacket() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_1799 getProjectile() {
        return this.method_5438(1).method_46651(1);
    }

    public class_1799 getFuel() {
        return this.method_5438(0);
    }

    public float getProjectileDrag() {
        return this.projectileDrag;
    }

    public float getProjectileGravity() {
        return this.projectileGravity;
    }

    public byte getFirePower() {
        return this.firePower;
    }

    public float getYaw(float partialTicks) {
        return class_3532.method_16439((float)partialTicks, (float)this.prevYaw, (float)this.yaw);
    }

    public float getPitch(float partialTicks) {
        return class_3532.method_16439((float)partialTicks, (float)this.prevPitch, (float)this.pitch);
    }

    public void syncAttributes(float yaw, float pitch, byte firePower, boolean fire) {
        this.yaw = yaw;
        this.pitch = pitch;
        this.firePower = firePower;
        if (fire) {
            this.ignite();
        }
    }

    public void setPitch(float pitch) {
        this.pitch = class_3532.method_15393((float)pitch);
    }

    public void setYaw(float yaw) {
        this.yaw = class_3532.method_15393((float)yaw);
    }

    protected class_2561 method_17823() {
        return class_2561.method_43471((String)"gui.supplementaries.cannon");
    }

    public class_1703 method_5465(int id, class_1661 player) {
        return new CannonContainerMenu(id, player, this);
    }

    @Override
    protected void updateBlockState(class_2680 state, boolean b) {
    }

    @Override
    protected void playOpenSound(class_2680 state) {
    }

    @Override
    protected void playCloseSound(class_2680 state) {
    }

    public boolean method_5437(int index, class_1799 stack) {
        if (index == 0) {
            return stack.method_31574(class_1802.field_8054);
        }
        return true;
    }

    public boolean method_5492(int index, class_1799 itemStack, @Nullable class_2350 direction) {
        return this.method_5437(direction == null || direction.method_10166().method_10179() ? 1 : 0, itemStack);
    }

    public boolean method_5493(int index, class_1799 stack, class_2350 direction) {
        return true;
    }

    @Override
    public int[] method_5494(class_2350 side) {
        return new int[]{side.method_10166().method_10179() ? 1 : 0};
    }

    public void use(class_1657 player, class_1268 hand, class_3965 hit) {
        if (player.method_21823()) {
            if (player instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)player;
            } else {
                CannonController.activateCannonCamera(this);
            }
        } else if (player instanceof class_3222) {
            class_3222 sp = (class_3222)player;
            PlatHelper.openCustomMenu((class_3222)sp, (class_3908)this, (class_2338)this.field_11867);
        }
    }

    public void ignite() {
        this.field_11863.method_8396(null, this.field_11867, ModSounds.GUNPOWDER_IGNITE.get(), class_3419.field_15245, 1.0f, 1.8f + this.field_11863.method_8409().method_43057() * 0.2f);
        this.chargeTimer = 1.0f;
        this.field_11863.method_8413(this.field_11867, this.method_11010(), this.method_11010(), 3);
    }

    public static void tick(class_1937 level, class_2338 pos, class_2680 state, CannonBlockTile t) {
        t.prevYaw = t.yaw;
        t.prevPitch = t.pitch;
        if (t.cooldown > 0.0f) {
            t.cooldown -= 0.016666668f;
            if (t.cooldown < 0.0f) {
                t.cooldown = 0.0f;
            }
        }
        if (t.chargeTimer > 0.0f) {
            t.chargeTimer -= 0.025f;
            if (t.chargeTimer <= 0.0f) {
                t.chargeTimer = 0.0f;
                t.fire();
            }
        }
    }

    public void fire() {
        if (this.field_11863.field_9236) {
            class_2338 pos = this.field_11867;
            this.field_11863.method_8406((class_2394)ModParticles.CANNON_FIRE_PARTICLE.get(), (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, (double)(this.pitch * ((float)Math.PI / 180)), (double)(-this.yaw * ((float)Math.PI / 180)), 0.0);
            class_4587 poseStack = new class_4587();
            class_5819 ran = this.field_11863.field_9229;
            poseStack.method_46416((float)pos.method_10263() + 0.5f, (float)pos.method_10264() + 0.5f + 0.0625f, (float)pos.method_10260() + 0.5f);
            poseStack.method_22907(class_7833.field_40716.rotationDegrees(-this.yaw));
            poseStack.method_22907(class_7833.field_40714.rotationDegrees(this.pitch));
            poseStack.method_22904(0.0, 0.0, -1.4);
            this.spawnDustRing(poseStack);
            this.spawnSmokeTrail(poseStack, ran);
        } else {
            this.shootProjectile();
        }
        this.cooldown = 1.0f;
    }

    private boolean shootProjectile() {
        class_2338 pos = this.field_11867;
        class_243 facing = class_243.method_1030((float)this.pitch, (float)this.yaw).method_1021(0.01);
        class_1799 projectile = this.getProjectile();
        class_1297 proj = CannonBlockTile.getProjectileFromItemHack(this.field_11863, projectile);
        if (proj instanceof class_1676) {
            class_1676 arrow = (class_1676)proj;
            arrow.field_33399 = null;
            arrow.field_22478 = null;
            class_2487 c = new class_2487();
            arrow.method_5662(c);
            Optional opt = class_1299.method_5892((class_2487)c, (class_1937)this.field_11863);
            if (opt.isPresent()) {
                arrow = (class_1676)opt.get();
                arrow.method_5814((double)pos.method_10263() + 0.5 - facing.field_1352, (double)pos.method_10264() + 0.5 - facing.field_1351, (double)pos.method_10260() + 0.5 - facing.field_1350);
                float inaccuracy = 0.0f;
                float power = -this.projectileDrag * (float)this.getFirePower();
                arrow.method_7485(facing.field_1352, facing.field_1351, facing.field_1350, power, inaccuracy);
                this.field_11863.method_8649((class_1297)arrow);
                return true;
            }
        }
        return false;
    }

    private void spawnSmokeTrail(class_4587 poseStack, class_5819 ran) {
        int smokeCount = 20;
        for (int i = 0; i < smokeCount; ++i) {
            poseStack.method_22903();
            Vector4f speed = poseStack.method_23760().method_23761().transform(new Vector4f(0.0f, 0.0f, -MthUtils.nextWeighted((class_5819)ran, (float)0.5f, (float)1.0f, (float)0.06f), 0.0f));
            float aperture = 0.5f;
            poseStack.method_46416(-aperture / 2.0f + ran.method_43057() * aperture, -aperture / 2.0f + ran.method_43057() * aperture, 0.0f);
            Vector4f p = poseStack.method_23760().method_23761().transform(new Vector4f(0.0f, 0.0f, 1.0f, 1.0f));
            this.field_11863.method_8406((class_2394)class_2398.field_11251, (double)p.x, (double)p.y, (double)p.z, (double)speed.x, (double)speed.y, (double)speed.z);
            poseStack.method_22909();
        }
    }

    private void spawnDustRing(class_4587 poseStack) {
        poseStack.method_22903();
        Vector4f p = poseStack.method_23760().method_23761().transform(new Vector4f(0.0f, 0.0f, 1.0f, 1.0f));
        int dustCount = 16;
        for (int i = 0; i < dustCount; ++i) {
            poseStack.method_22903();
            poseStack.method_22907(class_7833.field_40716.rotationDegrees(90.0f));
            poseStack.method_22907(class_7833.field_40714.rotationDegrees(380.0f * (float)i / (float)dustCount));
            Vector4f speed = poseStack.method_23760().method_23761().transform(new Vector4f(0.0f, 0.0f, 0.05f, 0.0f));
            this.field_11863.method_8406((class_2394)ModParticles.BOMB_SMOKE_PARTICLE.get(), (double)p.x, (double)p.y, (double)p.z, (double)speed.x, (double)speed.y, (double)speed.z);
            poseStack.method_22909();
        }
        poseStack.method_22909();
    }

    private static class_1297 getProjectileFromItemHack(class_1937 level, class_1799 projectile) {
        class_1657 fakePlayer = FakePlayerManager.get((GameProfile)FAKE_PLAYER, (class_1937)level);
        class_1792 class_17922 = projectile.method_7909();
        if (class_17922 instanceof class_1744) {
            class_1744 ai = (class_1744)class_17922;
            return ai.method_7702(level, projectile, (class_1309)fakePlayer);
        }
        ProjectileTestLevel testLevel = (ProjectileTestLevel)ProjectileTestLevel.getCachedInstance((String)"cannon_test_level", ProjectileTestLevel::new);
        testLevel.setup();
        fakePlayer.method_6122(class_1268.field_5808, projectile.method_7972());
        projectile.method_7913((class_1937)testLevel, fakePlayer, class_1268.field_5808);
        class_1297 p = testLevel.projectile;
        if (p != null) {
            return p;
        }
        if (projectile.method_31574(class_1802.field_8814)) {
            return class_1299.field_6049.method_5883(level);
        }
        return new SlingshotProjectileEntity(level, projectile, class_1799.field_8037);
    }

    private void recalculateProjectileStats() {
        class_1799 projectile = this.getProjectile();
        if (projectile.method_7960()) {
            return;
        }
        class_1297 proj = CannonBlockTile.getProjectileFromItemHack(this.field_11863, projectile);
        proj.method_18800(1.0, 0.0, 0.0);
        proj.method_5773();
        class_243 newMovement = proj.method_18798();
        this.projectileDrag = (float)newMovement.field_1352;
        this.projectileGravity = (float)(-newMovement.field_1351);
    }

    private static class ProjectileTestLevel
    extends DummyWorld {
        private class_1297 projectile = null;

        public ProjectileTestLevel() {
            super(false, false);
        }

        public void setup() {
            this.projectile = null;
        }

        public boolean method_8649(class_1297 entity) {
            this.projectile = entity;
            return true;
        }
    }
}

