/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.entities;

import javax.annotation.Nullable;
import net.mehvahdjukaar.supplementaries.entities.ImprovedProjectileEntity;
import net.mehvahdjukaar.supplementaries.setup.ModRegistry;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.projectile.ProjectileItemEntity;
import net.minecraft.item.Item;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.IPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.FMLPlayMessages;
import net.minecraftforge.fml.network.NetworkHooks;

public class ShardProjectileEntity
extends ImprovedProjectileEntity {
    private BlockState lastState;
    private Entity ignoreEntity = null;

    public ShardProjectileEntity(EntityType<? extends ShardProjectileEntity> type, World world) {
        super(type, world);
    }

    public ShardProjectileEntity(World worldIn, LivingEntity throwerIn, double x, double y, double z, Vector3d movement, @Nullable Entity ignore) {
        super((EntityType<? extends ProjectileItemEntity>)((EntityType)ModRegistry.AMETHYST_SHARD.get()), x, y, z, worldIn);
        this.func_212361_a((Entity)throwerIn);
        this.func_213317_d(movement);
        this.ignoreEntity = ignore;
    }

    public ShardProjectileEntity(FMLPlayMessages.SpawnEntity packet, World world) {
        super((EntityType<? extends ProjectileItemEntity>)((EntityType)ModRegistry.AMETHYST_SHARD.get()), world);
    }

    @Override
    public void func_213281_b(CompoundNBT tag) {
        super.func_213281_b(tag);
        if (this.lastState != null) {
            tag.func_218657_a("inBlockState", (INBT)NBTUtil.func_190009_a((BlockState)this.lastState));
        }
    }

    @Override
    public void func_70037_a(CompoundNBT tag) {
        super.func_70037_a(tag);
        if (tag.func_150297_b("inBlockState", 10)) {
            this.lastState = NBTUtil.func_190008_d((CompoundNBT)tag.func_74775_l("inBlockState"));
        }
    }

    @Override
    public void spawnTrailParticles(Vector3d currentPos, Vector3d newPos) {
        double x = currentPos.field_72450_a;
        double y = currentPos.field_72448_b;
        double z = currentPos.field_72449_c;
        double dx = newPos.field_72450_a - x;
        double dy = newPos.field_72448_b - y;
        double dz = newPos.field_72449_c - z;
        int s = 2;
        for (int i = 0; i < s; ++i) {
            double j = (double)i / (double)s;
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197614_g, x + dx * j, y + dy * j, z + dz * j, -dx, -dy + 0.2, -dz);
        }
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected Item func_213885_i() {
        return (Item)ModRegistry.AMETHYST_SHARD_ITEM.get();
    }

    public void func_70103_a(byte id) {
    }

    protected void func_230299_a_(BlockRayTraceResult hit) {
        this.lastState = this.field_70170_p.func_180495_p(hit.func_216350_a());
        super.func_230299_a_(hit);
        Vector3d vector3d = hit.func_216347_e().func_178786_a(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
        this.func_213317_d(vector3d);
        Vector3d vector3d1 = vector3d.func_72432_b().func_186678_a((double)this.func_70185_h());
        this.func_226288_n_(this.func_226277_ct_() - vector3d1.field_72450_a, this.func_226278_cu_() - vector3d1.field_72448_b, this.func_226281_cx_() - vector3d1.field_72449_c);
        this.touchedGround = true;
    }

    protected void func_213868_a(EntityRayTraceResult p_213868_1_) {
        Entity entity2 = p_213868_1_.func_216348_a();
        int i = 2;
        entity2.func_70097_a(DamageSource.func_76356_a((Entity)this, (Entity)this.func_234616_v_()), (float)i);
    }

    protected boolean func_230298_a_(Entity entity2) {
        if (entity2 == this.ignoreEntity) {
            return false;
        }
        return super.func_230298_a_(entity2);
    }

    public boolean func_189652_ae() {
        return false;
    }
}

