/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.block.tiles;

import java.util.function.Supplier;
import net.mehvahdjukaar.supplementaries.block.BlockProperties;
import net.mehvahdjukaar.supplementaries.block.blocks.FrameBlock;
import net.mehvahdjukaar.supplementaries.block.tiles.MimicBlockTile;
import net.mehvahdjukaar.supplementaries.configs.ServerConfigs;
import net.mehvahdjukaar.supplementaries.setup.ModRegistry;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SoundType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelDataManager;
import net.minecraftforge.common.util.Lazy;

public class FrameBlockTile
extends MimicBlockTile {
    public final Lazy<BlockState> WATTLE_AND_DAUB = Lazy.of(() -> ((FrameBlock)this.func_195044_w().func_177230_c()).daub.get().func_176223_P());

    public FrameBlockTile() {
        this(() -> null);
    }

    public FrameBlockTile(Supplier<Block> wattle_and_daub) {
        super((TileEntityType)ModRegistry.TIMBER_FRAME_TILE.get());
    }

    @Override
    public boolean setHeldBlock(BlockState state) {
        this.mimic = state;
        if (!this.field_145850_b.field_72995_K) {
            this.func_70296_d();
            int newLight = this.getLightValue();
            this.field_145850_b.func_180501_a(this.field_174879_c, (BlockState)((BlockState)this.func_195044_w().func_206870_a((Property)FrameBlock.HAS_BLOCK, (Comparable)Boolean.valueOf(true))).func_206870_a((Property)FrameBlock.LIGHT_LEVEL, (Comparable)Integer.valueOf(newLight)), 3);
            this.field_145850_b.func_184138_a(this.field_174879_c, this.func_195044_w(), this.func_195044_w(), 2);
        }
        return true;
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        if (compound.func_74764_b("Held")) {
            this.mimic = NBTUtil.func_190008_d((CompoundNBT)compound.func_74775_l("Held"));
        }
    }

    public int getLightValue() {
        return this.getHeldBlock().func_185906_d();
    }

    public BlockState acceptBlock(BlockState state) {
        Block b = state.func_177230_c();
        if (b == ModRegistry.DAUB.get() && ServerConfigs.cached.REPLACE_DAUB) {
            if (!this.field_145850_b.field_72995_K) {
                state = (BlockState)this.WATTLE_AND_DAUB.get();
                if (this.func_195044_w().func_235901_b_((Property)BlockProperties.FLIPPED)) {
                    state = (BlockState)state.func_206870_a((Property)BlockProperties.FLIPPED, this.func_195044_w().func_177229_b((Property)BlockProperties.FLIPPED));
                }
                this.field_145850_b.func_180501_a(this.field_174879_c, state, 3);
            }
        } else {
            this.setHeldBlock(state);
            if (this.field_145850_b.func_201670_d()) {
                ModelDataManager.requestModelDataRefresh((TileEntity)this);
            }
        }
        return state;
    }

    public ActionResultType handleInteraction(PlayerEntity player, Hand hand, BlockRayTraceResult trace) {
        BlockState toPlace;
        ItemStack stack = player.func_184586_b(hand);
        Item item2 = stack.func_77973_b();
        if (player.field_71075_bZ.field_75099_e && item2 instanceof BlockItem && this.getHeldBlock().func_196958_f() && FrameBlockTile.isValidBlock(toPlace = ((BlockItem)item2).func_179223_d().func_196258_a(new BlockItemUseContext(player, hand, stack, trace)), this.field_174879_c, this.field_145850_b)) {
            BlockState newState = this.acceptBlock(toPlace);
            SoundType s = newState.getSoundType((IWorldReader)this.field_145850_b, this.field_174879_c, (Entity)player);
            this.field_145850_b.func_184133_a(player, this.field_174879_c, s.func_185841_e(), SoundCategory.BLOCKS, (s.func_185843_a() + 1.0f) / 2.0f, s.func_185847_b() * 0.8f);
            if (!player.func_184812_l_() && !this.field_145850_b.func_201670_d()) {
                stack.func_190918_g(1);
            }
            return ActionResultType.func_233537_a_((boolean)this.field_145850_b.field_72995_K);
        }
        return ActionResultType.FAIL;
    }

    public static boolean isValidBlock(BlockState state, BlockPos pos, World world) {
        Block b = state.func_177230_c();
        if (b == Blocks.field_150357_h) {
            return false;
        }
        if (b == ModRegistry.DAUB_FRAME.get() || b == ModRegistry.DAUB_BRACE.get() || b == ModRegistry.DAUB_CROSS_BRACE.get()) {
            return false;
        }
        if (b.hasTileEntity(state)) {
            return false;
        }
        return state.func_200015_d((IBlockReader)world, pos);
    }
}

