/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.block.blocks;

import java.util.Random;
import net.mehvahdjukaar.selene.util.Utils;
import net.mehvahdjukaar.supplementaries.block.util.ILightable;
import net.mehvahdjukaar.supplementaries.common.ModTags;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.PotionEntity;
import net.minecraft.entity.projectile.ProjectileEntity;
import net.minecraft.entity.projectile.ProjectileItemEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.FireChargeItem;
import net.minecraft.item.FlintAndSteelItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.PotionItem;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.PotionUtils;
import net.minecraft.potion.Potions;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;

public abstract class LightUpBlock
extends Block
implements ILightable {
    public static final BooleanProperty LIT = BlockStateProperties.field_208190_q;

    public LightUpBlock(AbstractBlock.Properties properties) {
        super(properties);
    }

    public boolean isLit(BlockState state) {
        return (Boolean)state.func_177229_b((Property)LIT);
    }

    public BlockState toggleLitState(BlockState state, boolean lit) {
        return (BlockState)state.func_206870_a((Property)LIT, (Comparable)Boolean.valueOf(lit));
    }

    public boolean func_225541_a_(BlockState state, Fluid fluid) {
        return this.field_149764_J.func_76222_j();
    }

    public void onChange(BlockState state, IWorld world, BlockPos pos) {
    }

    @Override
    public boolean lightUp(BlockState state, BlockPos pos, IWorld world, ILightable.FireSound sound) {
        if (!this.isLit(state)) {
            if (!world.func_201670_d()) {
                world.func_180501_a(pos, this.toggleLitState(state, true), 11);
                sound.play(world, pos);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean extinguish(BlockState state, BlockPos pos, IWorld world) {
        if (this.isLit(state)) {
            if (!world.func_201670_d()) {
                world.func_184133_a(null, pos, SoundEvents.field_187541_bC, SoundCategory.BLOCKS, 0.5f, 1.5f);
                world.func_180501_a(pos, this.toggleLitState(state, false), 11);
            } else {
                Random random = world.func_201674_k();
                for (int i = 0; i < 10; ++i) {
                    world.func_195594_a((IParticleData)ParticleTypes.field_197601_L, (double)((float)pos.func_177958_n() + 0.25f + random.nextFloat() * 0.5f), (double)((float)pos.func_177956_o() + 0.35f + random.nextFloat() * 0.5f), (double)((float)pos.func_177952_p() + 0.25f + random.nextFloat() * 0.5f), 0.0, 0.005, 0.0);
                }
            }
            return true;
        }
        return false;
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (!this.isLit(state) && player.field_71075_bZ.field_75099_e) {
            ItemStack stack = player.func_184586_b(handIn);
            Item item2 = stack.func_77973_b();
            if (item2 instanceof FlintAndSteelItem || item2.func_206844_a(ModTags.FIRE_SOURCES)) {
                if (this.lightUp(state, pos, (IWorld)worldIn, ILightable.FireSound.FLINT_AND_STEEL)) {
                    this.onChange(state, (IWorld)worldIn, pos);
                    stack.func_222118_a(1, (LivingEntity)player, playerIn -> playerIn.func_213334_d(handIn));
                    return ActionResultType.func_233537_a_((boolean)worldIn.field_72995_K);
                }
            } else if (item2 instanceof FireChargeItem) {
                if (this.lightUp(state, pos, (IWorld)worldIn, ILightable.FireSound.FIRE_CHANGE)) {
                    this.onChange(state, (IWorld)worldIn, pos);
                    stack.func_222118_a(1, (LivingEntity)player, playerIn -> playerIn.func_213334_d(handIn));
                    if (!player.func_184812_l_()) {
                        stack.func_190918_g(1);
                    }
                    return ActionResultType.func_233537_a_((boolean)worldIn.field_72995_K);
                }
            } else if (item2 instanceof PotionItem && PotionUtils.func_185191_c((ItemStack)stack) == Potions.field_185230_b && this.extinguish(state, pos, (IWorld)worldIn)) {
                this.onChange(state, (IWorld)worldIn, pos);
                Utils.swapItem((PlayerEntity)player, (Hand)handIn, (ItemStack)stack, (ItemStack)new ItemStack((IItemProvider)Items.field_151069_bo));
                return ActionResultType.func_233537_a_((boolean)worldIn.field_72995_K);
            }
        }
        return ActionResultType.PASS;
    }

    public void func_196262_a(BlockState state, World worldIn, BlockPos pos, Entity entityIn) {
        if (entityIn instanceof ProjectileEntity) {
            ProjectileEntity projectile = (ProjectileEntity)entityIn;
            if (projectile.func_70027_ad()) {
                Entity entity2 = projectile.func_234616_v_();
                if ((entity2 == null || entity2 instanceof PlayerEntity || ForgeEventFactory.getMobGriefingEvent((World)worldIn, (Entity)entity2)) && this.lightUp(state, pos, (IWorld)worldIn, ILightable.FireSound.FLAMING_ARROW)) {
                    this.onChange(state, (IWorld)worldIn, pos);
                }
            } else if (projectile instanceof PotionEntity && PotionUtils.func_185191_c((ItemStack)((ProjectileItemEntity)projectile).func_184543_l()) == Potions.field_185230_b) {
                boolean flag;
                Entity entity3 = projectile.func_234616_v_();
                boolean bl = flag = entity3 == null || entity3 instanceof PlayerEntity || ForgeEventFactory.getMobGriefingEvent((World)worldIn, (Entity)entity3);
                if (flag && this.extinguish(state, pos, (IWorld)worldIn)) {
                    this.onChange(state, (IWorld)worldIn, pos);
                }
            }
        }
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        boolean flag = context.func_195991_k().func_204610_c(context.func_195995_a()).func_206886_c() == Fluids.field_204546_a;
        BlockState state = this.func_176223_P();
        return this.toggleLitState(state, !flag);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{LIT});
    }
}

