/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.generator;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.supermartijn642.core.data.tag.CustomTagEntry;
import com.supermartijn642.core.generator.ResourceCache;
import com.supermartijn642.core.generator.ResourceGenerator;
import com.supermartijn642.core.generator.ResourceType;
import com.supermartijn642.core.generator.aggregator.ResourceAggregator;
import com.supermartijn642.core.registry.Registries;
import com.supermartijn642.core.registry.RegistryUtil;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_1299;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_3481;
import net.minecraft.class_3497;
import net.minecraft.class_3505;
import net.minecraft.class_5321;
import net.minecraft.class_6862;

public abstract class TagGenerator
extends ResourceGenerator {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static final ResourceAggregator<TagBuilder<?>, TagBuilder<?>> AGGREGATOR = new ResourceAggregator<TagBuilder<?>, TagBuilder<?>>(){

        @Override
        public TagBuilder<?> initialData() {
            return null;
        }

        @Override
        public TagBuilder<?> combine(TagBuilder<?> data, TagBuilder<?> newData) {
            if (data != null) {
                data.addAll(newData);
                return data;
            }
            return newData;
        }

        @Override
        public void write(OutputStream stream, TagBuilder<?> tag) throws IOException {
            JsonObject json = new JsonObject();
            json.addProperty("replace", Boolean.valueOf(tag.replace));
            JsonArray entries = new JsonArray();
            tag.entries.stream().map(entry -> (JsonElement)class_3497.field_39265.encodeStart((DynamicOps)JsonOps.INSTANCE, entry).getOrThrow(false, s -> {})).forEach(arg_0 -> ((JsonArray)entries).add(arg_0));
            if (!entries.isEmpty() || tag.remove.isEmpty()) {
                json.add("values", (JsonElement)entries);
            }
            JsonArray removedEntries = new JsonArray();
            tag.remove.stream().map(entry -> (JsonElement)class_3497.field_39265.encodeStart((DynamicOps)JsonOps.INSTANCE, entry).getOrThrow(false, s -> {})).forEach(arg_0 -> ((JsonArray)removedEntries).add(arg_0));
            if (!removedEntries.isEmpty()) {
                json.add("remove", (JsonElement)removedEntries);
            }
            try (OutputStreamWriter writer = new OutputStreamWriter(stream);){
                GSON.toJson((JsonElement)json, (Appendable)writer);
            }
        }
    };
    private final Map<Registries.Registry<?>, Map<class_2960, TagBuilder<?>>> tags = new HashMap();

    public TagGenerator(String modid, ResourceCache cache) {
        super(modid, cache);
    }

    @Override
    public void save() {
        for (Map.Entry<Registries.Registry<?>, Map<class_2960, TagBuilder<?>>> registryEntry : this.tags.entrySet()) {
            String directoryName = TagGenerator.getTagDirectoryName(registryEntry.getKey());
            for (TagBuilder<?> tag : registryEntry.getValue().values()) {
                for (class_3497 entry : tag.entries) {
                    if (!entry.field_39267 || !entry.field_39268) continue;
                    class_2960 reference = entry.field_15584;
                    if (registryEntry.getValue().containsKey(reference) || this.cache.doesResourceExist(ResourceType.DATA, reference.method_12836(), directoryName, reference.method_12832(), ".json")) continue;
                    throw new RuntimeException("Could not find tag reference '" + reference + "' in '" + tag.identifier + "'!");
                }
                class_2960 identifier = tag.identifier;
                this.cache.saveResource(ResourceType.DATA, AGGREGATOR, tag, identifier.method_12836(), directoryName, identifier.method_12832(), ".json");
            }
        }
    }

    private static String getTagDirectoryName(Registries.Registry<?> registry) {
        return class_3505.method_40099((class_5321)registry.getVanillaRegistry().method_30517());
    }

    protected <T> TagBuilder<T> tag(Registries.Registry<T> registry, class_2960 identifier) {
        this.cache.trackToBeGeneratedResource(ResourceType.DATA, identifier.method_12836(), TagGenerator.getTagDirectoryName(registry), identifier.method_12832(), ".json");
        return this.tags.computeIfAbsent(registry, o -> new HashMap()).computeIfAbsent(identifier, identifier1 -> new TagBuilder(registry, (class_2960)identifier1));
    }

    protected <T> TagBuilder<T> tag(Registries.Registry<T> registry, class_6862<T> tagKey) {
        return this.tag(registry, tagKey.comp_327());
    }

    protected <T> TagBuilder<T> tag(Registries.Registry<T> registry, String namespace, String identifier) {
        return this.tag(registry, new class_2960(namespace, identifier));
    }

    protected <T> TagBuilder<T> tag(Registries.Registry<T> registry, String identifier) {
        return this.tag(registry, this.modid, identifier);
    }

    protected TagBuilder<class_2248> blockTag(class_2960 identifier) {
        return this.tag(Registries.BLOCKS, identifier);
    }

    protected TagBuilder<class_2248> blockTag(class_6862<class_2248> tagKey) {
        return this.tag(Registries.BLOCKS, tagKey);
    }

    protected TagBuilder<class_2248> blockTag(String namespace, String identifier) {
        return this.tag(Registries.BLOCKS, namespace, identifier);
    }

    protected TagBuilder<class_2248> blockTag(String identifier) {
        return this.tag(Registries.BLOCKS, identifier);
    }

    protected TagBuilder<class_1792> itemTag(class_2960 identifier) {
        return this.tag(Registries.ITEMS, identifier);
    }

    protected TagBuilder<class_1792> itemTag(class_6862<class_1792> tagKey) {
        return this.tag(Registries.ITEMS, tagKey);
    }

    protected TagBuilder<class_1792> itemTag(String namespace, String identifier) {
        return this.tag(Registries.ITEMS, namespace, identifier);
    }

    protected TagBuilder<class_1792> itemTag(String identifier) {
        return this.tag(Registries.ITEMS, identifier);
    }

    protected TagBuilder<class_1299<?>> entityTag(class_2960 identifier) {
        return this.tag(Registries.ENTITY_TYPES, identifier);
    }

    protected TagBuilder<class_1299<?>> entityTag(class_6862<class_1299<?>> tagKey) {
        return this.tag(Registries.ENTITY_TYPES, tagKey);
    }

    protected TagBuilder<class_1299<?>> entityTag(String namespace, String identifier) {
        return this.tag(Registries.ENTITY_TYPES, namespace, identifier);
    }

    protected TagBuilder<class_1299<?>> entityTag(String identifier) {
        return this.tag(Registries.ENTITY_TYPES, identifier);
    }

    protected TagBuilder<class_2248> blockMineableWithAxe() {
        return this.blockTag((class_6862<class_2248>)class_3481.field_33713);
    }

    protected TagBuilder<class_2248> blockMineableWithHoe() {
        return this.blockTag((class_6862<class_2248>)class_3481.field_33714);
    }

    protected TagBuilder<class_2248> blockMineableWithPickaxe() {
        return this.blockTag((class_6862<class_2248>)class_3481.field_33715);
    }

    protected TagBuilder<class_2248> blockMineableWithShovel() {
        return this.blockTag((class_6862<class_2248>)class_3481.field_33716);
    }

    protected TagBuilder<class_2248> blockNeedsStoneTool() {
        return this.blockTag((class_6862<class_2248>)class_3481.field_33719);
    }

    protected TagBuilder<class_2248> blockNeedsIronTool() {
        return this.blockTag((class_6862<class_2248>)class_3481.field_33718);
    }

    protected TagBuilder<class_2248> blockNeedsDiamondTool() {
        return this.blockTag((class_6862<class_2248>)class_3481.field_33717);
    }

    @Override
    public String getName() {
        return this.modName + " Tag Generator";
    }

    protected static class TagBuilder<T> {
        private final Registries.Registry<T> registry;
        protected final class_2960 identifier;
        private final Set<class_3497> entries = new HashSet<class_3497>();
        private final Set<class_3497> remove = new HashSet<class_3497>();
        private boolean replace;

        protected TagBuilder(Registries.Registry<T> registry, class_2960 identifier) {
            this.registry = registry;
            this.identifier = identifier;
        }

        public TagBuilder<T> replace(boolean replace) {
            this.replace = replace;
            return this;
        }

        public TagBuilder<T> replace() {
            return this.replace(true);
        }

        public TagBuilder<T> add(T entry) {
            this.entries.add(new class_3497(this.registry.getIdentifier(entry), false, true));
            return this;
        }

        public TagBuilder<T> add(class_2960 entry) {
            if (!this.registry.hasIdentifier(entry)) {
                throw new RuntimeException("Could not find any object registered under '" + entry + "'!");
            }
            this.entries.add(new class_3497(entry, false, true));
            return this;
        }

        public TagBuilder<T> add(String namespace, String identifier) {
            if (!RegistryUtil.isValidNamespace(namespace)) {
                throw new IllegalArgumentException("Namespace '" + namespace + "' must only contain characters [a-z0-9_.-]!");
            }
            if (!RegistryUtil.isValidPath(identifier)) {
                throw new IllegalArgumentException("Identifier '" + identifier + "' must only contain characters [a-z0-9_./-]!");
            }
            this.add(new class_2960(namespace, identifier));
            return this;
        }

        public TagBuilder<T> add(String entry) {
            if (!RegistryUtil.isValidIdentifier(entry)) {
                throw new IllegalArgumentException("Entry identifier '" + entry + "' contains invalid characters!");
            }
            this.add(new class_2960(entry));
            return this;
        }

        public TagBuilder<T> addOptional(T entry) {
            this.entries.add(new class_3497(this.registry.getIdentifier(entry), false, false));
            return this;
        }

        public TagBuilder<T> addOptional(class_2960 entry) {
            this.entries.add(new class_3497(entry, false, false));
            return this;
        }

        public TagBuilder<T> addOptional(String namespace, String identifier) {
            if (!RegistryUtil.isValidNamespace(namespace)) {
                throw new IllegalArgumentException("Namespace '" + namespace + "' must only contain characters [a-z0-9_.-]!");
            }
            if (!RegistryUtil.isValidPath(identifier)) {
                throw new IllegalArgumentException("Identifier '" + identifier + "' must only contain characters [a-z0-9_./-]!");
            }
            this.addOptional(new class_2960(namespace, identifier));
            return this;
        }

        public TagBuilder<T> addOptional(String entry) {
            if (!RegistryUtil.isValidIdentifier(entry)) {
                throw new IllegalArgumentException("Identifier '" + entry + "' contains invalid characters!");
            }
            this.addOptional(new class_2960(entry));
            return this;
        }

        public TagBuilder<T> addOptional(CustomTagEntry entry) {
            this.entries.add(CustomTagEntry.createVanillaEntry(entry));
            return this;
        }

        public TagBuilder<T> addReference(class_2960 tag) {
            if (this.identifier.equals((Object)tag)) {
                throw new IllegalArgumentException("Cannot add self reference to tag '" + tag + "'!");
            }
            this.entries.add(new class_3497(tag, true, true));
            return this;
        }

        public TagBuilder<T> addReference(class_6862<T> tag) {
            return this.addReference(tag.comp_327());
        }

        public TagBuilder<T> addReference(String namespace, String identifier) {
            if (!RegistryUtil.isValidNamespace(namespace)) {
                throw new IllegalArgumentException("Namespace '" + namespace + "' must only contain characters [a-z0-9_.-]!");
            }
            if (!RegistryUtil.isValidPath(identifier)) {
                throw new IllegalArgumentException("Identifier '" + identifier + "' must only contain characters [a-z0-9_./-]!");
            }
            this.entries.add(new class_3497(new class_2960(namespace, identifier), true, true));
            return this;
        }

        public TagBuilder<T> addReference(String tag) {
            if (!RegistryUtil.isValidIdentifier(tag)) {
                throw new IllegalArgumentException("Tag identifier '" + tag + "' contains invalid characters!");
            }
            this.entries.add(new class_3497(new class_2960(tag), true, true));
            return this;
        }

        public TagBuilder<T> addOptionalReference(class_2960 tag) {
            if (this.identifier.equals((Object)tag)) {
                throw new IllegalArgumentException("Cannot add self reference to tag '" + tag + "'!");
            }
            this.entries.add(new class_3497(tag, true, false));
            return this;
        }

        public TagBuilder<T> addOptionalReference(class_6862<T> tag) {
            return this.addOptionalReference(tag.comp_327());
        }

        public TagBuilder<T> addOptionalReference(String namespace, String identifier) {
            if (!RegistryUtil.isValidNamespace(namespace)) {
                throw new IllegalArgumentException("Namespace '" + namespace + "' must only contain characters [a-z0-9_.-]!");
            }
            if (!RegistryUtil.isValidPath(identifier)) {
                throw new IllegalArgumentException("Identifier '" + identifier + "' must only contain characters [a-z0-9_./-]!");
            }
            this.addOptionalReference(new class_2960(namespace, identifier));
            return this;
        }

        public TagBuilder<T> addOptionalReference(String tag) {
            if (!RegistryUtil.isValidIdentifier(tag)) {
                throw new IllegalArgumentException("Tag identifier '" + tag + "' contains invalid characters!");
            }
            this.addOptionalReference(new class_2960(tag));
            return this;
        }

        public TagBuilder<T> remove(T entry) {
            this.remove.add(new class_3497(this.registry.getIdentifier(entry), false, true));
            return this;
        }

        public TagBuilder<T> remove(class_2960 entry) {
            if (!this.registry.hasIdentifier(entry)) {
                throw new RuntimeException("Could not find any object registered under '" + entry + "'!");
            }
            this.remove.add(new class_3497(entry, false, true));
            return this;
        }

        public TagBuilder<T> remove(String namespace, String identifier) {
            if (!RegistryUtil.isValidNamespace(namespace)) {
                throw new IllegalArgumentException("Namespace '" + namespace + "' must only contain characters [a-z0-9_.-]!");
            }
            if (!RegistryUtil.isValidPath(identifier)) {
                throw new IllegalArgumentException("Identifier '" + identifier + "' must only contain characters [a-z0-9_./-]!");
            }
            this.remove(new class_2960(namespace, identifier));
            return this;
        }

        public TagBuilder<T> remove(String entry) {
            if (!RegistryUtil.isValidIdentifier(entry)) {
                throw new IllegalArgumentException("Entry identifier '" + entry + "' contains invalid characters!");
            }
            this.remove(new class_2960(entry));
            return this;
        }

        public TagBuilder<T> removeOptional(T entry) {
            return this.removeOptional(this.registry.getIdentifier(entry));
        }

        public TagBuilder<T> removeOptional(class_2960 entry) {
            this.remove.add(new class_3497(entry, false, false));
            return this;
        }

        public TagBuilder<T> removeOptional(String namespace, String identifier) {
            if (!RegistryUtil.isValidNamespace(namespace)) {
                throw new IllegalArgumentException("Namespace '" + namespace + "' must only contain characters [a-z0-9_.-]!");
            }
            if (!RegistryUtil.isValidPath(identifier)) {
                throw new IllegalArgumentException("Identifier '" + identifier + "' must only contain characters [a-z0-9_./-]!");
            }
            this.removeOptional(new class_2960(namespace, identifier));
            return this;
        }

        public TagBuilder<T> removeOptional(String entry) {
            if (!RegistryUtil.isValidIdentifier(entry)) {
                throw new IllegalArgumentException("Identifier '" + entry + "' contains invalid characters!");
            }
            this.removeOptional(new class_2960(entry));
            return this;
        }

        private void addAll(TagBuilder<T> other) {
            this.entries.addAll(other.entries);
            this.remove.addAll(other.remove);
        }
    }
}

