/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.items;

import com.ldtteam.structurize.items.ItemBuildTool;
import com.ldtteam.structurize.items.ItemCaliper;
import com.ldtteam.structurize.items.ItemScanTool;
import com.ldtteam.structurize.items.ItemShapeTool;
import com.ldtteam.structurize.items.ItemTagTool;
import com.ldtteam.structurize.items.ModItemGroups;
import java.util.function.Supplier;
import net.minecraft.item.Item;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public final class ModItems {
    private static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"structurize");
    public static final RegistryObject<ItemBuildTool> buildTool;
    public static final RegistryObject<ItemShapeTool> shapeTool;
    public static final RegistryObject<ItemScanTool> scanTool;
    public static final RegistryObject<ItemTagTool> tagTool;
    public static final RegistryObject<ItemCaliper> caliper;

    private ModItems() {
    }

    public static DeferredRegister<Item> getRegistry() {
        return ITEMS;
    }

    public static <I extends Item> RegistryObject<I> register(String name, Supplier<I> item) {
        return ITEMS.register(name.toLowerCase(), item);
    }

    static {
        Item.Properties properties = new Item.Properties().func_200916_a(ModItemGroups.STRUCTURIZE);
        buildTool = ModItems.register("sceptergold", () -> new ItemBuildTool(properties));
        shapeTool = ModItems.register("shapetool", () -> new ItemShapeTool(properties));
        scanTool = ModItems.register("sceptersteel", () -> new ItemScanTool(ModItemGroups.STRUCTURIZE));
        tagTool = ModItems.register("sceptertag", () -> new ItemTagTool(ModItemGroups.STRUCTURIZE));
        caliper = ModItems.register("caliper", () -> new ItemCaliper(properties));
    }
}

