/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.generation;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.ldtteam.datagenerators.loot_table.LootTableJson;
import com.ldtteam.datagenerators.loot_table.LootTableTypeEnum;
import com.ldtteam.datagenerators.loot_table.pool.PoolJson;
import com.ldtteam.datagenerators.loot_table.pool.conditions.survives_explosion.SurvivesExplosionConditionJson;
import com.ldtteam.datagenerators.loot_table.pool.entry.EntryJson;
import com.ldtteam.datagenerators.loot_table.pool.entry.EntryTypeEnum;
import com.ldtteam.structurize.api.blocks.BlockType;
import com.ldtteam.structurize.api.blocks.IBlockCollection;
import com.ldtteam.structurize.api.blocks.IBlockList;
import com.ldtteam.structurize.blocks.ModBlocks;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import net.minecraftforge.fml.RegistryObject;
import org.jetbrains.annotations.NotNull;

public class DefaultBlockLootTableProvider
implements IDataProvider {
    private static final String DATAPACK_DIR = "data/structurize/";
    public static final Gson GSON = new GsonBuilder().disableHtmlEscaping().create();
    public static final String LOOT_TABLES_DIR = "data/structurize/loot_tables/blocks";
    private final DataGenerator generator;

    public DefaultBlockLootTableProvider(DataGenerator generator) {
        this.generator = generator;
    }

    public void func_200398_a(@NotNull DirectoryCache cache) throws IOException {
        this.saveBlocks(ModBlocks.paperWalls.getRegisteredBlocks(), cache);
        this.saveBlocks(ModBlocks.shingleSlabs.getRegisteredBlocks(), cache);
        this.saveBlocks(ModBlocks.floatingCarpets.getRegisteredBlocks(), cache);
        this.saveBlockCollection(ModBlocks.BRICKS, cache);
        this.saveBlockCollection(ModBlocks.CACTI_BLOCKS, cache);
        this.saveBlockList(ModBlocks.timberFrames, cache);
        this.saveBlockList(ModBlocks.shingles, cache);
        this.saveBlock(ModBlocks.blockSubstitution, cache);
        this.saveBlock(ModBlocks.blockTagSubstitution, cache);
        this.saveBlock(ModBlocks.blockSolidSubstitution, cache);
        this.saveBlock(ModBlocks.blockFluidSubstitution, cache);
        this.saveBlock(ModBlocks.blockDecoBarrel_onside, cache);
        this.saveBlock(ModBlocks.blockDecoBarrel_standing, cache);
        this.saveBlock(ModBlocks.multiBlock, cache);
    }

    private void saveBlockCollection(List<IBlockCollection> blocks, DirectoryCache cache) throws IOException {
        for (IBlockCollection collection : blocks) {
            this.saveBlockCollection(collection, cache);
        }
    }

    private void saveBlockCollection(IBlockCollection blocks, DirectoryCache cache) throws IOException {
        for (RegistryObject<Block> block : blocks.getRegisteredBlocks()) {
            if (BlockType.fromSuffix((Block)block.get()) == BlockType.DOOR) continue;
            this.saveBlock(block, cache);
        }
    }

    private <B extends Block, L extends IBlockList<B>> void saveBlockList(List<L> blocks, DirectoryCache cache) throws IOException {
        for (IBlockList list : blocks) {
            this.saveBlockList(list, cache);
        }
    }

    private <B extends Block> void saveBlockList(IBlockList<B> blocks, DirectoryCache cache) throws IOException {
        for (RegistryObject<B> block : blocks.getRegisteredBlocks()) {
            this.saveBlock(block, cache);
        }
    }

    private <T extends Block> void saveBlocks(List<RegistryObject<T>> blocks, DirectoryCache cache) throws IOException {
        for (RegistryObject<T> block : blocks) {
            this.saveBlock(block, cache);
        }
    }

    private void saveBlock(RegistryObject<? extends Block> block, DirectoryCache cache) throws IOException {
        if (((Block)block.get()).getRegistryName() != null) {
            EntryJson entryJson = new EntryJson();
            entryJson.setType(EntryTypeEnum.ITEM);
            entryJson.setName(((Block)block.get()).getRegistryName().toString());
            PoolJson poolJson = new PoolJson();
            poolJson.setEntries(Collections.singletonList(entryJson));
            poolJson.setRolls(1);
            poolJson.setConditions(Collections.singletonList(new SurvivesExplosionConditionJson()));
            LootTableJson lootTableJson = new LootTableJson();
            lootTableJson.setType(LootTableTypeEnum.BLOCK);
            lootTableJson.setPools(Collections.singletonList(poolJson));
            Path savePath = this.generator.func_200391_b().resolve(LOOT_TABLES_DIR).resolve(((Block)block.get()).getRegistryName().func_110623_a() + ".json");
            IDataProvider.func_218426_a((Gson)GSON, (DirectoryCache)cache, (JsonElement)lootTableJson.serialize(), (Path)savePath);
        }
    }

    @NotNull
    public String func_200397_b() {
        return "Default Block Loot Tables Provider";
    }
}

