/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.event;

import com.ldtteam.blockout.Loader;
import com.ldtteam.structures.client.BlueprintHandler;
import com.ldtteam.structurize.api.util.Log;
import com.ldtteam.structurize.blocks.ModBlocks;
import com.ldtteam.structurize.optifine.OptifineCompat;
import java.util.ArrayList;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.resources.IReloadableResourceManager;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.Tuple;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.resource.ISelectiveResourceReloadListener;
import net.minecraftforge.resource.VanillaResourceType;

public class ClientLifecycleSubscriber {
    public static final ArrayList<Tuple<Supplier<Block>, RenderType>> DELAYED_RENDER_TYPE_SETUP = new ArrayList();

    @SubscribeEvent
    public static void onClientInit(FMLClientSetupEvent event) {
        OptifineCompat.getInstance().intialize();
        IResourceManager rm = ((Minecraft)event.getMinecraftSupplier().get()).func_195551_G();
        if (rm instanceof IReloadableResourceManager) {
            ((IReloadableResourceManager)rm).func_219534_a((IFutureReloadListener)((ISelectiveResourceReloadListener)(resourceManager, resourcePredicate) -> {
                if (resourcePredicate.test(VanillaResourceType.MODELS) || resourcePredicate.test(VanillaResourceType.TEXTURES) || resourcePredicate.test(VanillaResourceType.SHADERS)) {
                    Log.getLogger().debug("Clearing blueprint renderer cache.");
                    BlueprintHandler.getInstance().clearCache();
                }
                Log.getLogger().debug("Clearing gui XML cache.");
                Loader.cleanParsedCache();
            }));
        }
        RenderType t = RenderType.func_228645_f_();
        ModBlocks.getPaperWalls().forEach(frame -> RenderTypeLookup.setRenderLayer((Block)frame, (RenderType)t));
        DELAYED_RENDER_TYPE_SETUP.forEach((Consumer<Tuple<Supplier<Block>, RenderType>>)((Consumer<Tuple>)tu -> {
            if (!((RenderType)tu.func_76340_b()).equals((Object)RenderType.func_228639_c_())) {
                RenderTypeLookup.setRenderLayer((Block)((Block)((Supplier)tu.func_76341_a()).get()), (RenderType)((RenderType)tu.func_76340_b()));
            }
        }));
        DELAYED_RENDER_TYPE_SETUP.clear();
        DELAYED_RENDER_TYPE_SETUP.trimToSize();
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void doClientStuff(FMLClientSetupEvent event) {
        RenderTypeLookup.setRenderLayer((Block)((Block)ModBlocks.blockSubstitution.get()), (RenderType)RenderType.func_228645_f_());
    }
}

