/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.client.gui;

import com.ldtteam.blockout.Pane;
import com.ldtteam.blockout.controls.Button;
import com.ldtteam.blockout.controls.ButtonHandler;
import com.ldtteam.blockout.controls.Text;
import com.ldtteam.blockout.views.ScrollingList;
import com.ldtteam.structurize.Network;
import com.ldtteam.structurize.client.gui.AbstractWindowSkeleton;
import com.ldtteam.structurize.client.gui.DialogDoneCancel;
import com.ldtteam.structurize.client.gui.WindowScan;
import com.ldtteam.structurize.network.messages.OperationHistoryMessage;
import com.ldtteam.structurize.network.messages.UndoRedoMessage;
import com.ldtteam.structurize.util.TickedWorldOperation;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.util.Tuple;
import org.jetbrains.annotations.NotNull;

public class WindowUndoRedo
extends AbstractWindowSkeleton
implements ButtonHandler {
    public static List<Tuple<String, Integer>> lastOperations = new ArrayList<Tuple<String, Integer>>();
    private final ScrollingList operationsList;
    private DialogDoneCancel confirmDeleteDialog = null;

    public WindowUndoRedo() {
        super("structurize:gui/windowundoredo.xml");
        this.registerButton("cancel", this::cancel);
        this.registerButton("undo", (Button b) -> this.undoRedoClicked((Button)((Object)b), true));
        this.registerButton("redo", (Button b) -> this.undoRedoClicked((Button)((Object)b), false));
        this.operationsList = this.findPaneOfTypeByID("operations", ScrollingList.class);
        lastOperations = new ArrayList<Tuple<String, Integer>>();
        if (!Minecraft.func_71410_x().field_71439_g.func_184812_l_()) {
            this.close();
        }
    }

    private void undoRedoClicked(Button button, boolean undo) {
        int index = this.operationsList.getListElementIndexByPane(button);
        Tuple<String, Integer> operation = lastOperations.get(index);
        Network.getNetwork().sendToServer(new UndoRedoMessage((Integer)operation.func_76340_b(), undo));
        this.close();
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        this.updateOperationsList();
    }

    private void updateOperationsList() {
        this.operationsList.enable();
        this.operationsList.show();
        this.operationsList.setDataProvider(new ScrollingList.DataProvider(){

            @Override
            public int getElementCount() {
                return lastOperations.size();
            }

            @Override
            public void updateElement(int index, @NotNull Pane rowPane) {
                Tuple<String, Integer> resource = lastOperations.get(index);
                Text resourceLabel = rowPane.findPaneOfTypeByID("operationname", Text.class);
                resourceLabel.setText((String)resource.func_76341_a());
                resourceLabel.setColors(WindowScan.WHITE);
                if (((String)resource.func_76341_a()).indexOf(TickedWorldOperation.OperationType.UNDO.toString()) == 0) {
                    rowPane.findPaneOfTypeByID("redo", Button.class).hide();
                }
                if (!Minecraft.func_71410_x().field_71439_g.func_184812_l_()) {
                    rowPane.findPaneOfTypeByID("undo", Button.class).hide();
                    rowPane.findPaneOfTypeByID("redo", Button.class).hide();
                }
            }
        });
    }

    private void cancel() {
        this.close();
    }

    @Override
    public void open() {
        super.open();
        this.setVisible(true);
        Network.getNetwork().sendToServer(new OperationHistoryMessage());
    }
}

