/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.blockout.views;

import com.ldtteam.blockout.MouseEventCallback;
import com.ldtteam.blockout.Pane;
import com.ldtteam.blockout.PaneParams;
import com.ldtteam.blockout.views.ScrollingView;
import com.ldtteam.blockout.views.View;
import com.mojang.blaze3d.matrix.MatrixStack;
import org.jetbrains.annotations.NotNull;

public class ScrollingContainer
extends View {
    private static final int PERCENT_90 = 90;
    private static final int PERCENT_FULL = 100;
    protected ScrollingView owner;
    protected double scrollY = 0.0;
    protected int contentHeight = 0;

    ScrollingContainer(ScrollingView owner) {
        this.owner = owner;
    }

    @Override
    public void parseChildren(PaneParams params) {
        super.parseChildren(params);
        this.computeContentHeight();
    }

    public void computeContentHeight() {
        this.contentHeight = 0;
        for (Pane child : this.children) {
            if (child == null) continue;
            this.contentHeight = Math.max(this.contentHeight, child.getY() + child.getHeight());
        }
        this.setScrollY(this.scrollY);
    }

    public void setContentHeight(int size) {
        this.contentHeight = size;
        this.setScrollY(this.scrollY);
    }

    public int getMaxScrollY() {
        return Math.max(0, this.contentHeight - this.getHeight());
    }

    @Override
    public void drawSelf(MatrixStack ms, double mx, double my) {
        this.scissorsStart(ms, this.width, this.contentHeight);
        ms.func_227860_a_();
        ms.func_227861_a_(0.0, -this.scrollY, 0.0);
        super.drawSelf(ms, mx, my + this.scrollY);
        ms.func_227865_b_();
        this.scissorsEnd(ms);
    }

    @Override
    public void drawSelfLast(MatrixStack ms, double mx, double my) {
        ms.func_227860_a_();
        ms.func_227861_a_(0.0, -this.scrollY, 0.0);
        super.drawSelfLast(ms, mx, my + this.scrollY);
        ms.func_227865_b_();
    }

    @Override
    protected boolean childIsVisible(@NotNull Pane child) {
        return child.getX() < this.getWidth() && (double)child.getY() < (double)this.getHeight() + this.scrollY && child.getX() + child.getWidth() >= 0 && (double)(child.getY() + child.getHeight()) >= this.scrollY;
    }

    public double getScrollY() {
        return this.scrollY;
    }

    public void setScrollY(double offset) {
        this.scrollY = offset;
        double maxScrollY = this.getMaxScrollY();
        if (this.scrollY > maxScrollY) {
            this.scrollY = maxScrollY;
        }
        if (this.scrollY < 0.0) {
            this.scrollY = 0.0;
        }
    }

    public int getContentHeight() {
        return this.contentHeight;
    }

    public int getScrollPageSize() {
        return this.getHeight() * 90 / 100;
    }

    public void scrollBy(double deltaY) {
        this.setScrollY(this.scrollY + deltaY);
    }

    @Override
    public boolean mouseEventProcessor(double mx, double my, MouseEventCallback panePredicate, MouseEventCallback eventCallbackPositive, MouseEventCallback eventCallbackNegative) {
        return super.mouseEventProcessor(mx, my + this.scrollY, panePredicate, eventCallbackPositive, eventCallbackNegative);
    }
}

