/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.blockout.hooks;

import com.ldtteam.blockout.hooks.HookScreen;
import com.ldtteam.blockout.hooks.HookWindow;
import com.ldtteam.blockout.hooks.IGuiActionCallback;
import com.ldtteam.blockout.hooks.TriggerMechanism;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.IForgeRegistryEntry;

public abstract class HookManager<T, U extends IForgeRegistryEntry<U>, K> {
    private static HookScreen scrollListener;
    private final List<HookEntry> registry = new ArrayList<HookEntry>();
    private final Set<ResourceLocation> registryKeys = new HashSet<ResourceLocation>();
    private final Map<K, WindowEntry> activeWindows = new HashMap<K, WindowEntry>();

    protected HookManager() {
    }

    protected void registerInternal(U targetThing, ResourceLocation guiLoc, long expirationTime, TriggerMechanism<?> trigger, BiPredicate<? extends T, TriggerMechanism.Type> shouldOpen, IGuiActionCallback<? extends T> onOpen, IGuiActionCallback<? extends T> onClose) {
        Optional<HookEntry> existing;
        Objects.requireNonNull(targetThing, "Target can't be null!");
        Objects.requireNonNull(guiLoc, "Gui location can't be null!");
        Objects.requireNonNull(trigger, "Trigger can't be null!");
        BiPredicate<Object, TriggerMechanism.Type> shouldOpenTest = HookManager.requireNonNullElse(shouldOpen, (t, tt) -> true);
        IGuiActionCallback onOpenListener = HookManager.requireNonNullElse(onOpen, IGuiActionCallback.noAction());
        IGuiActionCallback onClosedListener = HookManager.requireNonNullElse(onClose, IGuiActionCallback.noAction());
        ResourceLocation registryKey = targetThing.getRegistryName();
        if (this.registryKeys.contains(registryKey) && (existing = this.registry.stream().filter(hook -> hook.targetThing.getRegistryName().equals((Object)registryKey) && hook.trigger.getType() == trigger.getType()).findFirst()).isPresent()) {
            throw new IllegalArgumentException(String.format("\"%s\" with trigger \"%s\" is already registerd!", targetThing, existing.get().trigger.getName()));
        }
        this.registry.add(new HookEntry(this, (IForgeRegistryEntry)targetThing, guiLoc, expirationTime, trigger, shouldOpenTest, onOpenListener, onClosedListener));
        this.registryKeys.add(registryKey);
    }

    protected abstract List<T> findTriggered(U var1, TriggerMechanism<?> var2);

    protected abstract K keyMapper(T var1);

    protected abstract void translateToGuiBottomCenter(MatrixStack var1, T var2, float var3);

    protected void tick(long ticks) {
        long now = System.currentTimeMillis();
        this.registry.forEach(hook -> {
            if (hook.trigger.canTick(ticks)) {
                this.findTriggered(hook.targetThing, hook.trigger).forEach(thing -> {
                    K key = this.keyMapper(thing);
                    WindowEntry entry = this.activeWindows.get(key);
                    if ((entry == null || entry.hook.trigger.isLowerPriority(hook.trigger)) && hook.shouldOpen.test(thing, hook.trigger.getType())) {
                        if (entry != null) {
                            entry.screen.func_231164_f_();
                        }
                        WindowEntry window = new WindowEntry(now, thing, (HookEntry)hook, HookWindow::new);
                        this.activeWindows.put(key, window);
                        window.screen.func_231158_b_(Minecraft.func_71410_x(), window.screen.getWindow().getWidth(), window.screen.getWindow().getHeight());
                    } else {
                        entry.lastTimeAccessed = now;
                    }
                });
            }
        });
        this.activeWindows.values().removeIf(entry -> {
            if (entry.hook.trigger.canTick(ticks) && now - ((WindowEntry)entry).lastTimeAccessed > entry.hook.expirationTime) {
                entry.screen.func_231164_f_();
                return true;
            }
            entry.screen.func_231023_e_();
            return false;
        });
    }

    protected void render(MatrixStack ms, float partialTicks) {
        this.activeWindows.values().forEach(entry -> {
            ms.func_227860_a_();
            this.translateToGuiBottomCenter(ms, entry.thing, partialTicks);
            ms.func_227863_a_(Minecraft.func_71410_x().func_175598_ae().func_229098_b_());
            ms.func_227862_a_(-0.01f, -0.01f, 0.01f);
            entry.screen.render(ms);
            ms.func_227865_b_();
        });
    }

    public static boolean onScroll(double scrollDelta) {
        if (scrollListener != null) {
            return scrollListener.mouseScrolled(scrollDelta);
        }
        return false;
    }

    public static HookScreen getScrollListener() {
        return scrollListener;
    }

    public static void setScrollListener(HookScreen scrollListener) {
        HookManager.scrollListener = scrollListener;
    }

    private static <T> T requireNonNullElse(T obj, T defaultObj) {
        return obj != null ? obj : Objects.requireNonNull(defaultObj, "defaultObj");
    }

    protected class WindowEntry {
        private long lastTimeAccessed = 0L;
        protected final T thing;
        protected final HookEntry hook;
        protected final HookScreen screen;

        public WindowEntry(long lastTimeAccessed, T thing, HookEntry hook, Function<WindowEntry, HookWindow<T>> windowFactory) {
            this.lastTimeAccessed = lastTimeAccessed;
            this.thing = thing;
            this.hook = hook;
            this.screen = windowFactory.apply(this).getScreen();
        }
    }

    protected class HookEntry {
        protected final U targetThing;
        protected final ResourceLocation guiLoc;
        protected final long expirationTime;
        protected final TriggerMechanism<?> trigger;
        protected final BiPredicate<T, TriggerMechanism.Type> shouldOpen;
        protected final IGuiActionCallback<T> onOpen;
        protected final IGuiActionCallback<T> onClose;
        final /* synthetic */ HookManager this$0;

        /*
         * WARNING - Possible parameter corruption
         * WARNING - void declaration
         */
        private HookEntry(U expirationTime, ResourceLocation resourceLocation, long trigger, TriggerMechanism<?> onOpen, BiPredicate<T, TriggerMechanism.Type> onClose, IGuiActionCallback<T> iGuiActionCallback, IGuiActionCallback<T> iGuiActionCallback2) {
            void shouldOpen;
            void targetThing;
            this.this$0 = (HookManager)this$0;
            this.targetThing = targetThing;
            this.guiLoc = guiLoc;
            this.expirationTime = expirationTime;
            this.trigger = trigger;
            this.shouldOpen = shouldOpen;
            this.onOpen = onOpen;
            this.onClose = onClose;
        }
    }
}

