/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.smokestack;

import com.railwayteam.railways.config.CRConfigs;
import com.railwayteam.railways.content.smokestack.ISpeedNotifiable;
import com.railwayteam.railways.content.smokestack.SmokeStackBlock;
import com.simibubi.create.content.contraptions.behaviour.MovementBehaviour;
import com.simibubi.create.content.contraptions.behaviour.MovementContext;
import com.simibubi.create.foundation.utility.animation.LerpedFloat;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_2246;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3499;
import net.minecraft.class_5819;

public class SmokeStackMovementBehaviour
implements MovementBehaviour {
    private final boolean renderAsNormalBlockEntity;
    private final boolean createsSmoke;
    private final boolean spawnExtraSmoke;
    private final Map<Integer, LerpedFloat> chanceChasers = new HashMap<Integer, LerpedFloat>();
    private final Map<Integer, LerpedFloat> speedMultiplierChasers = new HashMap<Integer, LerpedFloat>();

    public SmokeStackMovementBehaviour() {
        this(true);
    }

    public SmokeStackMovementBehaviour(boolean spawnExtraSmoke) {
        this(false, true, spawnExtraSmoke);
    }

    public SmokeStackMovementBehaviour(boolean renderAsNormalBlockEntity, boolean createsSmoke, boolean spawnExtraSmoke) {
        this.renderAsNormalBlockEntity = renderAsNormalBlockEntity;
        this.createsSmoke = createsSmoke;
        this.spawnExtraSmoke = spawnExtraSmoke;
    }

    public boolean renderAsNormalBlockEntity() {
        return this.renderAsNormalBlockEntity;
    }

    public void tick(MovementContext context) {
        if (context.world == null || !context.world.field_9236 || context.position == null || !((Boolean)context.state.method_11654((class_2769)SmokeStackBlock.ENABLED)).booleanValue()) {
            return;
        }
        int key = context.hashCode();
        LerpedFloat chanceChaser = this.chanceChasers.get(key);
        LerpedFloat speedMultiplierChaser = this.speedMultiplierChasers.get(key);
        if (chanceChaser == null) {
            chanceChaser = LerpedFloat.linear();
            this.chanceChasers.put(key, chanceChaser);
        }
        if (speedMultiplierChaser == null) {
            speedMultiplierChaser = LerpedFloat.linear();
            this.speedMultiplierChasers.put(key, speedMultiplierChaser);
        }
        float chanceModifierTarget = (Math.abs(context.getAnimationSpeed()) + 100.0f) / 800.0f;
        chanceModifierTarget *= chanceModifierTarget;
        Object v = context.contraption.presentBlockEntities.get(context.localPos);
        if (v instanceof ISpeedNotifiable) {
            ISpeedNotifiable notifiable = (ISpeedNotifiable)v;
            notifiable.notifySpeed(chanceModifierTarget);
        }
        if (!this.createsSmoke) {
            return;
        }
        chanceChaser.chase((double)chanceModifierTarget, chanceModifierTarget > chanceChaser.getChaseTarget() ? 0.1 : 0.01, LerpedFloat.Chaser.LINEAR);
        chanceChaser.tickChaser();
        float chanceModifier = chanceChaser.getValue() * (this.spawnExtraSmoke ? 1.0f : 0.5f);
        int maxModifier = 0;
        int minModifier = 0;
        if (chanceModifier > 2.0f) {
            maxModifier += (int)((double)chanceModifier + 0.5) - 1;
            minModifier = chanceModifier > 3.0f ? (int)((double)chanceModifier + 0.5) - 2 : 1;
        } else if (chanceModifier > 1.0f) {
            ++maxModifier;
        }
        minModifier += 5;
        class_5819 random = context.world.field_9229;
        SmokeStackBlock.SmokeStackType type = ((SmokeStackBlock)context.state.method_26204()).type;
        double speedModifierTarget = 5.0 * (0.5 + (double)(maxModifier += 15));
        speedMultiplierChaser.chase(speedModifierTarget, 0.4, LerpedFloat.Chaser.LINEAR);
        speedMultiplierChaser.tickChaser();
        if ((double)random.method_43057() < type.particleSpawnChance * (double)chanceModifier * (Double)CRConfigs.client().smokePercentage.get()) {
            for (int i = 0; i < random.method_43048(type.maxParticles + maxModifier - (type.minParticles + minModifier)) + type.minParticles + minModifier; ++i) {
                class_2680 underState = class_2246.field_10124.method_9564();
                class_3499.class_3501 info = (class_3499.class_3501)context.contraption.getBlocks().get(context.localPos.method_10074());
                if (info != null) {
                    underState = info.comp_1342();
                }
                SmokeStackBlock.makeParticles(context.world, context.position.method_1023(0.5, 0.0, 0.5).method_1023((random.method_43058() - 0.5) * 0.5, (random.method_43058() - 0.5) * 0.5, (random.method_43058() - 0.5) * 0.5), random.method_43056(), true, type.getParticleSpawnOffset(), type.getParticleSpawnDelta(), speedMultiplierChaser.getValue(), false, underState);
            }
        }
    }
}

