/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.smokestack;

import com.railwayteam.railways.content.smokestack.SmokeParticleData;
import com.railwayteam.railways.util.BlockStateUtils;
import com.railwayteam.railways.util.ShapeWrapper;
import com.simibubi.create.AllTags;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.foundation.block.ProperWaterloggedBlock;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1767;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2769;
import net.minecraft.class_3481;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5819;
import net.minecraft.class_6328;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@class_6328
@ParametersAreNonnullByDefault
public class SmokeStackBlock
extends class_2248
implements ProperWaterloggedBlock,
IWrenchable {
    public static final class_2746 ENABLED = class_2741.field_12515;
    public static final class_2746 POWERED = class_2741.field_12484;
    public static final class_2746 WATERLOGGED = class_2741.field_12508;
    public final SmokeStackType type;
    protected final ShapeWrapper shape;
    public boolean createsStationarySmoke;

    public SmokeStackBlock(class_4970.class_2251 properties, SmokeStackType type, ShapeWrapper shape, boolean createsStationarySmoke) {
        super(properties);
        this.method_9590(this.makeDefaultState());
        this.type = type;
        this.shape = shape;
        this.createsStationarySmoke = createsStationarySmoke;
    }

    public class_265 method_9530(class_2680 pState, class_1922 pLevel, class_2338 pPos, class_3726 pContext) {
        return this.shape.get();
    }

    protected class_2680 makeDefaultState() {
        return (class_2680)((class_2680)((class_2680)this.method_9564().method_11657((class_2769)ENABLED, (Comparable)Boolean.valueOf(true))).method_11657((class_2769)POWERED, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(false));
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(new class_2769[]{ENABLED}).method_11667(new class_2769[]{POWERED}).method_11667(new class_2769[]{WATERLOGGED});
    }

    @NotNull
    public class_3610 method_9545(class_2680 state) {
        return this.fluidState(state);
    }

    @Nullable
    public class_2680 method_9605(class_1750 context) {
        class_2680 blockstate = this.method_9564();
        class_3610 fluidstate = context.method_8045().method_8316(context.method_8037());
        if (context.method_8045().method_49803(context.method_8037())) {
            blockstate = (class_2680)((class_2680)blockstate.method_11657((class_2769)ENABLED, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)POWERED, (Comparable)Boolean.valueOf(true));
        }
        return (class_2680)blockstate.method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.method_15772() == class_3612.field_15910));
    }

    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 level, class_2338 currentPos, class_2338 neighborPos) {
        this.updateWater(level, state, currentPos);
        return state;
    }

    public class_1269 method_9534(class_2680 pState, class_1937 pLevel, class_2338 pPos, class_1657 pPlayer, class_1268 pHand, class_3965 pHit) {
        if (AllTags.AllItemTags.WRENCH.matches(pPlayer.method_5998(pHand))) {
            return super.method_9534(pState, pLevel, pPos, pPlayer, pHand, pHit);
        }
        pState = (class_2680)pState.method_28493((class_2769)ENABLED);
        pLevel.method_8652(pPos, pState, 2);
        if (((Boolean)pState.method_11654((class_2769)WATERLOGGED)).booleanValue()) {
            pLevel.method_39281(pPos, (class_3611)class_3612.field_15910, class_3612.field_15910.method_15789((class_4538)pLevel));
        }
        return class_1269.method_29236((boolean)pLevel.field_9236);
    }

    public void method_9612(class_2680 state, class_1937 level, class_2338 pos, class_2248 block, class_2338 fromPos, boolean isMoving) {
        super.method_9612(state, level, pos, block, fromPos, isMoving);
        if (!level.field_9236) {
            boolean shouldBeEnabled;
            boolean powered = level.method_49803(pos);
            boolean bl = shouldBeEnabled = !powered;
            if (powered != (Boolean)state.method_11654((class_2769)POWERED)) {
                if ((Boolean)state.method_11654((class_2769)ENABLED) != shouldBeEnabled) {
                    state = (class_2680)state.method_11657((class_2769)ENABLED, (Comparable)Boolean.valueOf(shouldBeEnabled));
                }
                level.method_8652(pos, (class_2680)state.method_11657((class_2769)POWERED, (Comparable)Boolean.valueOf(powered)), 2);
                if (((Boolean)state.method_11654((class_2769)WATERLOGGED)).booleanValue()) {
                    level.method_39281(pos, (class_3611)class_3612.field_15910, class_3612.field_15910.method_15789((class_4538)level));
                }
            }
        }
    }

    public static void makeParticlesStationary(class_1937 level, class_2338 pos, boolean isSignalFire, boolean spawnExtraSmoke, class_243 spawnOffset, class_243 spawnDelta) {
        SmokeStackBlock.makeParticles(level, new class_243((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260()), isSignalFire, spawnExtraSmoke, spawnOffset, spawnDelta, 1.0, true);
    }

    public static void makeParticles(class_1937 level, class_243 pos, boolean isSignalFire, boolean spawnExtraSmoke, class_243 spawnOffset, class_243 spawnDelta) {
        SmokeStackBlock.makeParticles(level, pos, isSignalFire, spawnExtraSmoke, spawnOffset, spawnDelta, 1.0);
    }

    public static void makeParticles(class_1937 level, class_243 pos, boolean isSignalFire, boolean spawnExtraSmoke, class_243 spawnOffset, class_243 spawnDelta, double speedMultiplier) {
        SmokeStackBlock.makeParticles(level, pos, isSignalFire, spawnExtraSmoke, spawnOffset, spawnDelta, speedMultiplier, false);
    }

    public static void makeParticles(class_1937 level, class_243 pos, boolean isSignalFire, boolean spawnExtraSmoke, class_243 spawnOffset, class_243 spawnDelta, double speedMultiplier, boolean stationary) {
        class_2338 underPos = class_2338.method_49637((double)pos.field_1352, (double)(pos.field_1351 - 1.0), (double)pos.field_1350);
        class_2680 underState = level.method_8320(underPos);
        SmokeStackBlock.makeParticles(level, pos, isSignalFire, spawnExtraSmoke, spawnOffset, spawnDelta, speedMultiplier, stationary, underState);
    }

    public static void makeParticles(class_1937 level, class_243 pos, boolean isSignalFire, boolean spawnExtraSmoke, class_243 spawnOffset, class_243 spawnDelta, double speedMultiplier, boolean stationary, class_2680 underState) {
        SmokeParticleData particleType;
        class_5819 random = level.method_8409();
        if (underState.method_26164(class_3481.field_15481)) {
            class_1767 color = BlockStateUtils.getWoolColor(underState.method_26204());
            float[] c = color.method_7787();
            particleType = new SmokeParticleData(stationary, c[0], c[1], c[2]);
        } else {
            particleType = new SmokeParticleData(stationary);
        }
        level.method_17452((class_2394)particleType, true, pos.method_10216() + spawnOffset.field_1352 + random.method_43058() * spawnDelta.field_1352 * (random.method_43058() * 2.0 - 1.0), pos.method_10214() + random.method_43058() * spawnDelta.field_1351 + spawnOffset.field_1351 + 0.5, pos.method_10215() + spawnOffset.field_1350 + random.method_43058() * spawnDelta.field_1350 * (random.method_43058() * 2.0 - 1.0), 0.0, 0.07 * speedMultiplier * (double)(stationary ? 25 : 1), 0.0);
        if (spawnExtraSmoke) {
            level.method_8406((class_2394)class_2398.field_11251, pos.method_10216() + spawnOffset.field_1352 + random.method_43058() * spawnDelta.field_1352 * 0.75 * (double)(random.method_43056() ? 1 : -1), pos.method_10214() + spawnOffset.field_1351 - 0.1, pos.method_10215() + spawnOffset.field_1350 + random.method_43058() * spawnDelta.field_1350 * 0.75 * (double)(random.method_43056() ? 1 : -1), 0.0, 0.005 * speedMultiplier, 0.0);
        }
    }

    public void method_9496(class_2680 state, class_1937 level, class_2338 pos, class_5819 random) {
        if (((Boolean)state.method_11654((class_2769)ENABLED)).booleanValue() && (double)random.method_43057() < this.type.particleSpawnChance * 1.5 && this.createsStationarySmoke) {
            for (int i = 0; i < random.method_43048(this.type.maxParticles - this.type.minParticles) + this.type.minParticles; ++i) {
                SmokeStackBlock.makeParticlesStationary(level, pos, random.method_43056(), true, this.type.getParticleSpawnOffset(), this.type.getParticleSpawnDelta());
            }
        }
    }

    public static class SmokeStackType {
        public class_243 particleSpawnOffset;
        public class_243 particleSpawnDelta;
        public double particleSpawnChance;
        public int minParticles;
        public int maxParticles;

        public SmokeStackType(double xOffset, double yOffset, double zOffset) {
            this(new class_243(xOffset, yOffset, zOffset));
        }

        public SmokeStackType(class_243 particleSpawnOffset) {
            this(particleSpawnOffset, new class_243(0.3, 2.0, 0.3));
        }

        public SmokeStackType(class_243 particleSpawnOffset, class_243 particleSpawnDelta) {
            this(particleSpawnOffset, particleSpawnDelta, 2, 4);
        }

        public SmokeStackType(class_243 particleSpawnOffset, class_243 particleSpawnDelta, int minParticles, int maxParticles) {
            this(particleSpawnOffset, particleSpawnDelta, minParticles, maxParticles, 1.0);
        }

        public SmokeStackType(class_243 particleSpawnOffset, class_243 particleSpawnDelta, int minParticles, int maxParticles, double particleSpawnChance) {
            this.particleSpawnOffset = particleSpawnOffset;
            this.particleSpawnDelta = particleSpawnDelta;
            this.minParticles = minParticles;
            this.maxParticles = maxParticles;
            this.particleSpawnChance = particleSpawnChance;
        }

        public class_243 getParticleSpawnOffset() {
            return this.particleSpawnOffset;
        }

        public class_243 getParticleSpawnDelta() {
            return this.particleSpawnDelta;
        }
    }
}

