/*
 * Decompiled with CFR 0.152.
 */
package net.spell_power.api.enchantment;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_1304;
import net.minecraft.class_1886;
import net.minecraft.class_1887;
import net.minecraft.class_2960;
import net.spell_power.SpellPowerMod;
import net.spell_power.api.SpellSchool;
import net.spell_power.api.SpellSchools;
import net.spell_power.api.enchantment.EnchantmentRestriction;
import net.spell_power.api.enchantment.ItemType;
import net.spell_power.api.enchantment.SpellPowerEnchanting;
import net.spell_power.config.EnchantmentsConfig;
import net.spell_power.internals.AmplifierEnchantment;
import net.spell_power.internals.SchoolFilteredEnchantment;

public class Enchantments_SpellPower {
    public static final String spellPowerName = "spell_power";
    public static final class_2960 spellPowerId = new class_2960("spell_power", "spell_power");
    public static final SchoolFilteredEnchantment SPELL_POWER = new SchoolFilteredEnchantment(class_1887.class_1888.field_9090, AmplifierEnchantment.Operation.ADD, Enchantments_SpellPower.config().spell_power, Set.of(SpellSchools.ARCANE, SpellSchools.FIRE, SpellSchools.FROST, SpellSchools.HEALING, SpellSchools.LIGHTNING, SpellSchools.SOUL), class_1886.field_9082, class_1304.values());
    public static final String soulfrostName = "soulfrost";
    public static final class_2960 soulfrostId = new class_2960("spell_power", "soulfrost");
    public static final SchoolFilteredEnchantment SOULFROST = new SchoolFilteredEnchantment(class_1887.class_1888.field_9088, AmplifierEnchantment.Operation.ADD, Enchantments_SpellPower.config().soulfrost, Set.of(SpellSchools.SOUL, SpellSchools.FROST), class_1886.field_9082, class_1304.values());
    public static final String sunfireName = "sunfire";
    public static final class_2960 sunfireId = new class_2960("spell_power", "sunfire");
    public static final SchoolFilteredEnchantment SUNFIRE = new SchoolFilteredEnchantment(class_1887.class_1888.field_9088, AmplifierEnchantment.Operation.ADD, Enchantments_SpellPower.config().sunfire, Set.of(SpellSchools.ARCANE, SpellSchools.FIRE), class_1886.field_9082, class_1304.values());
    public static final String energizeName = "energize";
    public static final class_2960 energizeId = new class_2960("spell_power", "energize");
    public static final SchoolFilteredEnchantment ENERGIZE = new SchoolFilteredEnchantment(class_1887.class_1888.field_9088, AmplifierEnchantment.Operation.ADD, Enchantments_SpellPower.config().energize, Set.of(SpellSchools.HEALING, SpellSchools.LIGHTNING), class_1886.field_9082, class_1304.values());
    public static final Map<class_2960, SchoolFilteredEnchantment> all = new HashMap<class_2960, SchoolFilteredEnchantment>();

    private static EnchantmentsConfig config() {
        return (EnchantmentsConfig)((Object)SpellPowerMod.enchantmentConfig.value);
    }

    public static void attach() {
        for (SpellSchool school : SpellSchools.all()) {
            List<SchoolFilteredEnchantment> poweringEnchantments = all.entrySet().stream().filter(entry -> ((SchoolFilteredEnchantment)((Object)((Object)entry.getValue()))).poweredSchools().contains(school)).map(Map.Entry::getValue).toList();
            school.addSource(SpellSchool.Trait.POWER, new SpellSchool.Source(SpellSchool.Apply.MULTIPLY, query -> {
                double value = 0.0;
                for (SchoolFilteredEnchantment enchantment : poweringEnchantments) {
                    int level = SpellPowerEnchanting.getEnchantmentLevel(enchantment, query.entity(), null);
                    value = enchantment.amplified(value, level);
                }
                return value;
            }));
        }
    }

    static {
        all.put(spellPowerId, SPELL_POWER);
        all.put(soulfrostId, SOULFROST);
        all.put(sunfireId, SUNFIRE);
        all.put(energizeId, ENERGIZE);
        for (Map.Entry<class_2960, SchoolFilteredEnchantment> entry : all.entrySet()) {
            SchoolFilteredEnchantment enchantment = entry.getValue();
            EnchantmentRestriction.prohibit(enchantment, itemStack -> {
                ItemType itemTypeRequirement = enchantment.config.requires;
                boolean typeMatches = true;
                boolean schoolMatches = true;
                if (itemTypeRequirement != null) {
                    typeMatches = itemTypeRequirement.matches(itemStack);
                    if (itemTypeRequirement.requiresMagic()) {
                        schoolMatches = SchoolFilteredEnchantment.schoolsIntersect(enchantment.poweredSchools(), itemStack);
                    }
                }
                return !typeMatches || !schoolMatches;
            });
        }
    }
}

