/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.rpg_series.config;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import net.spell_engine.api.loot.LootConfig;

public class Defaults {
    public static final LootConfig lootConfig = new LootConfig();

    private static String armors(int tier) {
        return "#rpg_series:tier_" + tier + "_armors";
    }

    private static String weapons(int tier) {
        return "#rpg_series:tier_" + tier + "_weapons";
    }

    private static String equipment(int tier) {
        return "#rpg_series:tier_" + tier + "_equipment";
    }

    @SafeVarargs
    private static <T> List<T> joinLists(List<T> ... lists) {
        return Arrays.stream(lists).flatMap(Collection::stream).collect(Collectors.toList());
    }

    static {
        Defaults.lootConfig.item_groups.put("golden_weapons", new LootConfig.ItemGroup(List.of("#rpg_series:golden_weapons"), 1).chance(0.3f));
        Defaults.lootConfig.item_groups.put("weapons_tier_0", new LootConfig.ItemGroup(List.of(Defaults.weapons(0)), 0.25f, 0.0f, 1).chance(0.3f));
        Defaults.lootConfig.item_groups.put("weapons_tier_1", new LootConfig.ItemGroup(List.of(Defaults.weapons(1)), 1).chance(0.3f));
        Defaults.lootConfig.item_groups.put("weapons_tier_2", new LootConfig.ItemGroup(List.of(Defaults.weapons(2)), 1).chance(0.3f));
        Defaults.lootConfig.item_groups.put("weapons_tier_3", new LootConfig.ItemGroup(List.of(Defaults.weapons(3)), 1).chance(0.3f));
        Defaults.lootConfig.item_groups.put("weapons_tier_4", new LootConfig.ItemGroup(List.of(Defaults.weapons(4)), 1).chance(0.5f));
        Defaults.lootConfig.item_groups.put("weapons_tier_1_enchanted", new LootConfig.ItemGroup(List.of(Defaults.weapons(1)), 1).chance(0.3f).enchant());
        Defaults.lootConfig.item_groups.put("weapons_tier_2_enchanted", new LootConfig.ItemGroup(List.of(Defaults.weapons(2)), 1).chance(0.3f).enchant());
        Defaults.lootConfig.item_groups.put("armors_tier_1", new LootConfig.ItemGroup(List.of(Defaults.armors(1)), 1).chance(0.25f));
        Defaults.lootConfig.item_groups.put("armors_tier_1_enchanted", new LootConfig.ItemGroup(List.of(Defaults.armors(1)), 1).chance(0.25f).enchant());
        Defaults.lootConfig.item_groups.put("armors_tier_2", new LootConfig.ItemGroup(List.of(Defaults.armors(2)), 1).chance(0.5f));
        Defaults.lootConfig.item_groups.put("armors_tier_2_enchanted", new LootConfig.ItemGroup(List.of(Defaults.armors(2)), 1).chance(0.5f).enchant());
        List.of("minecraft:chests/ruined_portal").forEach(id -> Defaults.lootConfig.loot_tables.put((String)id, List.of("golden_weapons")));
        List.of("minecraft:chests/abandoned_mineshaft", "minecraft:chests/igloo_chest", "minecraft:chests/shipwreck_supply", "minecraft:chests/spawn_bonus_chest").forEach(id -> Defaults.lootConfig.loot_tables.put((String)id, List.of("weapons_tier_0")));
        List.of("minecraft:chests/bastion_bridge", "minecraft:chests/simple_dungeon", "minecraft:chests/stronghold_crossing").forEach(id -> Defaults.lootConfig.loot_tables.put((String)id, List.of("weapons_tier_1")));
        List.of("minecraft:chests/shipwreck_treasure").forEach(id -> Defaults.lootConfig.loot_tables.put((String)id, List.of("armors_tier_1")));
        List.of("minecraft:chests/stronghold_crossing", "minecraft:chests/desert_pyramid", "minecraft:chests/underwater_ruin_small", "minecraft:chests/jungle_temple", "minecraft:chests/pillager_outpost", "minecraft:chests/woodland_mansion").forEach(id -> Defaults.lootConfig.loot_tables.put((String)id, List.of("weapons_tier_1_enchanted", "armors_tier_1_enchanted")));
        List.of("minecraft:chests/nether_bridge", "minecraft:chests/underwater_ruin_big").forEach(id -> Defaults.lootConfig.loot_tables.put((String)id, List.of("weapons_tier_2")));
        List.of("minecraft:chests/bastion_treasure", "minecraft:chests/ancient_city", "minecraft:chests/stronghold_library").forEach(id -> Defaults.lootConfig.loot_tables.put((String)id, List.of("armors_tier_2")));
        List.of("minecraft:chests/bastion_treasure").forEach(id -> Defaults.lootConfig.loot_tables.put((String)id, List.of("weapons_tier_3")));
        List.of("minecraft:chests/end_city_treasure").forEach(id -> Defaults.lootConfig.loot_tables.put((String)id, List.of("weapons_tier_4", "armors_tier_2")));
    }
}

