/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.mixin.arrow;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1665;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3966;
import net.spell_engine.api.spell.ParticleBatch;
import net.spell_engine.api.spell.Spell;
import net.spell_engine.api.spell.SpellInfo;
import net.spell_engine.entity.ConfigurableKnockback;
import net.spell_engine.internals.SpellHelper;
import net.spell_engine.internals.SpellRegistry;
import net.spell_engine.internals.arrow.ArrowExtension;
import net.spell_engine.particle.ParticleHelper;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_1665.class})
public abstract class PersistentProjectileEntityMixin
implements ArrowExtension {
    @Shadow
    protected boolean field_7588;
    private boolean arrowPerksAlreadyApplied = false;
    private class_2960 spellId = null;
    private static final String NBT_KEY_SPELL_ID = "spell_id";
    private static final class_2940<Integer> SPELL_ID_TRACKER = class_2945.method_12791(class_1665.class, (class_2941)class_2943.field_13327);
    private int client_lastResolvedSpellRawId = 0;
    @Nullable
    private Spell client_lastResolvedSpell = null;
    private boolean allowByPassingIFrames = true;

    @Shadow
    public abstract byte method_7447();

    @Shadow
    public abstract void method_7451(byte var1);

    @Shadow
    public abstract void method_7438(double var1);

    @Shadow
    public abstract double method_7448();

    private class_1665 arrow() {
        return (class_1665)this;
    }

    @Nullable
    Spell spell() {
        if (this.spellId != null) {
            return SpellRegistry.getSpell(this.spellId);
        }
        return null;
    }

    @Inject(method={"writeCustomDataToNbt"}, at={@At(value="TAIL")})
    public void writeCustomDataToNbt_TAIL_SpellEngine(class_2487 nbt, CallbackInfo ci) {
        if (this.spellId != null) {
            nbt.method_10582(NBT_KEY_SPELL_ID, this.spellId.toString());
        }
    }

    @Inject(method={"readCustomDataFromNbt"}, at={@At(value="TAIL")})
    public void readCustomDataFromNbt_TAIL_SpellEngine(class_2487 nbt, CallbackInfo ci) {
        String string;
        if (nbt.method_10545(NBT_KEY_SPELL_ID) && (string = nbt.method_10558(NBT_KEY_SPELL_ID)) != null && !string.isEmpty()) {
            this.spellId = new class_2960(nbt.method_10558(NBT_KEY_SPELL_ID));
        }
    }

    @Inject(method={"initDataTracker"}, at={@At(value="TAIL")})
    private void initDataTracker_TAIL_SpellEngine(CallbackInfo ci) {
        this.arrow().method_5841().method_12784(SPELL_ID_TRACKER, (Object)0);
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void tick_HEAD_SpellEngine(CallbackInfo ci) {
        Integer rawId;
        class_1665 arrow = this.arrow();
        if (arrow.method_37908().field_9236 && (rawId = (Integer)this.arrow().method_5841().method_12789(SPELL_ID_TRACKER)) != this.client_lastResolvedSpellRawId) {
            this.client_lastResolvedSpellRawId = rawId;
            this.spellId = SpellRegistry.fromRawSpellId(rawId).orElse(null);
            this.client_lastResolvedSpell = this.spell();
        }
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    private void tick_TAIL_SpellEngine(CallbackInfo ci) {
        Spell.ArrowPerks perks;
        if (this.client_lastResolvedSpell != null && (perks = this.client_lastResolvedSpell.arrow_perks) != null && perks.travel_particles != null) {
            class_1665 arrow = this.arrow();
            for (ParticleBatch travel_particles : perks.travel_particles) {
                ParticleHelper.play(arrow.method_37908(), (class_1297)arrow, arrow.method_36454(), arrow.method_36455(), travel_particles);
            }
        }
    }

    @Override
    public void allowByPassingIFrames_SpellEngine(boolean allow) {
        this.allowByPassingIFrames = allow;
    }

    @Override
    public boolean isInGround_SpellEngine() {
        return this.field_7588;
    }

    @Override
    @Nullable
    public class_2960 getCarriedSpellId() {
        return this.spellId;
    }

    @Override
    @Nullable
    public Spell getCarriedSpell() {
        if (this.arrow().method_37908().method_8608()) {
            return this.client_lastResolvedSpell;
        }
        return this.spell();
    }

    @Override
    public void applyArrowPerks(SpellInfo spellInfo) {
        if (this.arrowPerksAlreadyApplied) {
            return;
        }
        class_1665 arrow = this.arrow();
        Spell.ArrowPerks perks = spellInfo.spell().arrow_perks;
        if (perks != null) {
            if (perks.velocity_multiplier != 1.0f) {
                arrow.method_18799(arrow.method_18798().method_1021((double)perks.velocity_multiplier));
            }
            this.arrowPerksAlreadyApplied = true;
            if (perks.pierce > 0) {
                byte newPierce = (byte)(this.method_7447() + perks.pierce);
                this.method_7451(newPierce);
            }
            this.method_7438(this.method_7448() * (double)perks.damage_multiplier);
        }
        this.spellId = spellInfo.id();
        arrow.method_5841().method_12778(SPELL_ID_TRACKER, (Object)SpellRegistry.rawSpellId(spellInfo.id()));
    }

    @Inject(method={"onEntityHit"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/Entity;damage(Lnet/minecraft/entity/damage/DamageSource;F)Z")}, cancellable=true)
    private void onEntityHit_BeforeDamage_SpellEngine(class_3966 entityHitResult, CallbackInfo ci) {
        Spell.ArrowPerks arrowPerks;
        Spell spell = this.spell();
        if (spell != null && (arrowPerks = spell.arrow_perks) != null && arrowPerks.skip_arrow_damage) {
            ci.cancel();
            this.arrow().method_31472();
            class_1297 entity = entityHitResult.method_17782();
            if (entity != null) {
                this.performImpacts(entity, entityHitResult);
            }
        }
    }

    @WrapOperation(method={"onEntityHit"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/Entity;damage(Lnet/minecraft/entity/damage/DamageSource;F)Z")})
    private boolean wrapDamageEntity(class_1297 entity, class_1282 damageSource, float amount, Operation<Boolean> original, class_3966 entityHitResult) {
        Spell spell = this.spell();
        if (entity.method_37908().method_8608() || spell == null) {
            return (Boolean)original.call(new Object[]{entity, damageSource, Float.valueOf(amount)});
        }
        Spell.ArrowPerks arrowPerks = spell.arrow_perks;
        boolean pushedKnockback = false;
        int iFrameToRestore = 0;
        if (entity instanceof class_1309) {
            class_1309 livingEntity = (class_1309)entity;
            if (arrowPerks != null) {
                if (arrowPerks.knockback != 1.0f) {
                    ((ConfigurableKnockback)livingEntity).pushKnockbackMultiplier_SpellEngine(arrowPerks.knockback);
                    pushedKnockback = true;
                }
                if (this.allowByPassingIFrames && arrowPerks.bypass_iframes) {
                    iFrameToRestore = entity.field_6008;
                    entity.field_6008 = 0;
                }
                if (arrowPerks.iframe_to_set > 0) {
                    iFrameToRestore = arrowPerks.iframe_to_set;
                }
            }
        }
        Boolean result = (Boolean)original.call(new Object[]{entity, damageSource, Float.valueOf(amount)});
        this.performImpacts(entity, entityHitResult);
        if (pushedKnockback) {
            ((ConfigurableKnockback)entity).popKnockbackMultiplier_SpellEngine();
        }
        if (iFrameToRestore != 0) {
            entity.field_6008 = iFrameToRestore;
        }
        return result;
    }

    private void performImpacts(class_1297 target, class_3966 entityHitResult) {
        Spell spell = this.spell();
        class_1665 arrow = this.arrow();
        class_1297 owner = arrow.method_24921();
        if (spell != null && spell.impact != null && owner instanceof class_1309) {
            class_1309 shooter = (class_1309)owner;
            SpellHelper.projectileImpact(shooter, (class_1297)arrow, target, new SpellInfo(spell, this.spellId), new SpellHelper.ImpactContext().position(entityHitResult.method_17784()));
        }
    }
}

