/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.api.spell;

import com.google.gson.annotations.JsonAdapter;
import net.spell_engine.api.render.LightEmission;
import net.spell_engine.api.spell.ParticleBatch;
import net.spell_engine.api.spell.Sound;
import net.spell_engine.utils.TargetHelper;
import net.spell_power.api.SpellPower;
import net.spell_power.api.SpellSchool;
import net.spell_power.api.SpellSchools;
import org.jetbrains.annotations.Nullable;

public class Spell {
    @JsonAdapter(value=SpellSchools.IdTypeAdapter.class)
    public SpellSchool school;
    public float range = 50.0f;
    @Nullable
    public String group;
    public Learn learn = new Learn();
    public Mode mode = Mode.CAST;
    public Cast cast = new Cast();
    public ItemUse item_use = new ItemUse();
    @Nullable
    public ArrowPerks arrow_perks = null;
    public Release release;
    public Impact[] impact;
    @Nullable
    public AreaImpact area_impact;
    public Cost cost = new Cost();

    public static class Learn {
        public int tier = 1;
        public int level_cost_per_tier = 3;
        public int level_requirement_per_tier = 10;
    }

    public static enum Mode {
        CAST,
        ITEM_USE;

    }

    public static class Cast {
        public boolean haste_affected = true;
        public float duration = 0.0f;
        public int channel_ticks = 0;
        public String animation;
        public boolean animates_ranged_weapon = false;
        public Sound start_sound;
        public Sound sound;
        public ParticleBatch[] particles = new ParticleBatch[0];
    }

    public static class ItemUse {
        public boolean shows_item_as_icon = false;
        public boolean requires_offhand_item = false;
    }

    public static class ArrowPerks {
        public float damage_multiplier = 1.0f;
        public float velocity_multiplier = 1.0f;
        public boolean bypass_iframes = false;
        public int iframe_to_set = 0;
        public boolean skip_arrow_damage = false;
        public int pierce = 0;
        public float knockback = 1.0f;
        @Nullable
        public ParticleBatch[] travel_particles;
        @Nullable
        public ProjectileModel override_render;
    }

    public static class Cost {
        public float exhaust = 0.1f;
        public String item_id;
        public boolean consume_item = true;
        public String effect_id;
        public int durability = 1;
        public float cooldown_duration = 0.0f;
        public boolean cooldown_proportional = false;
        public boolean cooldown_haste_affected = true;
    }

    public static class EntityPlacement {
        public boolean force_onto_ground = true;
        public float location_offset_by_look = 0.0f;
        public float location_yaw_offset = 0.0f;
        public boolean apply_yaw = false;
        public boolean apply_pitch = false;
        public float location_offset_x = 0.0f;
        public float location_offset_y = 0.0f;
        public float location_offset_z = 0.0f;
    }

    public static class ProjectileModel {
        public String model_id;
        public LightEmission light_emission = LightEmission.GLOW;
        public float scale = 1.0f;
        public float rotate_degrees_per_tick = 2.0f;
        public RenderMode render = RenderMode.DEEP;

        public static enum RenderMode {
            FLAT,
            DEEP;

        }
    }

    public static class ProjectileData {
        public float divergence = 0.0f;
        public float homing_angle = 1.0f;
        public Perks perks = new Perks();
        public Client client_data;

        public static class Perks {
            public int ricochet = 0;
            public float ricochet_range = 5.0f;
            public int bounce = 0;
            public boolean bounce_ricochet_sync = true;
            public int pierce = 0;
            public int chain_reaction_size = 0;
            public int chain_reaction_triggers = 1;
            public int chain_reaction_increment = -1;

            Perks() {
            }

            public Perks copy() {
                Perks copy = new Perks();
                copy.ricochet = this.ricochet;
                copy.ricochet_range = this.ricochet_range;
                copy.bounce = this.bounce;
                copy.bounce_ricochet_sync = this.bounce_ricochet_sync;
                copy.pierce = this.pierce;
                copy.chain_reaction_size = this.chain_reaction_size;
                copy.chain_reaction_triggers = this.chain_reaction_triggers;
                copy.chain_reaction_increment = this.chain_reaction_increment;
                return copy;
            }
        }

        public static class Client {
            public int light_level = 0;
            public ParticleBatch[] travel_particles;
            public ProjectileModel model;
        }
    }

    public static class LaunchProperties {
        public float velocity = 1.0f;
        public int extra_launch_count = 0;
        public int extra_launch_delay = 2;

        public LaunchProperties velocity(float value) {
            this.velocity = value;
            return this;
        }

        public LaunchProperties copy() {
            LaunchProperties copy = new LaunchProperties();
            copy.velocity = this.velocity;
            copy.extra_launch_count = this.extra_launch_count;
            copy.extra_launch_delay = this.extra_launch_delay;
            return copy;
        }
    }

    public static class AreaImpact {
        public float radius = 1.0f;
        public ExtraRadius extra_radius = new ExtraRadius();
        public Release.Target.Area area = new Release.Target.Area();
        public ParticleBatch[] particles = new ParticleBatch[0];
        @Nullable
        public Sound sound;

        public float combinedRadius(SpellPower.Result power) {
            return this.radius + this.extra_radius.power_coefficient * (float)Math.min((double)this.extra_radius.power_cap, power.baseValue());
        }

        public static class ExtraRadius {
            public float power_coefficient = 0.0f;
            public float power_cap = 0.0f;
        }
    }

    public static class Impact {
        public Action action;
        @JsonAdapter(value=SpellSchools.IdTypeAdapter.class)
        @Nullable
        public SpellSchool school;
        public ParticleBatch[] particles = new ParticleBatch[0];
        public Sound sound;

        public static class Action {
            public Type type;
            public boolean apply_to_caster = false;
            public float min_power = 1.0f;
            public Damage damage;
            public Heal heal;
            public StatusEffect status_effect;
            public Fire fire;
            public Spawn spawn;
            public Spawn[] spawns = new Spawn[0];
            public Teleport teleport;

            public static class Spawn {
                public String entity_type_id;
                public int time_to_live_seconds = 0;
                public int delay_ticks = 0;
                public EntityPlacement placement = new EntityPlacement();
            }

            public static class Teleport {
                public Mode mode;
                public int required_clearance_block_y = 1;
                public TargetHelper.Intent intent = TargetHelper.Intent.HELPFUL;
                public Forward forward;
                @Nullable
                public ParticleBatch[] depart_particles;

                public static class Forward {
                    public float distance = 10.0f;
                }

                public static enum Mode {
                    FORWARD;

                }
            }

            public static class Fire {
                public int duration = 2;
                public int tick_offset = 10;
            }

            public static class StatusEffect {
                public String effect_id;
                public float duration = 10.0f;
                public int amplifier = 0;
                public float amplifier_power_multiplier = 0.0f;
                public ApplyMode apply_mode = ApplyMode.SET;
                public ApplyLimit apply_limit;
                public boolean show_particles = true;

                public static enum ApplyMode {
                    SET,
                    ADD;

                }

                public static class ApplyLimit {
                    public float health_base = 0.0f;
                    public float spell_power_multiplier = 0.0f;
                }
            }

            public static class Heal {
                public float spell_power_coefficient = 1.0f;
            }

            public static class Damage {
                public boolean bypass_iframes = true;
                public float spell_power_coefficient = 1.0f;
                public float knockback = 1.0f;
            }

            public static enum Type {
                DAMAGE,
                HEAL,
                STATUS_EFFECT,
                FIRE,
                SPAWN,
                TELEPORT;

            }
        }
    }

    public static class Release {
        public Target target;
        public boolean custom_impact = false;
        public String animation;
        public ParticleBatch[] particles;
        public Sound sound;

        public static class Target {
            public Type type;
            public Area area;
            public Beam beam;
            public Cloud cloud;
            public Cloud[] clouds = new Cloud[0];
            public Cursor cursor;
            public ShootProjectile projectile;
            public Meteor meteor;
            public ShootArrow shoot_arrow;

            public static class Cloud {
                @Nullable
                public String entity_type_id;
                public AreaImpact volume = new AreaImpact();
                public float time_to_live_seconds = 0.0f;
                public int impact_tick_interval = 5;
                public int delay_ticks = 0;
                public EntityPlacement placement = new EntityPlacement();
                @Nullable
                public Sound presence_sound;
                public ClientData client_data = new ClientData();
                public Spawn spawn = new Spawn();

                public static class ClientData {
                    public int light_level = 0;
                    public ParticleBatch[] particles = new ParticleBatch[0];
                    public ProjectileModel model;
                }

                public static class Spawn {
                    public Sound sound;
                    public ParticleBatch[] particles = new ParticleBatch[0];
                }
            }

            public static class ShootArrow {
                public boolean consume_arrow = true;
                public float damage_multiplier = 1.0f;
                public boolean arrow_critical_strike = true;
                public LaunchProperties launch_properties = new LaunchProperties().velocity(3.15f);
            }

            public static class Meteor {
                public float launch_height = 10.0f;
                public int offset_requires_sequence = 1;
                public int divergence_requires_sequence = 1;
                public int follow_target_requires_sequence = -1;
                public float launch_radius = 0.0f;
                public LaunchProperties launch_properties = new LaunchProperties();
                public ProjectileData projectile;
            }

            public static class ShootProjectile {
                public boolean inherit_shooter_velocity = false;
                public LaunchProperties launch_properties = new LaunchProperties();
                public ProjectileData projectile;
            }

            public static class Cursor {
                public boolean use_caster_as_fallback = false;
            }

            public static class Beam {
                public String texture_id = "textures/entity/beacon_beam.png";
                public long color_rgba = -1L;
                public float width = 0.1f;
                public float flow = 1.0f;
                public ParticleBatch[] block_hit_particles = new ParticleBatch[0];
            }

            public static class Area {
                public DropoffCurve distance_dropoff = DropoffCurve.NONE;
                public float horizontal_range_multiplier = 1.0f;
                public float vertical_range_multiplier = 1.0f;
                public float angle_degrees = 0.0f;
                public boolean include_caster = false;

                public static enum DropoffCurve {
                    NONE,
                    SQUARED;

                }
            }

            public static enum Type {
                AREA,
                BEAM,
                CURSOR,
                SELF,
                PROJECTILE,
                METEOR,
                CLOUD,
                SHOOT_ARROW;

            }
        }
    }
}

