/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.spellbinding;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_465;
import net.minecraft.class_5250;
import net.minecraft.class_746;
import net.spell_engine.api.item.trinket.SpellBookItem;
import net.spell_engine.api.item.trinket.SpellBooks;
import net.spell_engine.client.gui.CustomButton;
import net.spell_engine.client.gui.SpellTooltip;
import net.spell_engine.client.util.SpellRender;
import net.spell_engine.internals.SpellRegistry;
import net.spell_engine.spellbinding.SpellBinding;
import net.spell_engine.spellbinding.SpellBindingScreenHandler;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class SpellBindingScreen
extends class_465<SpellBindingScreenHandler> {
    private static final class_2960 TEXTURE = new class_2960("spell_engine", "textures/gui/spell_binding.png");
    private class_1799 stack;
    private int pageOffset = 0;
    private class_4185 upButton;
    private class_4185 downButton;
    private static final int PAGE_SIZE = 3;
    private List<ButtonViewModel> buttonViewModels = List.of();
    private static final int BUTTONS_ORIGIN_X = 60;
    private static final int BUTTONS_ORIGIN_Y = 14;
    private static final int BUTTON_TEXTURE_U = 0;
    private static final int BUTTON_TEXTURE_V = 166;
    private static final int BUTTON_WIDTH = 108;
    private static final int BUTTON_HEIGHT = 19;
    private static final int SPELL_ICON_SIZE = 16;
    private static final int SPELL_ICON_INDENT = (int)Math.ceil(1.5);
    private static final int ORB_INDENT = 1;
    private static final int ORB_ICON_SIZE = 13;
    private static final int ORB_TEXTURE_U = 0;
    private static final int ORB_TEXTURE_V = 242;
    private static final int BOTTOM_TEXT_OFFSET = 10;
    private static final int COLOR_GOOD = 3604224;
    private static final int COLOR_BAD = 0xFC5C5C;
    private static final int COLOR_GOOD_BUT_DISABLED = 4753678;

    public SpellBindingScreen(SpellBindingScreenHandler handler, class_1661 inventory, class_2561 title) {
        super((class_1703)handler, inventory, title);
        this.stack = class_1799.field_8037;
    }

    protected void method_25426() {
        super.method_25426();
        int originX = (this.field_22789 - this.field_2792) / 2;
        int originY = (this.field_22790 - this.field_2779) / 2;
        int x = originX + 156;
        int y = originY + 5;
        int width = 16;
        int height = 10;
        this.upButton = new CustomButton(x, y, CustomButton.Type.SMALL_UP, button -> this.pageUp());
        this.upButton.field_22764 = false;
        this.downButton = new CustomButton(x, y + 57 + height + 1, CustomButton.Type.SMALL_DOWN, button -> this.pageDown());
        this.downButton.field_22764 = false;
        this.method_37063((class_364)this.upButton);
        this.method_37063((class_364)this.downButton);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        try {
            for (int i = 0; i < this.buttonViewModels.size(); ++i) {
                ButtonViewModel spellButton = this.buttonViewModels.get(i);
                if (!spellButton.mouseOver((int)mouseX, (int)mouseY)) continue;
                this.field_22787.field_1761.method_2900(((SpellBindingScreenHandler)this.field_2797).field_7763, i);
                return true;
            }
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25401(double mouseX, double mouseY, double amount) {
        if (!this.isPagingEnabled()) {
            return false;
        }
        int i = 0;
        while ((double)i < Math.abs(amount)) {
            if (amount > 0.0) {
                this.pageUp();
            } else {
                this.pageDown();
            }
            ++i;
        }
        return true;
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        delta = this.field_22787.method_1488();
        this.method_25420(context);
        super.method_25394(context, mouseX, mouseY, delta);
        this.method_2380(context, mouseX, mouseY);
        class_746 player = class_310.method_1551().field_1724;
        int lapisCount = ((SpellBindingScreenHandler)this.field_2797).getLapisCount();
        class_1799 itemStack = (class_1799)((SpellBindingScreenHandler)this.field_2797).method_7602().get(0);
        block6: for (ButtonViewModel button : this.buttonViewModels) {
            if (button.spell == null || !button.mouseOver(mouseX, mouseY)) continue;
            ArrayList tooltip = Lists.newArrayList();
            boolean showSpellDetails = true;
            switch (button.binding.state) {
                case ALREADY_APPLIED: {
                    tooltip.add(class_2561.method_43471((String)"gui.spell_engine.spell_binding.already_bound").method_27692(class_124.field_1080));
                    break;
                }
                case NO_MORE_SLOT: {
                    tooltip.add(class_2561.method_43471((String)"gui.spell_engine.spell_binding.no_more_slots").method_27692(class_124.field_1080));
                    showSpellDetails = false;
                    break;
                }
                case APPLICABLE: {
                    if (button.binding.readyToApply((class_1657)player, lapisCount)) {
                        tooltip.add(class_2561.method_43471((String)"gui.spell_engine.spell_binding.available").method_27692(class_124.field_1060));
                        break;
                    }
                    if (!button.binding.requirements.metRequiredLevel((class_1657)player)) {
                        tooltip.add(class_2561.method_43469((String)"gui.spell_engine.spell_binding.level_req_fail", (Object[])new Object[]{button.binding.requirements.requiredLevel()}).method_27692(class_124.field_1061));
                        break;
                    }
                    int lapisCost = button.binding.requirements.lapisCost();
                    boolean hasEnoughLapis = button.binding.requirements.hasEnoughLapis(lapisCount);
                    class_5250 lapis = lapisCost == 1 ? class_2561.method_43471((String)"container.enchant.lapis.one") : class_2561.method_43469((String)"container.enchant.lapis.many", (Object[])new Object[]{lapisCost});
                    tooltip.add(lapis.method_27692(hasEnoughLapis ? class_124.field_1080 : class_124.field_1061));
                    int levelCost = button.binding.requirements.levelCost();
                    boolean hasEnoughLevels = button.binding.requirements.hasEnoughLevelsToSpend((class_1657)player);
                    class_5250 levels = levelCost == 1 ? class_2561.method_43471((String)"container.enchant.level.one") : class_2561.method_43469((String)"container.enchant.level.many", (Object[])new Object[]{levelCost});
                    tooltip.add(levels.method_27692(hasEnoughLevels ? class_124.field_1080 : class_124.field_1061));
                    break;
                }
                case INVALID: {
                    continue block6;
                }
            }
            if (showSpellDetails) {
                tooltip.add(class_2561.method_43470((String)" "));
                tooltip.addAll(SpellTooltip.spellInfo(button.spell.id(), (class_1657)player, itemStack, true));
            }
            context.method_51434(this.field_22793, (List)tooltip, mouseX, mouseY);
            break;
        }
    }

    protected void method_2389(class_332 context, float delta, int mouseX, int mouseY) {
        class_308.method_24210();
        int originX = (this.field_22789 - this.field_2792) / 2;
        int originY = (this.field_22790 - this.field_2779) / 2;
        context.method_25302(TEXTURE, originX, originY, 0, 0, this.field_2792, this.field_2779);
        class_1735 bindingSlot = (class_1735)((SpellBindingScreenHandler)this.field_2797).field_7761.get(0);
        if (bindingSlot.method_7677().method_7960()) {
            context.method_25302(TEXTURE, originX + bindingSlot.field_7873, originY + bindingSlot.field_7872, 240, 0, 16, 16);
        }
        class_308.method_24211();
        this.updatePageControls();
        this.updateButtons(originX, originY);
        this.drawButtons(context, mouseX, mouseY);
    }

    private boolean isPagingEnabled() {
        return this.buttonViewModels.size() > 3;
    }

    private int maximalPageOffset() {
        return this.buttonViewModels.size() - 3;
    }

    private boolean hasPageUp() {
        return this.pageOffset > 0;
    }

    private boolean hasPageDown() {
        return this.pageOffset < this.maximalPageOffset();
    }

    private void pageUp() {
        if (this.hasPageUp()) {
            --this.pageOffset;
        }
    }

    private void pageDown() {
        if (this.hasPageDown()) {
            ++this.pageOffset;
        }
    }

    private void restartPaging() {
        this.pageOffset = 0;
    }

    private void updatePageControls() {
        boolean isPaging;
        this.upButton.field_22764 = isPaging = this.isPagingEnabled();
        this.upButton.field_22763 = this.hasPageUp();
        this.downButton.field_22764 = isPaging;
        this.downButton.field_22763 = this.hasPageDown();
    }

    private void updateButtons(int originX, int originY) {
        ArrayList<ButtonViewModel> buttons = new ArrayList<ButtonViewModel>();
        class_1799 itemStack = (class_1799)((SpellBindingScreenHandler)this.field_2797).method_7602().get(0);
        int lapisCount = ((SpellBindingScreenHandler)this.field_2797).getLapisCount();
        SpellBinding.Mode mode = SpellBinding.Mode.values()[((SpellBindingScreenHandler)this.field_2797).mode[0]];
        class_746 player = class_310.method_1551().field_1724;
        try {
            block6: for (int i = 0; i < 32; ++i) {
                int rawId = ((SpellBindingScreenHandler)this.field_2797).spellId[i];
                int cost = ((SpellBindingScreenHandler)this.field_2797).spellCost[i];
                int requirement = ((SpellBindingScreenHandler)this.field_2797).spellLevelRequirement[i];
                boolean shown = i >= this.pageOffset && i < this.pageOffset + 3;
                switch (mode) {
                    case SPELL: {
                        Optional<class_2960> spellId = SpellRegistry.fromRawSpellId(rawId);
                        if (spellId.isEmpty()) continue block6;
                        class_2960 id = spellId.get();
                        SpellInfo spell = new SpellInfo(id, SpellRender.iconTexture(id), (class_2561)class_2561.method_43471((String)SpellTooltip.spellTranslationKey(id)));
                        SpellBinding.State bindingState = SpellBinding.State.of(id, itemStack, cost, requirement);
                        boolean isEnabled = bindingState.readyToApply((class_1657)player, lapisCount);
                        ButtonViewModel button = new ButtonViewModel(shown, originX + 60, originY + 14 + (buttons.size() - this.pageOffset) * 19, 108, 19, isEnabled, spell, null, bindingState);
                        buttons.add(button);
                        continue block6;
                    }
                    case BOOK: {
                        if (rawId < 1) continue block6;
                        SpellBookItem item = SpellBooks.sorted().get(rawId - 1);
                        SpellBinding.State bindingState = SpellBinding.State.forBook(cost, requirement);
                        boolean isEnabled = bindingState.readyToApply((class_1657)player, lapisCount);
                        ButtonViewModel button = new ButtonViewModel(shown, originX + 60, originY + 14 + (buttons.size() - this.pageOffset) * 19, 108, 19, isEnabled, null, (class_1792)item, bindingState);
                        buttons.add(button);
                    }
                }
            }
        }
        catch (Exception e) {
            System.err.println("Error when updating Spell Binding Screen buttons");
            System.err.println(e.getMessage());
        }
        this.setButtons(buttons);
    }

    private void setButtons(List<ButtonViewModel> buttons) {
        if (buttons.size() != this.buttonViewModels.size()) {
            this.restartPaging();
        }
        this.buttonViewModels = buttons;
    }

    private void drawButtons(class_332 context, int mouseX, int mouseY) {
        for (ButtonViewModel button : this.buttonViewModels) {
            ButtonState state = button.mouseOver(mouseX, mouseY) ? ButtonState.HOVER : ButtonState.NORMAL;
            this.drawSpellButton(context, button, state);
        }
    }

    private void drawSpellButton(class_332 context, ButtonViewModel viewModel, ButtonState state) {
        if (!viewModel.shown) {
            return;
        }
        class_746 player = class_310.method_1551().field_1724;
        int u = 0;
        int v = 166;
        if (viewModel.isEnabled) {
            switch (state) {
                case NORMAL: {
                    v += 0;
                    break;
                }
                case HOVER: {
                    v += viewModel.height * 2;
                }
            }
        } else {
            v += viewModel.height;
        }
        context.method_25302(TEXTURE, viewModel.x, viewModel.y, u, v, viewModel.width, viewModel.height);
        if (viewModel.binding.state == SpellBinding.State.ApplyState.NO_MORE_SLOT) {
            return;
        }
        if (viewModel.spell != null || viewModel.item != null) {
            int goodColor;
            boolean alreadyApplied = viewModel.binding.state == SpellBinding.State.ApplyState.ALREADY_APPLIED;
            boolean isUnlocked = alreadyApplied || viewModel.isEnabled;
            class_2561 text = class_2561.method_30163((String)"");
            if (viewModel.spell != null) {
                text = viewModel.spell.name();
            }
            if (viewModel.item != null) {
                text = viewModel.item.method_7848();
            }
            context.method_27535(this.field_22793, text, viewModel.x + viewModel.height, viewModel.y + SPELL_ICON_INDENT, isUnlocked ? 0xFFFFFF : 0x808080);
            int n = goodColor = viewModel.isEnabled ? 3604224 : 4753678;
            if (!alreadyApplied) {
                String levelRequirement = "" + viewModel.binding.requirements.requiredLevel();
                context.method_25303(this.field_22793, levelRequirement, viewModel.x + viewModel.width - 2 - this.field_22793.method_1727(levelRequirement), viewModel.y + viewModel.height - 10, viewModel.binding.requirements.metRequiredLevel((class_1657)player) ? goodColor : 0xFC5C5C);
            }
            context.method_51422(1.0f, 1.0f, 1.0f, isUnlocked ? 1.0f : 0.5f);
            RenderSystem.enableBlend();
            if (viewModel.spell != null && viewModel.spell.icon != null) {
                context.method_25290(viewModel.spell.icon, viewModel.x + SPELL_ICON_INDENT, viewModel.y + SPELL_ICON_INDENT, 0.0f, 0.0f, 16, 16, 16, 16);
            }
            if (viewModel.item != null) {
                context.method_51427(viewModel.item.method_7854(), viewModel.x + SPELL_ICON_INDENT, viewModel.y + SPELL_ICON_INDENT);
            }
            if (!alreadyApplied) {
                context.method_51448().method_46416(0.0f, 0.0f, 300.0f);
                RenderSystem.setShaderTexture((int)0, (class_2960)TEXTURE);
                context.method_25302(TEXTURE, viewModel.x + 1, viewModel.y + viewModel.height - 13 - 1, 0, 242, 13, 13);
                String levelCost = "" + viewModel.binding.requirements.levelCost();
                context.method_25303(this.field_22793, levelCost, (int)((long)(viewModel.x + 1) + Math.round(7.8)), viewModel.y + viewModel.height - 10, viewModel.binding.requirements.hasEnoughLevelsToSpend((class_1657)player) ? goodColor : 0xFC5C5C);
                context.method_51448().method_46416(0.0f, 0.0f, -300.0f);
            }
        }
        RenderSystem.enableDepthTest();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
    }

    record ButtonViewModel(boolean shown, int x, int y, int width, int height, boolean isEnabled, @Nullable SpellInfo spell, @Nullable class_1792 item, SpellBinding.State binding) {
        public boolean mouseOver(int mouseX, int mouseY) {
            if (!this.shown) {
                return false;
            }
            return mouseX > this.x && mouseX < this.x + this.width && mouseY > this.y && mouseY < this.y + this.height;
        }
    }

    record SpellInfo(class_2960 id, class_2960 icon, class_2561 name) {
    }

    static enum ButtonState {
        NORMAL,
        HOVER;

    }
}

