/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.internals.arrow;

import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1665;
import net.minecraft.class_1671;
import net.minecraft.class_1676;
import net.minecraft.class_1744;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3745;
import net.spell_engine.api.spell.Spell;
import net.spell_engine.api.spell.SpellEvents;
import net.spell_engine.api.spell.SpellInfo;
import net.spell_engine.compat.QuiverCompat;
import net.spell_engine.internals.SpellHelper;
import net.spell_engine.internals.WorldScheduler;
import net.spell_engine.internals.arrow.ArrowExtension;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class ArrowHelper {
    public static void shootArrow(class_1937 world, class_1309 shooter, SpellInfo spellInfo, SpellHelper.ImpactContext context) {
        ArrowHelper.shootArrow(world, shooter, spellInfo, context, 0);
    }

    public static void shootArrow(class_1937 world, class_1309 shooter, SpellInfo spellInfo, SpellHelper.ImpactContext context, int sequenceIndex) {
        boolean isCreative = shooter instanceof class_1657 && ((class_1657)shooter).method_31549().field_7477;
        Spell spell = spellInfo.spell();
        Spell.Release.Target.ShootArrow shoot_arrow = spell.release.target.shoot_arrow;
        if (shoot_arrow != null) {
            class_1676 projectile;
            Spell.LaunchProperties launchProperties = shoot_arrow.launch_properties.copy();
            class_1657 player = (class_1657)shooter;
            boolean infinity = !shoot_arrow.consume_arrow || player.method_7337() || class_1890.method_8225((class_1887)class_1893.field_9125, (class_1799)player.method_6047()) > 0;
            class_1665.class_1666 arrowPickUpType = class_1665.class_1666.field_7594;
            class_1799 ammo = new class_1799((class_1935)class_1802.field_8107);
            if (!infinity) {
                arrowPickUpType = class_1665.class_1666.field_7593;
                if (!ArrowHelper.tryConsumeItem(player, class_1802.field_8107)) {
                    return;
                }
            }
            if ((projectile = ArrowHelper.shoot(world, shooter, class_1268.field_5808, shooter.method_6047(), ammo, 1.0f, isCreative, launchProperties.velocity, 1.0f, 0.0f, spellInfo)) instanceof class_1665) {
                class_1665 persistentProjectile = (class_1665)projectile;
                persistentProjectile.method_7438(persistentProjectile.method_7448() * (double)shoot_arrow.damage_multiplier);
                persistentProjectile.field_7572 = arrowPickUpType;
            }
            if (SpellEvents.ARROW_FIRED.isListened()) {
                SpellEvents.ARROW_FIRED.invoke(listener -> listener.onArrowLaunch(new SpellEvents.ArrowLaunchEvent(projectile, shooter, spellInfo, context, sequenceIndex)));
            }
            int extra_launch = launchProperties.extra_launch_count;
            if (sequenceIndex == 0 && extra_launch > 0) {
                for (int i = 0; i < extra_launch; ++i) {
                    int ticks = (i + 1) * launchProperties.extra_launch_delay;
                    int nextSequenceIndex = i + 1;
                    ((WorldScheduler)world).schedule(ticks, () -> {
                        if (shooter == null || !shooter.method_5805()) {
                            return;
                        }
                        ArrowHelper.shootArrow(world, shooter, spellInfo, context, nextSequenceIndex);
                    });
                }
            }
        }
    }

    public static boolean tryConsumeItem(class_1657 player, class_1792 item) {
        if (QuiverCompat.consumeArrow(item, player)) {
            return true;
        }
        for (int i = 0; i < player.method_31548().method_5439(); ++i) {
            class_1799 stack = player.method_31548().method_5438(i);
            if (!stack.method_31574(item)) continue;
            stack.method_7934(1);
            if (stack.method_7960()) {
                player.method_31548().method_7378(stack);
            }
            return true;
        }
        return false;
    }

    private static class_1676 shoot(class_1937 world, class_1309 shooter, class_1268 hand, class_1799 crossbow, class_1799 projectile, float soundPitch, boolean creative, float speed, float divergence, float simulated, SpellInfo spellInfo) {
        class_1665 projectileEntity;
        boolean bl = projectile.method_31574(class_1802.field_8639);
        if (bl) {
            projectileEntity = new class_1671(world, projectile, (class_1297)shooter, shooter.method_23317(), shooter.method_23320() - (double)0.15f, shooter.method_23321(), true);
        } else {
            projectileEntity = ArrowHelper.createArrow(world, shooter, crossbow, projectile, spellInfo);
            if (creative || simulated != 0.0f) {
                projectileEntity.field_7572 = class_1665.class_1666.field_7594;
            }
        }
        if (shooter instanceof class_3745) {
            class_3745 crossbowUser = (class_3745)shooter;
            crossbowUser.method_18811(crossbowUser.method_5968(), crossbow, (class_1676)projectileEntity, simulated);
        } else {
            class_243 vec3d = shooter.method_18864(1.0f);
            Quaternionf quaternionf = new Quaternionf().setAngleAxis((double)(simulated * ((float)Math.PI / 180)), vec3d.field_1352, vec3d.field_1351, vec3d.field_1350);
            class_243 vec3d2 = shooter.method_5828(1.0f);
            Vector3f vector3f = vec3d2.method_46409().rotate((Quaternionfc)quaternionf);
            projectileEntity.method_7485((double)vector3f.x(), (double)vector3f.y(), (double)vector3f.z(), speed, divergence);
        }
        crossbow.method_7956(bl ? 3 : 1, shooter, e -> e.method_20236(hand));
        world.method_8649((class_1297)projectileEntity);
        world.method_43128((class_1657)null, shooter.method_23317(), shooter.method_23318(), shooter.method_23321(), class_3417.field_15187, class_3419.field_15248, 1.0f, soundPitch);
        return projectileEntity;
    }

    private static class_1665 createArrow(class_1937 world, class_1309 entity, class_1799 crossbow, class_1799 arrow, SpellInfo spellInfo) {
        Spell.Release.Target.ShootArrow shoot_arrow;
        class_1744 arrowItem = (class_1744)(arrow.method_7909() instanceof class_1744 ? arrow.method_7909() : class_1802.field_8107);
        class_1665 persistentProjectileEntity = arrowItem.method_7702(world, arrow, entity);
        persistentProjectileEntity.method_7444(class_3417.field_14636);
        persistentProjectileEntity.method_7442(true);
        int i = class_1890.method_8225((class_1887)class_1893.field_9132, (class_1799)crossbow);
        if (i > 0) {
            persistentProjectileEntity.method_7451((byte)i);
        }
        ((ArrowExtension)persistentProjectileEntity).applyArrowPerks(spellInfo);
        Spell.Release release = spellInfo.spell().release;
        if (release != null && (shoot_arrow = release.target.shoot_arrow) != null) {
            persistentProjectileEntity.method_7439(shoot_arrow.arrow_critical_strike);
        }
        return persistentProjectileEntity;
    }
}

