/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.internals;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public interface WorldScheduler {
    public long getSchedulerTime();

    public Map<Long, List<Runnable>> getScheduledTasks();

    default public void schedule(int ticks, Runnable task) {
        if (ticks <= 0) {
            task.run();
            return;
        }
        long executionTime = this.getSchedulerTime() + (long)ticks;
        List list = this.getScheduledTasks().getOrDefault(executionTime, new ArrayList());
        list.add(task);
        this.getScheduledTasks().put(executionTime, list);
    }

    default public void updateScheduledTasks() {
        Map<Long, List<Runnable>> taskQueue = this.getScheduledTasks();
        if (taskQueue.isEmpty()) {
            return;
        }
        long currentTime = this.getSchedulerTime();
        List<Runnable> currentTasks = taskQueue.get(currentTime);
        if (currentTasks != null) {
            for (Runnable task : currentTasks) {
                task.run();
            }
            taskQueue.remove(currentTime);
        }
    }
}

