/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_241;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_3675;
import net.minecraft.class_5348;
import net.minecraft.class_746;
import net.spell_engine.api.spell.SpellInfo;
import net.spell_engine.client.SpellEngineClient;
import net.spell_engine.client.gui.Drawable;
import net.spell_engine.client.gui.HudElement;
import net.spell_engine.client.gui.HudKeyVisuals;
import net.spell_engine.client.gui.HudMessages;
import net.spell_engine.client.input.SpellHotbar;
import net.spell_engine.client.util.Rect;
import net.spell_engine.client.util.SpellRender;
import net.spell_engine.client.util.TextureFile;
import net.spell_engine.config.ClientConfig;
import net.spell_engine.config.HudConfig;
import net.spell_engine.internals.SpellCooldownManager;
import net.spell_engine.internals.SpellHelper;
import net.spell_engine.internals.casting.SpellCast;
import net.spell_engine.internals.casting.SpellCasterClient;
import net.spell_engine.mixin.client.control.KeybindingAccessor;
import org.jetbrains.annotations.Nullable;

public class HudRenderHelper {
    public static void render(class_332 context, float tickDelta) {
        HudRenderHelper.render(context, tickDelta, false);
    }

    public static void render(class_332 context, float tickDelta, boolean config) {
        HudConfig hudConfig = (HudConfig)SpellEngineClient.hudConfig.value;
        class_310 client = class_310.method_1551();
        class_746 player = client.field_1724;
        if (player == null && !config) {
            return;
        }
        ClientConfig clientConfig = SpellEngineClient.config;
        TargetWidget.ViewModel targetViewModel = TargetWidget.ViewModel.mock();
        boolean renderHotbar = true;
        SpellHotBarWidget.ViewModel hotbarViewModel = SpellHotBarWidget.ViewModel.mock();
        ErrorMessageWidget.ViewModel errorViewModel = ErrorMessageWidget.ViewModel.mock();
        Object hotbarAccessories = null;
        CastBarWidget.ViewModel castBarViewModel = null;
        if (config) {
            castBarViewModel = CastBarWidget.ViewModel.mock();
        } else {
            targetViewModel = TargetWidget.ViewModel.from(player);
        }
        if (player != null) {
            SpellCasterClient caster = (SpellCasterClient)player;
            if (SpellHotbar.INSTANCE.slots.isEmpty()) {
                hotbarViewModel = SpellHotBarWidget.ViewModel.empty;
            } else {
                SpellCooldownManager cooldownManager = caster.getCooldownManager();
                List<SpellHotBarWidget.SpellViewModel> spells = SpellHotbar.INSTANCE.slots.stream().map(slot -> {
                    SpellInfo info = slot.spell();
                    boolean useItem = slot.spell().spell().item_use.shows_item_as_icon;
                    return new SpellHotBarWidget.SpellViewModel(useItem ? null : SpellRender.iconTexture(info.id()), useItem ? SpellHotbar.expectedUseStack((class_1657)player) : null, cooldownManager.getCooldownProgress(new class_2960(info.id().toString()), tickDelta), SpellHotBarWidget.KeyBindingViewModel.from(slot.getKeyBinding(client.field_1690)), slot.modifier() != null ? SpellHotBarWidget.KeyBindingViewModel.from(slot.modifier()) : null);
                }).collect(Collectors.toList());
                hotbarViewModel = new SpellHotBarWidget.ViewModel(spells);
            }
            renderHotbar = true;
            SpellCast.Progress spellCast = caster.getSpellCastProgress();
            if (spellCast != null) {
                castBarViewModel = new CastBarWidget.ViewModel(spellCast.process().spell().school.color(), spellCast.ratio(), spellCast.process().length(), SpellRender.iconTexture(spellCast.process().id()), true, SpellHelper.isChanneled(spellCast.process().spell()));
            }
            if (!config) {
                HudMessages hudMessages = HudMessages.INSTANCE;
                HudMessages.ErrorMessageState error = hudMessages.currentError();
                errorViewModel = error != null && error.durationLeft > 0 ? ErrorMessageWidget.ViewModel.from(error.message, error.durationLeft, error.fadeOut, tickDelta) : null;
            }
        }
        int screenWidth = client.method_22683().method_4486();
        int screenHeight = client.method_22683().method_4502();
        class_241 originPoint = hudConfig.castbar.base.origin.getPoint(screenWidth, screenHeight);
        class_241 baseOffset = originPoint.method_35586(hudConfig.castbar.base.offset);
        if (castBarViewModel != null) {
            CastBarWidget.render(context, tickDelta, hudConfig, baseOffset, castBarViewModel);
        }
        if (hudConfig.castbar.target.visible) {
            class_241 targetOffset = baseOffset.method_35586(hudConfig.castbar.target.offset);
            TargetWidget.render(context, tickDelta, targetOffset, targetViewModel);
        }
        if (renderHotbar || config) {
            if (config && (hotbarViewModel == null || hotbarViewModel.isEmpty())) {
                hotbarViewModel = SpellHotBarWidget.ViewModel.mock();
            }
            SpellHotBarWidget.render(context, screenWidth, screenHeight, hotbarViewModel);
        }
        if (errorViewModel != null) {
            ErrorMessageWidget.render(context, hudConfig, screenWidth, screenHeight, errorViewModel);
        }
    }

    public static class TargetWidget {
        public static void render(class_332 context, float tickDelta, class_241 starting, ViewModel viewModel) {
            class_310 client = class_310.method_1551();
            class_327 textRenderer = client.field_1705.method_1756();
            int textWidth = textRenderer.method_1727(viewModel.text);
            int x = (int)(starting.field_1343 - (float)textWidth / 2.0f);
            int y = (int)starting.field_1342;
            int opacity = 255;
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            context.method_51422(1.0f, 1.0f, 1.0f, 1.0f);
            Objects.requireNonNull(textRenderer);
            context.method_25294(x - 2, y - 2, x + textWidth + 2, y + 9 + 2, client.field_1690.method_19344(0));
            context.method_25303(textRenderer, viewModel.text, x, y, 0xFFFFFF);
            RenderSystem.disableBlend();
            context.method_51422(1.0f, 1.0f, 1.0f, 1.0f);
        }

        public record ViewModel(String text) {
            public static ViewModel mock() {
                return new ViewModel("Target name");
            }

            public static ViewModel from(class_746 player) {
                SpellCasterClient caster = (SpellCasterClient)player;
                class_1297 target = caster.getCurrentFirstTarget();
                String text = "";
                if (target != null && caster.getCurrentTargets().size() == 1) {
                    text = target.method_5477().getString();
                }
                return new ViewModel(text);
            }
        }
    }

    public class SpellHotBarWidget {
        public static Rect lastRendered;
        private static final TextureFile WIDGETS;
        private static final TextureFile ACCESSORIES;
        private static final int slotHeight = 22;
        private static final int slotWidth = 20;
        private static final Map<Integer, String> customHudKeyLabels;

        private static String acronym(String phrase, int maxLength) {
            StringBuilder result = new StringBuilder();
            for (String token : phrase.split("\\s+")) {
                result.append(token.toUpperCase().charAt(0));
            }
            String resultString = result.toString();
            if (resultString.length() > maxLength) {
                resultString = resultString.substring(0, maxLength);
            }
            return result.toString();
        }

        public static void render(class_332 context, int screenWidth, int screenHeight, ViewModel viewModel) {
            HudElement config = ((HudConfig)SpellEngineClient.hudConfig.value).hotbar;
            class_310 client = class_310.method_1551();
            class_327 textRenderer = client.field_1705.method_1756();
            if (viewModel.spells.isEmpty()) {
                return;
            }
            float estimatedWidth = 20 * viewModel.spells.size();
            float estimatedHeight = 22.0f;
            class_241 origin = config.origin.getPoint(screenWidth, screenHeight).method_35586(config.offset).method_35586(new class_241(estimatedWidth * -0.5f, estimatedHeight * -0.5f));
            lastRendered = new Rect(origin, origin.method_35586(new class_241(estimatedWidth, estimatedHeight)));
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            float barOpacity = 1.0f;
            context.method_51422(1.0f, 1.0f, 1.0f, barOpacity);
            context.method_25290(WIDGETS.id(), (int)origin.field_1343, (int)origin.field_1342, 0.0f, 0.0f, 10, 22, WIDGETS.width(), WIDGETS.height());
            int middleElements = viewModel.spells.size() - 1;
            for (int i = 0; i < middleElements; ++i) {
                context.method_25290(WIDGETS.id(), (int)origin.field_1343 + 10 + i * 20, (int)origin.field_1342, 10.0f, 0.0f, 20, 22, WIDGETS.width(), WIDGETS.height());
            }
            context.method_25290(WIDGETS.id(), (int)origin.field_1343 + 10 + middleElements * 20, (int)origin.field_1342, 170.0f, 0.0f, 12, 22, WIDGETS.width(), WIDGETS.height());
            context.method_51422(1.0f, 1.0f, 1.0f, 1.0f);
            class_241 iconsOffset = new class_241(3.0f, 3.0f);
            int iconSize = 16;
            for (int i = 0; i < viewModel.spells.size(); ++i) {
                SpellViewModel spell = viewModel.spells.get(i);
                int x = (int)(origin.field_1343 + iconsOffset.field_1343) + 20 * i;
                int y = (int)(origin.field_1342 + iconsOffset.field_1342);
                RenderSystem.enableBlend();
                if (spell.iconId != null) {
                    context.method_25290(spell.iconId, x, y, 0.0f, 0.0f, iconSize, iconSize, iconSize, iconSize);
                } else if (spell.itemStack != null) {
                    context.method_51427(spell.itemStack, x, y);
                }
                if (spell.cooldown > 0.0f) {
                    SpellHotBarWidget.renderCooldown(context, spell.cooldown, x, y);
                }
                if (spell.keybinding() == null) continue;
                int keybindingX = x + iconSize / 2;
                int keybindingY = (int)origin.field_1342 + 2;
                if (spell.modifier != null) {
                    keybindingX += 2;
                    int spacing = 1;
                    int modifierWidth = spell.modifier().width(textRenderer);
                    int keybindingWidth = spell.keybinding().width(textRenderer);
                    int totalWidth = modifierWidth + keybindingWidth;
                    SpellHotBarWidget.drawKeybinding(context, textRenderer, spell.modifier, keybindingX -= totalWidth / 2, keybindingY, Drawable.Anchor.LEADING, Drawable.Anchor.TRAILING);
                    SpellHotBarWidget.drawKeybinding(context, textRenderer, spell.keybinding(), keybindingX += modifierWidth + spacing, keybindingY, Drawable.Anchor.LEADING, Drawable.Anchor.TRAILING);
                    continue;
                }
                SpellHotBarWidget.drawKeybinding(context, textRenderer, spell.keybinding(), keybindingX, keybindingY, Drawable.Anchor.CENTER, Drawable.Anchor.TRAILING);
            }
            RenderSystem.disableBlend();
            context.method_51422(1.0f, 1.0f, 1.0f, 1.0f);
        }

        private static void drawKeybinding(class_332 context, class_327 textRenderer, KeyBindingViewModel keybinding, int x, int y, Drawable.Anchor horizontalAnchor, Drawable.Anchor verticalAnchor) {
            if (keybinding.drawable != null) {
                keybinding.drawable.draw(context, x, y, horizontalAnchor, verticalAnchor);
            } else {
                int textLength = textRenderer.method_1727(keybinding.label);
                int xOffset = 0;
                switch (horizontalAnchor) {
                    case TRAILING: {
                        xOffset = -textLength / 2;
                        break;
                    }
                    case CENTER: {
                        xOffset = 0;
                        break;
                    }
                    case LEADING: {
                        xOffset = textLength / 2;
                    }
                }
                HudKeyVisuals.buttonLeading.draw(context, (x += xOffset) - textLength / 2, y, Drawable.Anchor.TRAILING, verticalAnchor);
                HudKeyVisuals.buttonCenter.drawFlexibleWidth(context, x - textLength / 2, y, textLength, verticalAnchor);
                HudKeyVisuals.buttonTrailing.draw(context, x + textLength / 2, y, Drawable.Anchor.LEADING, verticalAnchor);
                context.method_25300(textRenderer, keybinding.label, x, y - 10, 0xFFFFFF);
            }
        }

        private static void renderCooldown(class_332 context, float progress, int x, int y) {
            int k = y + class_3532.method_15375((float)(16.0f * (1.0f - progress)));
            int l = k + class_3532.method_15386((float)(16.0f * progress));
            context.method_51739(class_1921.method_51785(), x, k, x + 16, l, Integer.MAX_VALUE);
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
        }

        static {
            WIDGETS = new TextureFile(new class_2960("textures/gui/widgets.png"), 256, 256);
            ACCESSORIES = new TextureFile(new class_2960("spell_engine", "textures/hud/hotbar_accessories.png"), 32, 16);
            customHudKeyLabels = Map.of(342, "Al", 346, "Al", 340, "\u2191", 344, "\u2191");
        }

        public record ViewModel(List<SpellViewModel> spells) {
            public static final ViewModel empty = new ViewModel(List.of());

            public static ViewModel mock() {
                return new ViewModel(List.of(new SpellViewModel(SpellRender.iconTexture(new class_2960("spell_engine", "dummy_spell")), null, 0.0f, new KeyBindingViewModel("1", null), null), new SpellViewModel(SpellRender.iconTexture(new class_2960("spell_engine", "dummy_spell")), null, 0.0f, new KeyBindingViewModel("2", null), null), new SpellViewModel(SpellRender.iconTexture(new class_2960("spell_engine", "dummy_spell")), null, 0.0f, new KeyBindingViewModel("3", null), null)));
            }

            public boolean isEmpty() {
                return this.spells.isEmpty();
            }
        }

        public record SpellViewModel(@Nullable class_2960 iconId, @Nullable class_1799 itemStack, float cooldown, KeyBindingViewModel keybinding, @Nullable KeyBindingViewModel modifier) {
        }

        public record KeyBindingViewModel(String label, @Nullable Drawable.Component drawable) {
            public static KeyBindingViewModel from(@Nullable class_304 keyBinding) {
                if (keyBinding == null) {
                    return new KeyBindingViewModel("", null);
                }
                class_3675.class_306 boundKey = ((KeybindingAccessor)keyBinding).getBoundKey();
                String key = boundKey.toString();
                Drawable.Component drawable = HudKeyVisuals.custom.get(key);
                if (drawable != null) {
                    return new KeyBindingViewModel("", drawable);
                }
                String customLabel = customHudKeyLabels.get(boundKey.method_1444());
                if (customLabel != null) {
                    return new KeyBindingViewModel(customLabel, null);
                }
                String label = keyBinding.method_16007().getString().toUpperCase(Locale.US);
                label = SpellHotBarWidget.acronym(label, 3);
                return new KeyBindingViewModel(label, null);
            }

            public int width(class_327 textRenderer) {
                if (this.drawable != null) {
                    return this.drawable.draw().width();
                }
                return textRenderer.method_1727(this.label);
            }
        }
    }

    public static class ErrorMessageWidget {
        public static Rect lastRendered;

        public static void render(class_332 context, HudConfig hudConfig, int screenWidth, int screenHeight, ViewModel viewModel) {
            int alpha = (int)(viewModel.opacity * 255.0f);
            if (alpha < 10) {
                return;
            }
            class_310 client = class_310.method_1551();
            class_327 textRenderer = client.field_1705.method_1756();
            int textWidth = textRenderer.method_27525((class_5348)viewModel.message);
            Objects.requireNonNull(textRenderer);
            int textHeight = 9;
            HudElement config = hudConfig.error_message;
            class_241 origin = config.origin.getPoint(screenWidth, screenHeight).method_35586(config.offset);
            int x = (int)(origin.field_1343 - (float)textWidth / 2.0f);
            int y = (int)origin.field_1342;
            lastRendered = new Rect(new class_241((float)x, (float)y), new class_241((float)(x + textWidth), (float)(y + textHeight)));
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            Objects.requireNonNull(textRenderer);
            context.method_25294(x - 2, y - 2, x + textWidth + 2, y + 9 + 2, client.field_1690.method_19344(0));
            context.method_27535(textRenderer, viewModel.message(), x, y, 0xFFFFFF + (alpha << 24));
            RenderSystem.disableBlend();
        }

        public record ViewModel(class_2561 message, float opacity) {
            public static ViewModel mock() {
                return new ViewModel((class_2561)class_2561.method_43470((String)"Error Message!").method_27692(class_124.field_1061), 1.0f);
            }

            public static ViewModel from(class_2561 message, int durationLeft, int fadeOut, float tickDelta) {
                float tick = (float)durationLeft - tickDelta;
                float opacity = tick > (float)fadeOut ? 1.0f : tick / (float)fadeOut;
                return new ViewModel(message, opacity);
            }
        }
    }

    public static class CastBarWidget {
        public static Rect lastRendered;
        private static final float tailWidth = 5.0f;
        public static final float minWidth = 10.0f;
        private static final int textureWidth = 182;
        private static final int textureHeight = 10;
        private static final int barHeight = 5;
        private static final class_2960 CAST_BAR;
        private static final int spellIconSize = 16;

        public static void render(class_332 context, float tickDelta, HudConfig hudConfig, class_241 starting, ViewModel viewModel) {
            int barWidth = hudConfig.castbar.width;
            float totalWidth = (float)barWidth + 10.0f;
            int totalHeight = 5;
            int x = (int)(starting.field_1343 - totalWidth / 2.0f);
            int y = (int)(starting.field_1342 - (float)(totalHeight / 2));
            lastRendered = new Rect(new class_241((float)x, (float)y), new class_241((float)x + totalWidth, (float)(y + totalHeight)));
            RenderSystem.enableBlend();
            float red = (float)(viewModel.color >> 16 & 0xFF) / 255.0f;
            float green = (float)(viewModel.color >> 8 & 0xFF) / 255.0f;
            float blue = (float)(viewModel.color & 0xFF) / 255.0f;
            context.method_51422(red, green, blue, 1.0f);
            CastBarWidget.renderBar(context, barWidth, true, 1.0f, x, y);
            float partialProgress = 0.0f;
            if (viewModel.allowTickDelta && viewModel.castDuration > 0.0f) {
                partialProgress = tickDelta / viewModel.castDuration;
            }
            float progress = viewModel.reverse() ? 1.0f - viewModel.progress - partialProgress : viewModel.progress + partialProgress;
            CastBarWidget.renderBar(context, barWidth, false, progress, x, y);
            if (hudConfig.castbar.icon.visible && viewModel.iconTexture != null) {
                x = (int)(starting.field_1343 + hudConfig.castbar.icon.offset.field_1343);
                y = (int)(starting.field_1342 + hudConfig.castbar.icon.offset.field_1342);
                context.method_51422(1.0f, 1.0f, 1.0f, 1.0f);
                context.method_25290(viewModel.iconTexture, x, y, 0.0f, 0.0f, 16, 16, 16, 16);
            }
            RenderSystem.disableBlend();
            context.method_51422(1.0f, 1.0f, 1.0f, 1.0f);
        }

        private static void renderBar(class_332 context, int barWidth, boolean isBackground, float progress, int x, int y) {
            float totalWidth = (float)barWidth + 10.0f;
            float centerWidth = totalWidth - 10.0f;
            float leftRenderBegin = 0.0f;
            float centerRenderBegin = 5.0f;
            float rightRenderBegin = totalWidth - 5.0f;
            CastBarWidget.renderBarPart(context, isBackground, PART.LEFT, progress, leftRenderBegin, 5.0f, x, y, totalWidth);
            CastBarWidget.renderBarPart(context, isBackground, PART.CENTER, progress, centerRenderBegin, centerRenderBegin + centerWidth, x, y, totalWidth);
            CastBarWidget.renderBarPart(context, isBackground, PART.RIGHT, progress, rightRenderBegin, totalWidth, x, y, totalWidth);
        }

        private static void renderBarPart(class_332 context, boolean isBackground, PART part, float progress, float renderBegin, float renderEnd, int x, int y, float totalWidth) {
            int u = 0;
            float partMaxWidth = renderEnd - renderBegin;
            float progressRange = (renderEnd - renderBegin) / totalWidth;
            float progressFloor = renderBegin / totalWidth;
            float adjustedProgress = Math.min(Math.max(progress - progressFloor, 0.0f), progressRange) / progressRange;
            int width = Math.round(adjustedProgress * partMaxWidth);
            switch (part) {
                case LEFT: {
                    u = 0;
                    break;
                }
                case CENTER: {
                    u = 5;
                    break;
                }
                case RIGHT: {
                    u = 177;
                }
            }
            int v = isBackground ? 0 : 5;
            context.method_25290(CAST_BAR, (int)((float)x + renderBegin), y, (float)u, (float)v, width, 5, 182, 10);
        }

        static {
            CAST_BAR = new class_2960("spell_engine", "textures/hud/castbar.png");
        }

        public record ViewModel(int color, float progress, float castDuration, class_2960 iconTexture, boolean allowTickDelta, boolean reverse) {
            public static ViewModel mock() {
                return new ViewModel(0xFF3300, 0.5f, 1.0f, SpellRender.iconTexture(new class_2960("spell_engine", "dummy_spell")), false, false);
            }
        }

        static enum PART {
            LEFT,
            CENTER,
            RIGHT;

        }
    }
}

