/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.api.item.armor;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.minecraft.class_1304;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1738;
import net.minecraft.class_1741;
import net.minecraft.class_1761;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3528;
import net.minecraft.class_5134;
import net.minecraft.class_5321;
import net.minecraft.class_7923;
import net.spell_engine.api.item.AttributeResolver;
import net.spell_engine.api.item.ConfigurableAttributes;
import net.spell_engine.api.item.ItemConfig;
import net.spell_power.api.enchantment.SpellPowerEnchanting;

public class Armor {
    private static final UUID[] MODIFIERS = new UUID[]{UUID.fromString("845DB27C-C624-495F-8C9F-6020A9A58B6B"), UUID.fromString("D8499B04-0E66-4726-AB29-64469D734E0D"), UUID.fromString("9F3D476D-C118-4544-8365-64846904B48E"), UUID.fromString("2AD3F246-FEE1-4E67-B886-69FD380BB150")};

    public static void register(Map<String, ItemConfig.ArmorSet> configs, List<Entry> entries, class_5321<class_1761> itemGroupKey) {
        for (Entry entry : entries) {
            ItemConfig.ArmorSet config = configs.get(entry.name());
            if (config == null) {
                config = entry.defaults();
                configs.put(entry.name(), config);
            }
            entry.material().configure(config);
            for (Object piece : entry.armorSet().pieces()) {
                class_1304 slot = ((class_1738)piece).method_7685();
                ((ConfigurableAttributes)piece).setAttributes(Armor.attributesFrom(config, slot));
            }
            entry.armorSet().register(itemGroupKey);
        }
    }

    private static Multimap<class_1320, class_1322> attributesFrom(ItemConfig.ArmorSet config, class_1304 slot) {
        ItemConfig.ArmorSet.Piece piece = null;
        UUID uuid = MODIFIERS[slot.method_5927()];
        switch (slot) {
            case field_6166: {
                piece = config.feet;
                break;
            }
            case field_6172: {
                piece = config.legs;
                break;
            }
            case field_6174: {
                piece = config.chest;
                break;
            }
            case field_6169: {
                piece = config.head;
            }
        }
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        if (config.armor_toughness != 0.0f) {
            builder.put((Object)class_5134.field_23725, (Object)new class_1322(uuid, "Armor modifier", (double)config.armor_toughness, class_1322.class_1323.field_6328));
        }
        if (config.knockback_resistance != 0.0f) {
            builder.put((Object)class_5134.field_23718, (Object)new class_1322(uuid, "Armor modifier", (double)config.knockback_resistance, class_1322.class_1323.field_6328));
        }
        if (piece.armor != 0) {
            builder.put((Object)class_5134.field_23724, (Object)new class_1322(uuid, "Armor modifier", (double)piece.armor, class_1322.class_1323.field_6328));
        }
        for (ItemConfig.Attribute attribute : piece.attributes) {
            try {
                class_1320 entityAttribute = AttributeResolver.get(new class_2960(attribute.id));
                builder.put((Object)entityAttribute, (Object)new class_1322(uuid, "Armor modifier", (double)attribute.value, attribute.operation));
            }
            catch (Exception e) {
                System.err.println("Failed to add item attribute modifier: " + e.getMessage());
            }
        }
        return builder.build();
    }

    public record Entry(CustomMaterial material, Set armorSet, ItemConfig.ArmorSet defaults) {
        public String name() {
            return this.material.method_7694();
        }

        @Deprecated
        public <T extends class_1738> Set<T> armorSet(Function<CustomMaterial, Set<T>> factory, ArrayList<Entry> entries) {
            Set<T> armorSet = factory.apply(this.material);
            entries.add(new Entry(this.material, armorSet, this.defaults));
            return armorSet;
        }

        public <T extends class_1738> Entry bundle(Function<CustomMaterial, Set<T>> factory) {
            Set<T> armorSet = factory.apply(this.material);
            return new Entry(this.material, armorSet, this.defaults);
        }

        public <T extends class_1738> Entry put(ArrayList<Entry> list) {
            list.add(this);
            return this;
        }
    }

    public static class CustomMaterial
    implements class_1741 {
        private static final EnumMap<class_1738.class_8051, Integer> BASE_DURABILITY = new EnumMap<class_1738.class_8051, Integer>(Map.of(class_1738.class_8051.field_41937, 13, class_1738.class_8051.field_41936, 15, class_1738.class_8051.field_41935, 16, class_1738.class_8051.field_41934, 11));
        private final String name;
        private final int durabilityMultiplier;
        private final int enchantability;
        private final class_3414 equipSound;
        private final class_3528<class_1856> repairIngredientSupplier;
        private EnumMap<class_1738.class_8051, Integer> protectionAmounts;
        private float toughness;
        private float knockbackResistance;

        public CustomMaterial(String name, int durabilityMultiplier, int enchantability, class_3414 equipSound, Supplier<class_1856> repairIngredientSupplier) {
            this.name = name;
            this.durabilityMultiplier = durabilityMultiplier;
            this.enchantability = enchantability;
            this.equipSound = equipSound;
            this.repairIngredientSupplier = new class_3528(repairIngredientSupplier);
            this.protectionAmounts = new EnumMap<class_1738.class_8051, Integer>(Map.of(class_1738.class_8051.field_41937, 0, class_1738.class_8051.field_41936, 0, class_1738.class_8051.field_41935, 0, class_1738.class_8051.field_41934, 0));
            this.toughness = 0.0f;
            this.knockbackResistance = 0.0f;
        }

        public int method_48402(class_1738.class_8051 type) {
            return BASE_DURABILITY.get(type) * this.durabilityMultiplier;
        }

        public int method_48403(class_1738.class_8051 type) {
            return this.protectionAmounts.get(type);
        }

        public int method_7699() {
            return this.enchantability;
        }

        public class_3414 method_7698() {
            return this.equipSound;
        }

        public class_1856 method_7695() {
            return (class_1856)this.repairIngredientSupplier.method_15332();
        }

        public String name() {
            return this.name;
        }

        @Deprecated
        public String method_7694() {
            return this.name;
        }

        public float method_7700() {
            return this.toughness;
        }

        public float method_24355() {
            return this.knockbackResistance;
        }

        public void configure(ItemConfig.ArmorSet config) {
            this.toughness = config.armor_toughness;
            this.knockbackResistance = config.knockback_resistance;
            this.protectionAmounts = new EnumMap<class_1738.class_8051, Integer>(Map.of(class_1738.class_8051.field_41937, config.feet.armor, class_1738.class_8051.field_41936, config.legs.armor, class_1738.class_8051.field_41935, config.chest.armor, class_1738.class_8051.field_41934, config.head.armor));
        }
    }

    public static class Set<A extends class_1738> {
        public final String namespace;
        public final A head;
        public final A chest;
        public final A legs;
        public final A feet;
        public boolean allowSpellPowerEnchanting = true;

        public Set(String namespace, A head, A chest, A legs, A feet) {
            this.namespace = namespace;
            this.head = head;
            this.chest = chest;
            this.legs = legs;
            this.feet = feet;
        }

        public List<A> pieces() {
            return Stream.of(this.head, this.chest, this.legs, this.feet).filter(Objects::nonNull).collect(Collectors.toList());
        }

        public class_2960 idOf(class_1738 piece) {
            String name = piece.method_7686().method_7694() + "_" + piece.method_7685().method_5923();
            return new class_2960(this.namespace, name);
        }

        public List<String> idStrings() {
            return this.pieces().stream().map(piece -> this.idOf((class_1738)piece).toString()).toList();
        }

        public Set<A> allowSpellPowerEnchanting(boolean allow) {
            this.allowSpellPowerEnchanting = allow;
            return this;
        }

        public void register(class_5321<class_1761> itemGroupKey) {
            for (class_1738 piece : this.pieces()) {
                class_2378.method_10230((class_2378)class_7923.field_41178, (class_2960)this.idOf(piece), (Object)piece);
                if (!this.allowSpellPowerEnchanting) continue;
                SpellPowerEnchanting.registerArmor((class_1738)piece);
            }
            ItemGroupEvents.modifyEntriesEvent(itemGroupKey).register(content -> {
                for (class_1738 piece : this.pieces()) {
                    content.method_45421((class_1935)piece);
                }
            });
        }
    }
}

