/*
 * Decompiled with CFR 0.152.
 */
package com.oblivioussp.spartanweaponry.util;

import com.oblivioussp.spartanweaponry.item.HeavyCrossbowItem;
import com.oblivioussp.spartanweaponry.item.QuiverBaseItem;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BowItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ShootableItem;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.ModList;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import top.theillusivec4.curios.api.CuriosApi;

public class QuiverHelper {
    public static List<IQuiverInfo> info;
    public static final Predicate<ItemStack> ARROW_QUIVER;
    public static final Predicate<ItemStack> BOLT_QUIVER;
    public static final Predicate<ItemStack> HEAVY_CROSSBOW;

    public static ItemStack findFirstOfType(PlayerEntity player, IQuiverInfo info) {
        Optional opt;
        if (ModList.get().isLoaded("curios") && (opt = CuriosApi.getCuriosHelper().findEquippedCurio(stack -> stack.func_77973_b() instanceof QuiverBaseItem, (LivingEntity)player)).isPresent() && info.isQuiver((ItemStack)((ImmutableTriple)opt.get()).right)) {
            return (ItemStack)((ImmutableTriple)opt.get()).right;
        }
        for (int i = 0; i < 9; ++i) {
            ItemStack stack2 = player.field_71071_by.func_70301_a(i);
            if (stack2.func_190926_b() || !info.isQuiver(stack2)) continue;
            return stack2;
        }
        return ItemStack.field_190927_a;
    }

    public static List<ItemStack> findValidQuivers(PlayerEntity player) {
        Optional opt;
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        if (ModList.get().isLoaded("curios") && (opt = CuriosApi.getCuriosHelper().findEquippedCurio(stack -> stack.func_77973_b() instanceof QuiverBaseItem, (LivingEntity)player)).isPresent()) {
            result.add((ItemStack)((ImmutableTriple)opt.get()).right);
        }
        for (int i = 0; i < 9; ++i) {
            ItemStack stack2 = player.field_71071_by.func_70301_a(i);
            if (stack2.func_190926_b() || !(stack2.func_77973_b() instanceof QuiverBaseItem)) continue;
            result.add(stack2);
        }
        return result;
    }

    public static ItemStack findFirstQuiver(PlayerEntity player) {
        Optional opt;
        if (ModList.get().isLoaded("curios") && (opt = CuriosApi.getCuriosHelper().findEquippedCurio(stack -> stack.func_77973_b() instanceof QuiverBaseItem, (LivingEntity)player)).isPresent()) {
            return (ItemStack)((ImmutableTriple)opt.get()).right;
        }
        for (int i = 0; i < 9; ++i) {
            ItemStack stack2 = player.field_71071_by.func_70301_a(i);
            if (stack2.func_190926_b() || !(stack2.func_77973_b() instanceof QuiverBaseItem)) continue;
            return stack2;
        }
        return ItemStack.field_190927_a;
    }

    static {
        ARROW_QUIVER = stack -> stack.func_77973_b().func_206844_a(ItemTags.func_199903_a().func_199910_a(new ResourceLocation("spartanweaponry", "arrow_quivers")));
        BOLT_QUIVER = stack -> stack.func_77973_b().func_206844_a(ItemTags.func_199903_a().func_199910_a(new ResourceLocation("spartanweaponry", "bolt_quivers")));
        HEAVY_CROSSBOW = stack -> stack.func_77973_b().func_206844_a(ItemTags.func_199903_a().func_199910_a(new ResourceLocation("spartanweaponry", "heavy_crossbows")));
        info = new ArrayList<IQuiverInfo>();
        info.add(new IQuiverInfo(){

            @Override
            public boolean isQuiver(ItemStack stack) {
                return stack.func_190926_b() ? false : BOLT_QUIVER.test(stack);
            }

            @Override
            public boolean isWeapon(ItemStack stack) {
                return stack.func_190926_b() ? false : HEAVY_CROSSBOW.test(stack);
            }

            @Override
            public boolean isAmmo(ItemStack stack) {
                return stack.func_190926_b() ? false : HeavyCrossbowItem.BOLT.test(stack);
            }
        });
        info.add(new IQuiverInfo(){

            @Override
            public boolean isQuiver(ItemStack stack) {
                return stack.func_190926_b() ? false : ARROW_QUIVER.test(stack);
            }

            @Override
            public boolean isWeapon(ItemStack stack) {
                return stack.func_190926_b() ? false : stack.func_77973_b() instanceof ShootableItem && !(stack.func_77973_b() instanceof HeavyCrossbowItem);
            }

            @Override
            public boolean isAmmo(ItemStack stack) {
                return stack.func_190926_b() ? false : BowItem.field_220007_a.test(stack);
            }
        });
    }

    public static interface IQuiverInfo {
        public boolean isQuiver(ItemStack var1);

        public boolean isWeapon(ItemStack var1);

        public boolean isAmmo(ItemStack var1);
    }
}

