/*
 * Decompiled with CFR 0.152.
 */
package com.oblivioussp.spartanweaponry.util;

import com.google.common.collect.ImmutableList;
import com.oblivioussp.spartanweaponry.api.APIConfigValues;
import com.oblivioussp.spartanweaponry.api.WeaponMaterial;
import com.oblivioussp.spartanweaponry.api.WeaponTraits;
import com.oblivioussp.spartanweaponry.api.crafting.condition.TypeDisabledCondition;
import com.oblivioussp.spartanweaponry.init.ModItems;
import com.oblivioussp.spartanweaponry.merchant.villager.WeaponsmithTrades;
import com.oblivioussp.spartanweaponry.util.Defaults;
import java.util.Arrays;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class Config {
    public static final Config INSTANCE;
    public static final ForgeConfigSpec CONFIG_SPEC;
    public WeaponCategory daggers;
    public WeaponCategory parryingDaggers;
    public WeaponCategory longswords;
    public WeaponCategory katanas;
    public WeaponCategory sabers;
    public WeaponCategory rapiers;
    public WeaponCategory greatswords;
    public WeaponCategory clubs;
    public WeaponCategory cestus;
    public WeaponCategory battleHammers;
    public WeaponCategory warhammers;
    public WeaponCategory spears;
    public WeaponCategory halberds;
    public WeaponCategory pikes;
    public WeaponCategory lances;
    public RangedWeaponCategory longbows;
    public RangedWeaponCategory heavyCrossbows;
    public ThrowingWeaponCategory throwingKnives;
    public ThrowingWeaponCategory tomahawks;
    public ThrowingWeaponCategory javelins;
    public ThrowingWeaponCategory boomerangs;
    public WeaponCategory battleaxes;
    public WeaponCategory flangedMaces;
    public WeaponCategory glaives;
    public WeaponCategory quarterstaves;
    public WeaponCategory scythes;
    public MaterialCategory copper;
    public MaterialCategory tin;
    public MaterialCategory bronze;
    public MaterialCategory steel;
    public MaterialCategory silver;
    public MaterialCategory invar;
    public MaterialCategory platinum;
    public MaterialCategory electrum;
    public MaterialCategory nickel;
    public MaterialCategory lead;
    public ForgeConfigSpec.BooleanValue disableRecipesExplosives;
    public ForgeConfigSpec.BooleanValue disableTerrainDamage;
    public ForgeConfigSpec.IntValue fuseTicksDynamite;
    public ForgeConfigSpec.DoubleValue explosionStrengthDynamite;
    public ForgeConfigSpec.BooleanValue disableNewArrowRecipes;
    public ForgeConfigSpec.BooleanValue disableDiamondAmmoRecipes;
    public ForgeConfigSpec.BooleanValue disableQuiverRecipes;
    public ProjectileCategory arrowWood;
    public ProjectileCategory arrowIron;
    public ProjectileCategory arrowDiamond;
    public ForgeConfigSpec.DoubleValue arrowExplosiveExplosionStrength;
    public ForgeConfigSpec.DoubleValue arrowExplosiveRangeMultiplier;
    public BoltCategory bolt;
    public BoltCategory boltDiamond;
    public ForgeConfigSpec.ConfigValue<List<? extends String>> quiverBowBlacklist;
    public ForgeConfigSpec.BooleanValue addIronWeaponsToVillageWeaponsmith;
    public ForgeConfigSpec.BooleanValue addBowAndCrossbowLootToVillageFletcher;
    public ForgeConfigSpec.BooleanValue addDiamondWeaponsToEndCity;
    public ForgeConfigSpec.BooleanValue disableSpawningZombieWithWeapon;
    public ForgeConfigSpec.DoubleValue zombieWithMeleeSpawnChanceNormal;
    public ForgeConfigSpec.DoubleValue zombieWithMeleeSpawnChanceHard;
    public ForgeConfigSpec.BooleanValue disableNewHeadDrops;
    public ForgeConfigSpec.BooleanValue disableVillagerTrading;
    public ForgeConfigSpec.DoubleValue damageBonusChestMultiplier;
    public ForgeConfigSpec.DoubleValue damageBonusRidingMultiplier;
    public ForgeConfigSpec.DoubleValue damageBonusThrowMultiplier;
    public ForgeConfigSpec.DoubleValue damageBonusThrowJavelinMultiplier;
    public ForgeConfigSpec.DoubleValue damageBonusUnarmoredMultiplier;
    public ForgeConfigSpec.BooleanValue damageBonusCheckArmorValue;
    public ForgeConfigSpec.DoubleValue damageBonusMaxArmorValue;
    public ForgeConfigSpec.DoubleValue damageBonusUndeadMultiplier;
    public ForgeConfigSpec.DoubleValue damageBonusBackstabMultiplier;
    public ForgeConfigSpec.DoubleValue damageAbsorptionFactor;
    public ForgeConfigSpec.DoubleValue reach1Value;
    public ForgeConfigSpec.DoubleValue reach2Value;
    public ForgeConfigSpec.DoubleValue sweep2Percentage;
    public ForgeConfigSpec.DoubleValue sweep3Percentage;
    public ForgeConfigSpec.DoubleValue armorPiercePercentage;
    public ForgeConfigSpec.DoubleValue decapitateSkullDropPercentage;
    public ForgeConfigSpec.IntValue quickStrikeHurtResistTicks;
    public ForgeConfigSpec.BooleanValue forceShowDisabledItems;

    private Config(ForgeConfigSpec.Builder builder) {
        this.daggers = new WeaponCategory(builder, "dagger", "Daggers", 2.5f, 2.5f, 1.0f, "dagger");
        this.parryingDaggers = new WeaponCategory(builder, "parrying_dagger", "Parrying Daggers", 2.5f, 2.5f, 1.0f, "parrying_dagger");
        this.longswords = new WeaponCategory(builder, "longsword", "Longswords", 1.4f, 4.5f, 1.5f, "longsword");
        this.katanas = new WeaponCategory(builder, "katana", "Katanas", 2.0f, 3.5f, 0.5f, "katana");
        this.sabers = new WeaponCategory(builder, "saber", "Sabers", 1.6f, 3.5f, 0.5f, "saber");
        this.rapiers = new WeaponCategory(builder, "rapier", "Rapiers", 2.4f, 2.0f, 0.5f, "rapier");
        this.greatswords = new WeaponCategory(builder, "greatsword", "Greatswords", 1.4f, 4.0f, 1.5f, "greatsword");
        this.clubs = new WeaponCategory(builder, "club", "Clubs", 1.3f, 4.0f, 1.0f, "club");
        this.cestus = new WeaponCategory(builder, "cestus", "Cestusae", 3.5f, 2.0f, 0.5f, "cestus");
        this.battleHammers = new WeaponCategory(builder, "battle_hammer", "Battle Hammers", 0.8f, 5.0f, 2.0f, "battle_hammer");
        this.warhammers = new WeaponCategory(builder, "warhammer", "Warhammers", 1.1f, 4.0f, 1.5f, "warhammer");
        this.spears = new WeaponCategory(builder, "spear", "Spears", 1.4f, 5.5f, 0.5f, "spear");
        this.halberds = new WeaponCategory(builder, "halberd", "Halberds", 1.2f, 5.0f, 1.5f, "halberd");
        this.pikes = new WeaponCategory(builder, "pike", "Pikes", 1.4f, 4.0f, 1.0f, "pike");
        this.lances = new WeaponCategory(builder, "lance", "Lances", 1.0f, 4.0f, 1.0f, "lance");
        this.longbows = new RangedWeaponCategory(builder, "longbow", "Longbows", "longbow");
        this.heavyCrossbows = new RangedWeaponCategory(builder, "heavy_crossbow", "Heavy Crossbows", "heavy_crossbow");
        this.throwingKnives = new ThrowingWeaponCategory(builder, "throwing_knife", "Throwing Knives", 2.5f, 1.5f, 1.0f, 5, "throwing_knife");
        this.tomahawks = new ThrowingWeaponCategory(builder, "tomahawk", "Tomahawks", 0.9f, 2.0f, 1.5f, 8, "tomahawk");
        this.javelins = new ThrowingWeaponCategory(builder, "javelin", "Javelins", 1.2f, 1.5f, 1.0f, 10, "javelin");
        this.boomerangs = new ThrowingWeaponCategory(builder, "boomerang", "Boomerangs", 2.0f, 4.0f, 1.0f, 5, "boomerang");
        this.battleaxes = new WeaponCategory(builder, "battleaxe", "Battleaxes", 1.0f, 4.0f, 2.0f, "battleaxe");
        this.flangedMaces = new WeaponCategory(builder, "flanged_mace", "Flanged Maces", 1.2f, 3.0f, 1.5f, "flanged_mace");
        this.glaives = new WeaponCategory(builder, "glaive", "Glaives", 1.0f, 4.0f, 1.5f, "glaive");
        this.quarterstaves = new WeaponCategory(builder, "quarterstaff", "Quarterstaves", 1.4f, 3.0f, 1.5f, "quarterstaff");
        this.scythes = new WeaponCategory(builder, "scythes", "Scythes", 1.0f, 5.0f, 1.0f, "scythe");
        this.copper = new MaterialCategory(builder, "copper", 1.5f, 200, "copper");
        this.tin = new MaterialCategory(builder, "tin", 1.75f, 180, "tin");
        this.bronze = new MaterialCategory(builder, "bronze", 2.0f, 320, "bronze");
        this.steel = new MaterialCategory(builder, "steel", 2.5f, 480, "steel");
        this.silver = new MaterialCategory(builder, "silver", 1.5f, 48, "silver");
        this.invar = new MaterialCategory(builder, "invar", 2.2f, 440, "invar");
        this.platinum = new MaterialCategory(builder, "platinum", 3.5f, 1024, "platinum");
        this.electrum = new MaterialCategory(builder, "electrum", 2.0f, 180, "electrum");
        this.nickel = new MaterialCategory(builder, "nickel", 2.0f, 200, "nickel");
        this.lead = new MaterialCategory(builder, "lead", 2.0f, 240, "lead");
        builder.push("explosives");
        this.disableRecipesExplosives = builder.comment("Disables all recipes for explosive related items").translation("config.spartanweaponry.explosive.disable_recipe").worldRestart().define("disable_recipe", false);
        this.disableTerrainDamage = builder.comment("Disables terrain damage for explosives in this mod such as Dynamite and Explosive Arrows. Is overridden by the 'mobGriefing' gamerule.").translation("config.spartanweaponry.explosive.disable_terrain_damage").define("disable_terrain_damage", false);
        this.fuseTicksDynamite = builder.comment("Time (in ticks) it takes for Dynamite to explode").translation("config.spartanweaponry.explosive.fuse_ticks_dynamite").defineInRange("fuse_ticks_dynamite", 60, 20, 600);
        this.explosionStrengthDynamite = builder.comment("Explosion strength for Dynamite").translation("config.spartanweaponry.explosive.explosion_strength_dynamite").defineInRange("explosion_strength_dynamite", 2.0, (double)0.1f, 10.0);
        builder.pop();
        builder.push("projectiles");
        this.disableNewArrowRecipes = builder.comment("Disables Recipes for all new Arrows.").translation("config.spartanweaponry.projectile.disable_new_arrow_recipes").worldRestart().define("disable_new_arrow_recipes", false);
        this.disableDiamondAmmoRecipes = builder.comment("Disables Recipes for both Diamond Arrows and Diamond Bolts.").translation("config.spartanweaponry.projectile.disable_diamond_ammo_recipes").worldRestart().define("disable_diamond_ammo_recipes", false);
        this.disableQuiverRecipes = builder.comment("Disables all variants of the Arrow Quiver and the Bolt Quiver in this mod").translation("config.spartanweaponry.projectile.disable_quiver_recipes").worldRestart().define("disable_quiver_recipes", false);
        this.arrowWood = new ProjectileCategory(builder, "wood", "arrow", 0.2f, 1.5f);
        this.arrowIron = new ProjectileCategory(builder, "iron", "arrow", 3.0f, 0.75f);
        this.arrowDiamond = new ProjectileCategory(builder, "diamond", "arrow", 3.5f, 1.25f);
        this.bolt = new BoltCategory(builder, "", "bolt", 4.0f, 1.0f, 0.25f);
        this.boltDiamond = new BoltCategory(builder, "diamond", "bolt", 5.0f, 1.0f, 0.5f);
        builder.push("explosive");
        this.arrowExplosiveExplosionStrength = builder.comment("Base damage for explosive arrows").translation("config.spartanweaponry.arrow.explosion_strength").defineInRange("base_damage", 2.0, 0.1, 10.0);
        this.arrowExplosiveRangeMultiplier = builder.comment("Range muliplier for explosive arrows").translation("config.spartanweaponry.arrow.range_multiplier").defineInRange("range_multiplier", 1.0, 0.1, 100.0);
        builder.pop();
        this.quiverBowBlacklist = builder.comment("Bows in this blacklist will not get Arrows pulled out of the Arrow Quiver. Use the registry ID of the bow to add to this. e.g. \"minecraft:bow\"").translation("config.spartanweaponry.projectile.quiver_bow_blacklist").defineListAllowEmpty((List)ImmutableList.of((Object)"quiver_bow_blacklist"), () -> Arrays.asList(Defaults.QuiverArrowBlacklist), value -> true);
        builder.pop();
        builder.push("loot");
        this.addIronWeaponsToVillageWeaponsmith = builder.comment("Set to false to disable spawning Iron Weapons in Village Weaponsmith chests via loot table injection").translation("config.spartanweaponry.loot.add_iron_weapons_to_village_blacksmith").worldRestart().define("add_iron_weapons_to_village_blacksmith", true);
        this.addBowAndCrossbowLootToVillageFletcher = builder.comment("Set to false to disable spawning Longbow and Heavy Crossbow-related loot in Village Fletcher chests via loot table injection").translation("config.spartanweaponry.loot.add_bow_and_crossbow_loot_to_village_fletcher").worldRestart().define("add_bow_and_crossbow_loot_to_village_fletcher", true);
        this.addDiamondWeaponsToEndCity = builder.comment("Set to false to disable spawning Diamond Weapons in End City chests via loot table injection").translation("config.spartanweaponry.loot.add_diamond_weapons_to_end_city").worldRestart().define("add_diamond_weapons_to_end_city", true);
        this.zombieWithMeleeSpawnChanceNormal = builder.comment("Chance for Zombies to spawn with Iron Melee Weapons on all difficulties apart from Hard and Hardcore").translation("config.spartanweaponry.loot.zombie_with_melee_spawn_chance_normal").defineInRange("zombie_with_melee_spawn_chance_normal", (double)0.05f, 0.0, 1.0);
        this.zombieWithMeleeSpawnChanceHard = builder.comment("Chance for Zombies to spawn with Iron Melee Weapons on Hard or Hardcore difficulty").translation("config.spartanweaponry.loot.zombie_with_melee_spawn_chance_hard").defineInRange("zombie_with_melee_spawn_chance_hard", 0.25, 0.0, 1.0);
        this.disableSpawningZombieWithWeapon = builder.comment("Set to true to disable spawning a Zombie with any weapons from this mod").translation("config.spartanweaponry.loot.disable_spawning_zombie_with_weapon").define("disable_spawning_zombie_with_weapon", false);
        this.disableNewHeadDrops = builder.comment("Set to true to disable the new mob heads from being dropped from mobs using the Decapitate Weapon Trait from this mod.").translation("config.spartanweaponry.loot.disable_new_head_drops").define("disable_new_head_drops", false);
        builder.pop();
        builder.push("trading");
        this.disableVillagerTrading = builder.comment("Set to true to disable Villagers (Weaponsmiths and Fletchers) from trading weapons from this mod").translation("config.spartanweaponry.trading.disabled").define("disable", false);
        builder.pop();
        builder.push("traits");
        builder.push("damage_bonus");
        this.damageBonusChestMultiplier = builder.comment("Changes the \"Chest Damage Bonus\" Weapon Trait multiplier value").translation("config.spartanweaponry.traits.damage_bonus.chest_multiplier").defineInRange("chest_multiplier", 2.0, 1.0, 50.0);
        this.damageBonusRidingMultiplier = builder.comment("Changes the \"Riding Damage Bonus\" Weapon Trait multiplier value").translation("config.spartanweaponry.traits.damage_bonus.riding_multiplier").defineInRange("riding_multiplier", 2.0, 1.0, 50.0);
        this.damageBonusThrowMultiplier = builder.comment("Changes the \"Throwing Damage Bonus\" Weapon Trait multiplier value").translation("config.spartanweaponry.traits.damage_bonus.throw_multiplier").defineInRange("throw_multiplier", 2.0, 1.0, 50.0);
        this.damageBonusThrowJavelinMultiplier = builder.comment("Changes the \"Chest Damage Bonus\" Weapon Trait multiplier value").translation("config.spartanweaponry.traits.damage_bonus.throw_javelin_multiplier").defineInRange("throw_javelin_multiplier", 3.0, 1.0, 50.0);
        this.damageBonusUnarmoredMultiplier = builder.comment("Changes the \"Unarmored Damage Bonus\" Weapon Trait multiplier value").translation("config.spartanweaponry.traits.damage_bonus.unarmored_multiplier").defineInRange("unarmored_multiplier", 3.0, 1.0, 50.0);
        this.damageBonusCheckArmorValue = builder.comment("If set to true, any damage bonus that checks for armor will only apply if the hit mob has less than the total armor value threshold, while still checking for armor").translation("config.spartanweaponry.traits.damage_bonus.check_armor_value").define("check_armor_value", false);
        this.damageBonusMaxArmorValue = builder.comment("Max armor value allowed for any damage bonus that checks for armor to apply, without any armor equipped").translation("config.spartanweaponry.traits.damage_bonus.max_armor_value").defineInRange("max_armor_value", 0.0, 1.0, 50.0);
        this.damageBonusUndeadMultiplier = builder.comment("Changes the \"Undead Damage Bonus\" Weapon Trait multiplier value").translation("config.spartanweaponry.traits.damage_bonus.undead_multiplier").defineInRange("undead_multiplier", 1.5, 1.0, 50.0);
        this.damageBonusBackstabMultiplier = builder.comment("Changes the \"Backstab Damage Bonus\" Weapon Trait multiplier value").translation("config.spartanweaponry.traits.damage_bonus.backstab_multiplier").defineInRange("backstab_multiplier", 3.0, 1.0, 50.0);
        builder.pop();
        builder.push("damage_absorption");
        this.damageAbsorptionFactor = builder.comment("Changes the percentage of damage absorbed by the \"Damage Absorption\" Weapon Trait").translation("config.spartanweaponry.traits.damage_absorption_factor").defineInRange("damage_absorption_factor", 0.25, 0.0, 1.0);
        builder.pop();
        builder.push("reach");
        this.reach1Value = builder.comment("Changes the reach of any weapons with the \"Reach I\" Weapon Trait").translation("config.spartanweaponry.traits.reach1.value").defineInRange("reach1_value", 6.0, 5.0, 15.0);
        this.reach2Value = builder.comment("Changes the reach of any weapons with the \"Reach II\" Weapon Trait").translation("config.spartanweaponry.traits.reach2.value").defineInRange("reach2_value", 7.0, 5.0, 15.0);
        builder.pop();
        builder.push("sweep");
        this.sweep2Percentage = builder.comment("Changes the percentage of damage inflicted to enemies when sweep attacked on weapons with the \"Sweep II\" Weapon Trait").translation("config.spartanweaponry.traits.sweep2.percentage").defineInRange("sweep2_percentage", 50.0, 0.0, 100.0);
        this.sweep3Percentage = builder.comment("Changes the percentage of damage inflicted to enemies when sweep attacked on weapons with the \"Sweep III\" Weapon Trait").translation("config.spartanweaponry.traits.sweep3.percentage").defineInRange("sweep3_percentage", 100.0, 0.0, 100.0);
        builder.pop();
        builder.push("armor_pierce");
        this.armorPiercePercentage = builder.comment("Changes the percentage of damage that ignores armor on weapons with the \"Armor Piercing\" Weapon Trait").translation("config.spartanweaponry.traits.armor_pierce.percentage").defineInRange("percentage", 50.0, 0.0, 100.0);
        builder.pop();
        builder.push("quick_strike");
        this.quickStrikeHurtResistTicks = builder.comment("Tweaks the hurt resistance ticks for weapons that use the \"Quick Strike\" Weapon Trait").translation("config.spartanweaponry.traits.quick_strike.hurt_resistance_ticks").defineInRange("hurt_resistance_ticks", 14, 10, 20);
        builder.pop();
        builder.push("decapitate");
        this.decapitateSkullDropPercentage = builder.comment("Tweaks the percentage of Skull drops from weapons with the \"Decapitate\" Weapon Trait").translation("config.spartanweaponry.traits.decapitate.skull_drop_percentage").defineInRange("skull_drop_percentage", 25.0, 0.0, 100.0);
        builder.pop();
        builder.pop();
        builder.push("jei");
        this.forceShowDisabledItems = builder.comment("Set to true to forcibly show disabled items in JEI, even if they cannot be crafted. Should be useful for modpack makers defining their own recipes.").translation("config.spartanweaponry.jei.force_show_disabled_items").worldRestart().define("force_show_disabled_items", false);
        builder.pop();
    }

    @SubscribeEvent
    public static void onConfigLoad(ModConfig.ModConfigEvent ev) {
        TypeDisabledCondition.disabledRecipeTypes.clear();
        Config.updateMaterialValues(WeaponMaterial.COPPER, ((Double)Config.INSTANCE.copper.damage.get()).floatValue(), (Integer)Config.INSTANCE.copper.durability.get());
        Config.INSTANCE.copper.updateDisabledRecipeList();
        Config.updateMaterialValues(WeaponMaterial.TIN, ((Double)Config.INSTANCE.tin.damage.get()).floatValue(), (Integer)Config.INSTANCE.tin.durability.get());
        Config.INSTANCE.tin.updateDisabledRecipeList();
        Config.updateMaterialValues(WeaponMaterial.BRONZE, ((Double)Config.INSTANCE.bronze.damage.get()).floatValue(), (Integer)Config.INSTANCE.bronze.durability.get());
        Config.INSTANCE.bronze.updateDisabledRecipeList();
        Config.updateMaterialValues(WeaponMaterial.STEEL, ((Double)Config.INSTANCE.steel.damage.get()).floatValue(), (Integer)Config.INSTANCE.steel.durability.get());
        Config.INSTANCE.steel.updateDisabledRecipeList();
        Config.updateMaterialValues(WeaponMaterial.SILVER, ((Double)Config.INSTANCE.silver.damage.get()).floatValue(), (Integer)Config.INSTANCE.silver.durability.get());
        Config.INSTANCE.silver.updateDisabledRecipeList();
        Config.updateMaterialValues(WeaponMaterial.INVAR, ((Double)Config.INSTANCE.invar.damage.get()).floatValue(), (Integer)Config.INSTANCE.invar.durability.get());
        Config.INSTANCE.invar.updateDisabledRecipeList();
        Config.updateMaterialValues(WeaponMaterial.PLATINUM, ((Double)Config.INSTANCE.platinum.damage.get()).floatValue(), (Integer)Config.INSTANCE.platinum.durability.get());
        Config.INSTANCE.platinum.updateDisabledRecipeList();
        Config.updateMaterialValues(WeaponMaterial.ELECTRUM, ((Double)Config.INSTANCE.electrum.damage.get()).floatValue(), (Integer)Config.INSTANCE.electrum.durability.get());
        Config.INSTANCE.electrum.updateDisabledRecipeList();
        Config.updateMaterialValues(WeaponMaterial.NICKEL, ((Double)Config.INSTANCE.nickel.damage.get()).floatValue(), (Integer)Config.INSTANCE.nickel.durability.get());
        Config.INSTANCE.nickel.updateDisabledRecipeList();
        Config.updateMaterialValues(WeaponMaterial.LEAD, ((Double)Config.INSTANCE.lead.damage.get()).floatValue(), (Integer)Config.INSTANCE.lead.durability.get());
        Config.INSTANCE.lead.updateDisabledRecipeList();
        ModItems.daggers.updateSettingsFromConfig(((Double)Config.INSTANCE.daggers.baseDamage.get()).floatValue(), ((Double)Config.INSTANCE.daggers.damageMultipler.get()).floatValue(), (Double)Config.INSTANCE.daggers.speed.get());
        Config.INSTANCE.daggers.updateDisabledRecipeList();
        ModItems.parryingDaggers.updateSettingsFromConfig(((Double)Config.INSTANCE.parryingDaggers.baseDamage.get()).floatValue(), ((Double)Config.INSTANCE.parryingDaggers.damageMultipler.get()).floatValue(), (Double)Config.INSTANCE.parryingDaggers.speed.get());
        Config.INSTANCE.parryingDaggers.updateDisabledRecipeList();
        ModItems.longswords.updateSettingsFromConfig(((Double)Config.INSTANCE.longswords.baseDamage.get()).floatValue(), ((Double)Config.INSTANCE.longswords.damageMultipler.get()).floatValue(), (Double)Config.INSTANCE.longswords.speed.get());
        Config.INSTANCE.longswords.updateDisabledRecipeList();
        ModItems.katanas.updateSettingsFromConfig(((Double)Config.INSTANCE.katanas.baseDamage.get()).floatValue(), ((Double)Config.INSTANCE.katanas.damageMultipler.get()).floatValue(), (Double)Config.INSTANCE.katanas.speed.get());
        Config.INSTANCE.katanas.updateDisabledRecipeList();
        ModItems.sabers.updateSettingsFromConfig(((Double)Config.INSTANCE.sabers.baseDamage.get()).floatValue(), ((Double)Config.INSTANCE.sabers.damageMultipler.get()).floatValue(), (Double)Config.INSTANCE.sabers.speed.get());
        Config.INSTANCE.sabers.updateDisabledRecipeList();
        ModItems.rapiers.updateSettingsFromConfig(((Double)Config.INSTANCE.rapiers.baseDamage.get()).floatValue(), ((Double)Config.INSTANCE.rapiers.damageMultipler.get()).floatValue(), (Double)Config.INSTANCE.rapiers.speed.get());
        Config.INSTANCE.rapiers.updateDisabledRecipeList();
        ModItems.greatswords.updateSettingsFromConfig(((Double)Config.INSTANCE.greatswords.baseDamage.get()).floatValue(), ((Double)Config.INSTANCE.greatswords.damageMultipler.get()).floatValue(), (Double)Config.INSTANCE.greatswords.speed.get());
        Config.INSTANCE.greatswords.updateDisabledRecipeList();
        Config.INSTANCE.clubs.updateDisabledRecipeList();
        Config.INSTANCE.cestus.updateDisabledRecipeList();
        ModItems.battleHammers.updateSettingsFromConfig(((Double)Config.INSTANCE.battleHammers.baseDamage.get()).floatValue(), ((Double)Config.INSTANCE.battleHammers.damageMultipler.get()).floatValue(), (Double)Config.INSTANCE.battleHammers.speed.get());
        Config.INSTANCE.battleHammers.updateDisabledRecipeList();
        ModItems.warhammers.updateSettingsFromConfig(((Double)Config.INSTANCE.warhammers.baseDamage.get()).floatValue(), ((Double)Config.INSTANCE.warhammers.damageMultipler.get()).floatValue(), (Double)Config.INSTANCE.warhammers.speed.get());
        Config.INSTANCE.warhammers.updateDisabledRecipeList();
        ModItems.spears.updateSettingsFromConfig(((Double)Config.INSTANCE.spears.baseDamage.get()).floatValue(), ((Double)Config.INSTANCE.spears.damageMultipler.get()).floatValue(), (Double)Config.INSTANCE.spears.speed.get());
        Config.INSTANCE.spears.updateDisabledRecipeList();
        ModItems.halberds.updateSettingsFromConfig(((Double)Config.INSTANCE.halberds.baseDamage.get()).floatValue(), ((Double)Config.INSTANCE.halberds.damageMultipler.get()).floatValue(), (Double)Config.INSTANCE.halberds.speed.get());
        Config.INSTANCE.halberds.updateDisabledRecipeList();
        ModItems.pikes.updateSettingsFromConfig(((Double)Config.INSTANCE.pikes.baseDamage.get()).floatValue(), ((Double)Config.INSTANCE.pikes.damageMultipler.get()).floatValue(), (Double)Config.INSTANCE.pikes.speed.get());
        Config.INSTANCE.pikes.updateDisabledRecipeList();
        ModItems.lances.updateSettingsFromConfig(((Double)Config.INSTANCE.lances.baseDamage.get()).floatValue(), ((Double)Config.INSTANCE.lances.damageMultipler.get()).floatValue(), (Double)Config.INSTANCE.lances.speed.get());
        Config.INSTANCE.lances.updateDisabledRecipeList();
        Config.INSTANCE.longbows.updateDisabledRecipeList();
        Config.INSTANCE.heavyCrossbows.updateDisabledRecipeList();
        ModItems.throwingKnives.updateSettingsFromConfig(((Double)Config.INSTANCE.throwingKnives.baseDamage.get()).floatValue(), ((Double)Config.INSTANCE.throwingKnives.damageMultipler.get()).floatValue(), (Double)Config.INSTANCE.throwingKnives.speed.get(), (Integer)Config.INSTANCE.throwingKnives.chargeTicks.get());
        Config.INSTANCE.throwingKnives.updateDisabledRecipeList();
        ModItems.tomahawks.updateSettingsFromConfig(((Double)Config.INSTANCE.tomahawks.baseDamage.get()).floatValue(), ((Double)Config.INSTANCE.tomahawks.damageMultipler.get()).floatValue(), (Double)Config.INSTANCE.tomahawks.speed.get(), (Integer)Config.INSTANCE.tomahawks.chargeTicks.get());
        Config.INSTANCE.tomahawks.updateDisabledRecipeList();
        ModItems.javelins.updateSettingsFromConfig(((Double)Config.INSTANCE.javelins.baseDamage.get()).floatValue(), ((Double)Config.INSTANCE.javelins.damageMultipler.get()).floatValue(), (Double)Config.INSTANCE.javelins.speed.get(), (Integer)Config.INSTANCE.javelins.chargeTicks.get());
        Config.INSTANCE.javelins.updateDisabledRecipeList();
        ModItems.boomerangs.updateSettingsFromConfig(((Double)Config.INSTANCE.boomerangs.baseDamage.get()).floatValue(), ((Double)Config.INSTANCE.boomerangs.damageMultipler.get()).floatValue(), (Double)Config.INSTANCE.boomerangs.speed.get(), (Integer)Config.INSTANCE.boomerangs.chargeTicks.get());
        Config.INSTANCE.boomerangs.updateDisabledRecipeList();
        ModItems.battleaxes.updateSettingsFromConfig(((Double)Config.INSTANCE.battleaxes.baseDamage.get()).floatValue(), ((Double)Config.INSTANCE.battleaxes.damageMultipler.get()).floatValue(), (Double)Config.INSTANCE.battleaxes.speed.get());
        Config.INSTANCE.battleaxes.updateDisabledRecipeList();
        ModItems.flangedMaces.updateSettingsFromConfig(((Double)Config.INSTANCE.flangedMaces.baseDamage.get()).floatValue(), ((Double)Config.INSTANCE.flangedMaces.damageMultipler.get()).floatValue(), (Double)Config.INSTANCE.flangedMaces.speed.get());
        Config.INSTANCE.flangedMaces.updateDisabledRecipeList();
        ModItems.glaives.updateSettingsFromConfig(((Double)Config.INSTANCE.glaives.baseDamage.get()).floatValue(), ((Double)Config.INSTANCE.glaives.damageMultipler.get()).floatValue(), (Double)Config.INSTANCE.glaives.speed.get());
        Config.INSTANCE.glaives.updateDisabledRecipeList();
        ModItems.quarterstaves.updateSettingsFromConfig(((Double)Config.INSTANCE.quarterstaves.baseDamage.get()).floatValue(), ((Double)Config.INSTANCE.quarterstaves.damageMultipler.get()).floatValue(), (Double)Config.INSTANCE.quarterstaves.speed.get());
        Config.INSTANCE.quarterstaves.updateDisabledRecipeList();
        ModItems.scythes.updateSettingsFromConfig(((Double)Config.INSTANCE.scythes.baseDamage.get()).floatValue(), ((Double)Config.INSTANCE.scythes.damageMultipler.get()).floatValue(), (Double)Config.INSTANCE.scythes.speed.get());
        Config.INSTANCE.scythes.updateDisabledRecipeList();
        Config.updateDisabledRecipe("arrows", (Boolean)Config.INSTANCE.disableNewArrowRecipes.get());
        Config.updateDisabledRecipe("diamond_ammo", (Boolean)Config.INSTANCE.disableDiamondAmmoRecipes.get());
        Config.updateDisabledRecipe("quiver", (Boolean)Config.INSTANCE.disableQuiverRecipes.get());
        Config.updateDisabledRecipe("bolts", (Boolean)Config.INSTANCE.heavyCrossbows.disableRecipes.get());
        ModItems.arrowWood.updateFromConfig(((Double)Config.INSTANCE.arrowWood.baseDamage.get()).floatValue(), ((Double)Config.INSTANCE.arrowWood.rangeMultiplier.get()).floatValue());
        ModItems.tippedArrowWood.updateFromConfig(((Double)Config.INSTANCE.arrowWood.baseDamage.get()).floatValue(), ((Double)Config.INSTANCE.arrowWood.rangeMultiplier.get()).floatValue());
        ModItems.arrowIron.updateFromConfig(((Double)Config.INSTANCE.arrowIron.baseDamage.get()).floatValue(), ((Double)Config.INSTANCE.arrowIron.rangeMultiplier.get()).floatValue());
        ModItems.tippedArrowIron.updateFromConfig(((Double)Config.INSTANCE.arrowIron.baseDamage.get()).floatValue(), ((Double)Config.INSTANCE.arrowIron.rangeMultiplier.get()).floatValue());
        ModItems.arrowDiamond.updateFromConfig(((Double)Config.INSTANCE.arrowDiamond.baseDamage.get()).floatValue(), ((Double)Config.INSTANCE.arrowDiamond.rangeMultiplier.get()).floatValue());
        ModItems.tippedArrowDiamond.updateFromConfig(((Double)Config.INSTANCE.arrowDiamond.baseDamage.get()).floatValue(), ((Double)Config.INSTANCE.arrowDiamond.rangeMultiplier.get()).floatValue());
        ModItems.bolt.updateFromConfig(((Double)Config.INSTANCE.bolt.baseDamage.get()).floatValue(), ((Double)Config.INSTANCE.bolt.rangeMultiplier.get()).floatValue(), ((Double)Config.INSTANCE.bolt.armorPiercingFactor.get()).floatValue());
        ModItems.tippedBolt.updateFromConfig(((Double)Config.INSTANCE.bolt.baseDamage.get()).floatValue(), ((Double)Config.INSTANCE.bolt.rangeMultiplier.get()).floatValue(), ((Double)Config.INSTANCE.bolt.armorPiercingFactor.get()).floatValue());
        ModItems.spectralBolt.updateFromConfig(((Double)Config.INSTANCE.bolt.baseDamage.get()).floatValue(), ((Double)Config.INSTANCE.bolt.rangeMultiplier.get()).floatValue(), ((Double)Config.INSTANCE.bolt.armorPiercingFactor.get()).floatValue());
        ModItems.boltDiamond.updateFromConfig(((Double)Config.INSTANCE.boltDiamond.baseDamage.get()).floatValue(), ((Double)Config.INSTANCE.boltDiamond.rangeMultiplier.get()).floatValue(), ((Double)Config.INSTANCE.boltDiamond.armorPiercingFactor.get()).floatValue());
        ModItems.tippedBoltDiamond.updateFromConfig(((Double)Config.INSTANCE.boltDiamond.baseDamage.get()).floatValue(), ((Double)Config.INSTANCE.boltDiamond.rangeMultiplier.get()).floatValue(), ((Double)Config.INSTANCE.boltDiamond.armorPiercingFactor.get()).floatValue());
        Config.updateDisabledRecipe("explosives", (Boolean)Config.INSTANCE.disableRecipesExplosives.get());
        WeaponTraits.EXTRA_DAMAGE_2_CHEST.setMagnitude(((Double)Config.INSTANCE.damageBonusChestMultiplier.get()).floatValue());
        WeaponTraits.EXTRA_DAMAGE_2_RIDING.setMagnitude(((Double)Config.INSTANCE.damageBonusRidingMultiplier.get()).floatValue());
        WeaponTraits.EXTRA_DAMAGE_2_THROWN.setMagnitude(((Double)Config.INSTANCE.damageBonusThrowMultiplier.get()).floatValue());
        WeaponTraits.EXTRA_DAMAGE_3_THROWN.setMagnitude(((Double)Config.INSTANCE.damageBonusThrowJavelinMultiplier.get()).floatValue());
        WeaponTraits.EXTRA_DAMAGE_3_NO_ARMOUR.setMagnitude(((Double)Config.INSTANCE.damageBonusUnarmoredMultiplier.get()).floatValue());
        WeaponTraits.EXTRA_DAMAGE_50P_UNDEAD.setMagnitude(((Double)Config.INSTANCE.damageBonusUndeadMultiplier.get()).floatValue());
        WeaponTraits.EXTRA_DAMAGE_BACKSTAB.setMagnitude(((Double)Config.INSTANCE.damageBonusBackstabMultiplier.get()).floatValue());
        WeaponTraits.DAMAGE_ABSORB_25.setMagnitude(((Double)Config.INSTANCE.damageAbsorptionFactor.get()).floatValue());
        WeaponTraits.REACH_1.setMagnitude(((Double)Config.INSTANCE.reach1Value.get()).floatValue());
        WeaponTraits.REACH_2.setMagnitude(((Double)Config.INSTANCE.reach2Value.get()).floatValue());
        WeaponTraits.SWEEP_DAMAGE_HALF.setMagnitude(((Double)Config.INSTANCE.sweep2Percentage.get()).floatValue());
        WeaponTraits.SWEEP_DAMAGE_FULL.setMagnitude(((Double)Config.INSTANCE.sweep3Percentage.get()).floatValue());
        WeaponTraits.ARMOUR_PIERCING_50.setMagnitude(((Double)Config.INSTANCE.armorPiercePercentage.get()).floatValue());
        WeaponTraits.DECAPITATE.setMagnitude(((Double)Config.INSTANCE.decapitateSkullDropPercentage.get()).floatValue());
        APIConfigValues.damageBonusCheckArmorValue = (Boolean)Config.INSTANCE.damageBonusCheckArmorValue.get();
        APIConfigValues.damageBonusMaxArmorValue = ((Double)Config.INSTANCE.damageBonusMaxArmorValue.get()).floatValue();
        WeaponsmithTrades.initTradeLists();
    }

    public static void updateDisabledRecipe(String type, boolean disabled) {
        boolean containsValue = TypeDisabledCondition.disabledRecipeTypes.contains(type);
        if (!containsValue && disabled) {
            TypeDisabledCondition.disabledRecipeTypes.add(type);
        } else if (containsValue) {
            TypeDisabledCondition.disabledRecipeTypes.remove(type);
        }
    }

    private static void updateMaterialValues(WeaponMaterial material, float baseDamage, int durability) {
        material.setAttackDamage(baseDamage);
        material.setMaxUses(durability);
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Config::new);
        INSTANCE = (Config)specPair.getLeft();
        CONFIG_SPEC = (ForgeConfigSpec)specPair.getRight();
    }

    public class BoltCategory {
        public ForgeConfigSpec.DoubleValue baseDamage;
        public ForgeConfigSpec.DoubleValue rangeMultiplier;
        public ForgeConfigSpec.DoubleValue armorPiercingFactor;

        protected BoltCategory(ForgeConfigSpec.Builder builder, String materialName, String projectileName, float baseDamage, float rangeMultiplier, float armorPiercingFactor) {
            String projName = materialName == null || materialName == "" ? projectileName : materialName + " " + projectileName;
            String category = materialName == null || materialName == "" ? projectileName : materialName + "_" + projectileName;
            builder.push(category);
            this.baseDamage = builder.comment("Base damage for " + projName + "s").translation("config.spartanweaponry.arrow.base_damage").defineInRange("base_damage", (double)baseDamage, 0.1, 100.0);
            this.rangeMultiplier = builder.comment("Range muliplier for " + projName + "s").translation("config.spartanweaponry.arrow.range_multiplier").defineInRange("range_multiplier", (double)rangeMultiplier, 0.1, 100.0);
            this.armorPiercingFactor = builder.comment("Armor Piercing factor for " + projName + "s").translation("config.spartanweaponry.bolt.armor_piercing_factor").defineInRange("armor_piercing_factor", (double)armorPiercingFactor, 0.0, 1.0);
            builder.pop();
        }
    }

    public class ProjectileCategory {
        public ForgeConfigSpec.DoubleValue baseDamage;
        public ForgeConfigSpec.DoubleValue rangeMultiplier;

        private ProjectileCategory(ForgeConfigSpec.Builder builder, String materialName, String projectileName, float baseDamage, float rangeMultiplier) {
            String projName = materialName == null || materialName == "" ? projectileName : materialName + " " + projectileName;
            String category = materialName == null || materialName == "" ? projectileName : materialName + "_" + projectileName;
            builder.push(category);
            this.baseDamage = builder.comment("Base damage for " + projName + "s").translation("config.spartanweaponry.arrow.base_damage").defineInRange("base_damage", (double)baseDamage, 0.1, 100.0);
            this.rangeMultiplier = builder.comment("Range muliplier for " + projName + "s").translation("config.spartanweaponry.arrow.range_multiplier").defineInRange("range_multiplier", (double)rangeMultiplier, 0.1, 100.0);
            builder.pop();
        }
    }

    public class MaterialCategory {
        public ForgeConfigSpec.DoubleValue damage;
        public ForgeConfigSpec.IntValue durability;
        public ForgeConfigSpec.BooleanValue disableRecipes;
        private String materialName;
        private String typeDisabledName;

        private MaterialCategory(ForgeConfigSpec.Builder builder, String materialName, float damage, int durability, String typeDisabledName) {
            builder.push(materialName);
            this.materialName = materialName;
            this.typeDisabledName = typeDisabledName;
            this.damage = builder.comment("Base Damage for " + this.materialName + " weapons").translation("config.spartanweaponry.material.base_damage").defineInRange("base_damage", (double)damage, 0.1, 100.0);
            this.durability = builder.comment("Durability for " + this.materialName + " weapons").translation("config.spartanweaponry.material.durability").defineInRange("durability", durability, 1, 100000);
            this.disableRecipes = builder.comment("Set to true to disable " + this.materialName + " weapons").translation("config.spartanweaponry.material.disable").worldRestart().define("disable", false);
            builder.pop();
        }

        public void updateDisabledRecipeList() {
            Config.updateDisabledRecipe(this.typeDisabledName, (Boolean)this.disableRecipes.get());
        }
    }

    public class ThrowingWeaponCategory {
        public ForgeConfigSpec.BooleanValue disableRecipes;
        public ForgeConfigSpec.DoubleValue speed;
        public ForgeConfigSpec.DoubleValue baseDamage;
        public ForgeConfigSpec.DoubleValue damageMultipler;
        public ForgeConfigSpec.IntValue chargeTicks;
        private String typeDisabledName;

        protected ThrowingWeaponCategory(ForgeConfigSpec.Builder builder, String weaponClass, String weaponPlural, float defaultSpeed, float defaultBaseDamage, float defaultDamageMuliplier, int defaultChargeTicks, String typeDisabledNameIn) {
            builder.push(weaponClass);
            this.typeDisabledName = typeDisabledNameIn;
            this.disableRecipes = builder.comment("Disables all recipes for all " + weaponPlural + ".").translation("config.spartanweaponry.weapon.disable").worldRestart().define("disable", false);
            this.speed = builder.comment("Attack speed of " + weaponPlural + ".").translation("config.spartanweaponry.weapon.speed").defineInRange("speed", (double)defaultSpeed, 0.0, 4.0);
            this.baseDamage = builder.comment("Base Damage of " + weaponPlural + ".").translation("config.spartanweaponry.weapon.base_damage").defineInRange("base_damage", (double)defaultBaseDamage, 0.1, 100.0);
            this.damageMultipler = builder.comment("Damage Multiplier for " + weaponPlural + ".").translation("config.spartanweaponry.weapon.damage_multiplier").defineInRange("damage_multiplier", (double)defaultDamageMuliplier, 0.1, 10.0);
            this.chargeTicks = builder.comment("Charge time in ticks for " + weaponPlural + ".").translation("config.spartanweaponry.weapon.charge_ticks").defineInRange("charge_ticks", defaultChargeTicks, 1, 1000);
            builder.pop();
        }

        public void updateDisabledRecipeList() {
            Config.updateDisabledRecipe(this.typeDisabledName, (Boolean)this.disableRecipes.get());
        }
    }

    public class RangedWeaponCategory {
        public ForgeConfigSpec.BooleanValue disableRecipes;
        private String typeDisabledName;

        protected RangedWeaponCategory(ForgeConfigSpec.Builder builder, String weaponClass, String weaponPlural, String typeDisabledNameIn) {
            builder.push(weaponClass);
            this.typeDisabledName = typeDisabledNameIn;
            this.disableRecipes = builder.comment("Disables all recipes for all " + weaponPlural + ".").translation("config.spartanweaponry.weapon.disable").worldRestart().define("disable", false);
            builder.pop();
        }

        public void updateDisabledRecipeList() {
            Config.updateDisabledRecipe(this.typeDisabledName, (Boolean)this.disableRecipes.get());
        }
    }

    public class WeaponCategory {
        public ForgeConfigSpec.BooleanValue disableRecipes;
        public ForgeConfigSpec.DoubleValue speed;
        public ForgeConfigSpec.DoubleValue baseDamage;
        public ForgeConfigSpec.DoubleValue damageMultipler;
        private String typeDisabledName;

        protected WeaponCategory(ForgeConfigSpec.Builder builder, String weaponClass, String weaponPlural, float defaultSpeed, float defaultBaseDamage, float defaultDamageMuliplier, String typeDisabledNameIn) {
            builder.push(weaponClass);
            this.typeDisabledName = typeDisabledNameIn;
            this.disableRecipes = builder.comment("Disables all recipes for all " + weaponPlural + ".").translation("config.spartanweaponry.weapon.disable").worldRestart().define("disable", false);
            this.speed = builder.comment("Attack speed of " + weaponPlural + ".").translation("config.spartanweaponry.weapon.speed").defineInRange("speed", (double)defaultSpeed, 0.0, 4.0);
            this.baseDamage = builder.comment("Base Damage of " + weaponPlural + ".").translation("config.spartanweaponry.weapon.base_damage").defineInRange("base_damage", (double)defaultBaseDamage, 0.1, 100.0);
            this.damageMultipler = builder.comment("Damage Multiplier for " + weaponPlural + ".").translation("config.spartanweaponry.weapon.damage_multiplier").defineInRange("damage_multiplier", (double)defaultDamageMuliplier, 0.1, 10.0);
            builder.pop();
        }

        public void updateDisabledRecipeList() {
            Config.updateDisabledRecipe(this.typeDisabledName, (Boolean)this.disableRecipes.get());
        }
    }
}

