/*
 * Decompiled with CFR 0.152.
 */
package com.oblivioussp.spartanweaponry.mixin;

import com.oblivioussp.spartanweaponry.item.QuiverBaseItem;
import com.oblivioussp.spartanweaponry.mixin.ProjectileEntityMixin;
import com.oblivioussp.spartanweaponry.util.Log;
import com.oblivioussp.spartanweaponry.util.QuiverHelper;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={AbstractArrowEntity.class})
public abstract class AbstractArrowEntityMixin
extends ProjectileEntityMixin {
    @Shadow
    protected boolean field_70254_i;
    @Shadow
    public int field_70249_b;
    @Shadow
    public AbstractArrowEntity.PickupStatus field_70251_a;

    @Inject(at={@At(value="HEAD")}, method={"onCollideWithPlayer(Lnet/minecraft/entity/player/PlayerEntity;)V"}, cancellable=true)
    private void onCollideWithPlayer(PlayerEntity entityIn, CallbackInfo callback) {
        if (!this.field_70170_p.field_72995_K && (this.field_70254_i || this.func_203047_q()) && this.field_70249_b <= 0) {
            Log.debug("Player collision with arrow entity intercepted!");
            if (this.field_70251_a == AbstractArrowEntity.PickupStatus.ALLOWED) {
                List<ItemStack> quivers = QuiverHelper.findValidQuivers(entityIn);
                ItemStack arrowStack = this.func_184550_j();
                ItemStack mainHand = entityIn.func_184614_ca();
                ItemStack offHand = entityIn.func_184592_cb();
                if (offHand.func_77973_b() == arrowStack.func_77973_b() && offHand.func_190916_E() < offHand.func_77976_d() || mainHand.func_77973_b() == arrowStack.func_77973_b() && mainHand.func_190916_E() < mainHand.func_77976_d()) {
                    return;
                }
                if (!quivers.isEmpty()) {
                    for (ItemStack quiver : quivers) {
                        if (!arrowStack.func_190926_b() && !quiver.func_190926_b() && ((QuiverBaseItem)quiver.func_77973_b()).isAmmoValid(arrowStack, quiver) && quiver.func_196082_o().func_74767_n("ammoCollect")) {
                            IItemHandler quiverHandler = (IItemHandler)quiver.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null).orElseThrow(QuiverBaseItem.CAPABILITY_EXCEPTION);
                            for (int i = 0; i < quiverHandler.getSlots(); ++i) {
                                arrowStack = quiverHandler.insertItem(i, arrowStack, false);
                            }
                        }
                        if (!arrowStack.func_190926_b()) continue;
                        Log.debug("Picked up arrow on the ground and placed it in the quiver!");
                        Entity thisEntity = this.field_70170_p.func_73045_a(this.func_145782_y());
                        entityIn.func_71001_a(thisEntity, 1);
                        this.func_70106_y();
                        this.field_70170_p.func_184148_a((PlayerEntity)null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_187638_cR, SoundCategory.PLAYERS, 0.2f, (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.7f + 0.0f);
                        callback.cancel();
                        break;
                    }
                }
            }
        }
    }

    @Shadow
    public boolean func_203047_q() {
        throw new IllegalStateException("Mixin failed to shadow the \"AbstractArrowEntity.getNoClip()\" method!");
    }

    @Shadow
    public ItemStack func_184550_j() {
        throw new IllegalStateException("Mixin failed to shadow the \"AbstractArrowEntity.getArrowStack()\" method!");
    }
}

