/*
 * Decompiled with CFR 0.152.
 */
package com.oblivioussp.spartanweaponry.item;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.oblivioussp.spartanweaponry.api.IWeaponTraitContainer;
import com.oblivioussp.spartanweaponry.api.WeaponMaterial;
import com.oblivioussp.spartanweaponry.api.trait.IMeleeTraitCallback;
import com.oblivioussp.spartanweaponry.api.trait.IThrowingTraitCallback;
import com.oblivioussp.spartanweaponry.api.trait.WeaponTrait;
import com.oblivioussp.spartanweaponry.client.ClientHelper;
import com.oblivioussp.spartanweaponry.client.gui.HudElementCrosshair;
import com.oblivioussp.spartanweaponry.client.gui.HudElementCrosshairThrowingWeapon;
import com.oblivioussp.spartanweaponry.entity.projectile.ThrowingWeaponEntity;
import com.oblivioussp.spartanweaponry.init.ModEnchantments;
import com.oblivioussp.spartanweaponry.init.ModEntities;
import com.oblivioussp.spartanweaponry.init.ModSounds;
import com.oblivioussp.spartanweaponry.item.IHudCrosshair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import net.minecraft.block.BlockState;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.UseAction;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.stats.Stats;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.loading.FMLEnvironment;

public class ThrowingWeaponItem
extends Item
implements IWeaponTraitContainer<ThrowingWeaponItem>,
IHudCrosshair {
    public static final String NBT_AMMO_USED = "AmmoUsed";
    public static final String NBT_UUID = "UUID";
    public static final String NBT_ORIGINAL = "Original";
    protected float attackDamage = 1.0f;
    protected double attackSpeed = 0.0;
    protected float throwVelocity = 2.0f;
    protected float throwDamageMultiplier = 2.0f;
    protected List<WeaponTrait> traits;
    protected WeaponMaterial material;
    protected String customDisplayName = null;
    protected boolean doCraftCheck = true;
    protected boolean canBeCrafted = true;
    protected int maxAmmo = 1;
    protected int maxChargeTicks = 5;

    public ThrowingWeaponItem(String regName, Item.Properties prop, WeaponMaterial material, float weaponBaseDamage, float weaponDamageMultiplier, float weaponSpeed, int maxAmmoCapacity, int chargeTicks, boolean usingDeferredRegister, WeaponTrait ... traits) {
        super(prop.func_200918_c(material.func_200926_a() / 4));
        if (!usingDeferredRegister) {
            this.setRegistryName(regName);
        }
        this.material = material;
        this.setAttackDamage(weaponBaseDamage, weaponDamageMultiplier);
        this.setAttackSpeed(weaponSpeed);
        this.maxAmmo = maxAmmoCapacity;
        this.setChargeTicks(chargeTicks);
        this.traits = new ArrayList<WeaponTrait>();
        this.traits.addAll(Arrays.asList(traits));
        WeaponTrait extraDamageTrait = this.getFirstWeaponTraitWithType("extra_damage_thrown");
        float f = this.throwDamageMultiplier = extraDamageTrait != null ? extraDamageTrait.getMagnitude() : 1.0f;
        if (FMLEnvironment.dist.isClient()) {
            ClientHelper.registerThrowingWeaponPropertyOverrides(this);
        }
    }

    public ThrowingWeaponItem(String regName, Item.Properties prop, WeaponMaterial material, float weaponBaseDamage, float weaponDamageMultiplier, float weaponSpeed, int maxAmmoCapacity, int chargeTicks, String customDisplayName, boolean usingDeferredRegister, WeaponTrait ... weaponTraits) {
        this(regName, prop, material, weaponBaseDamage, weaponDamageMultiplier, weaponSpeed, maxAmmoCapacity, chargeTicks, usingDeferredRegister, weaponTraits);
        if (material.useCustomDisplayName()) {
            this.customDisplayName = customDisplayName;
        }
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int itemSlot, boolean isSelected) {
        this.initNBT(stack, true);
        if (entity instanceof LivingEntity) {
            IMeleeTraitCallback callback;
            LivingEntity living = (LivingEntity)entity;
            if (this.traits != null) {
                for (WeaponTrait trait : this.traits) {
                    callback = trait.getMeleeCallback();
                    if (callback == null) continue;
                    callback.onItemUpdate(this.material, stack, world, living, itemSlot, isSelected);
                }
            }
            if (this.material.hasAnyWeaponTrait()) {
                for (WeaponTrait property : this.material.getAllWeaponTraits()) {
                    callback = property.getMeleeCallback();
                    if (callback == null) continue;
                    callback.onItemUpdate(this.material, stack, world, living, itemSlot, isSelected);
                }
            }
        }
    }

    public boolean func_179218_a(ItemStack stack, World world, BlockState state, BlockPos pos, LivingEntity entityLiving) {
        if (!world.field_72995_K && state.func_185887_b((IBlockReader)world, pos) != 0.0f) {
            this.damageThrowingWeapon(stack, 2, entityLiving);
        }
        return false;
    }

    public void damageThrowingWeapon(ItemStack stack, int damage, LivingEntity entity) {
        if (stack.func_77984_f() && stack.func_196082_o().func_74762_e(NBT_AMMO_USED) < this.getMaxAmmo(stack) && (!(entity instanceof PlayerEntity) || !((PlayerEntity)entity).field_71075_bZ.field_75098_d) && stack.func_96631_a(damage, entity.func_70681_au(), entity instanceof ServerPlayerEntity ? (ServerPlayerEntity)entity : null)) {
            Hand breakHand;
            Object object = stack == entity.func_184592_cb() ? Hand.OFF_HAND : (breakHand = stack == entity.func_184614_ca() ? Hand.MAIN_HAND : null);
            if (breakHand != null) {
                entity.func_213334_d(breakHand);
            }
            int ammo = stack.func_77978_p().func_74762_e(NBT_AMMO_USED);
            stack.func_77978_p().func_74768_a(NBT_AMMO_USED, ++ammo);
            if (entity instanceof PlayerEntity) {
                ((PlayerEntity)entity).func_71029_a(Stats.field_199088_e.func_199076_b((Object)stack.func_77973_b()));
            }
            stack.func_196085_b(0);
        }
    }

    public ITextComponent func_200295_i(ItemStack stack) {
        if (this.customDisplayName == null) {
            return super.func_200295_i(stack);
        }
        return new TranslationTextComponent(this.customDisplayName, new Object[]{this.material.translateName()});
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        boolean isShiftPressed = Screen.func_231173_s_();
        if (this.doCraftCheck && worldIn != null) {
            if (this.material.getModId() == "spartanweaponry" && this.material.func_200924_f().func_203189_d()) {
                this.canBeCrafted = false;
            }
            this.doCraftCheck = false;
        }
        if (!this.canBeCrafted) {
            tooltip.add((ITextComponent)new TranslationTextComponent(String.format("tooltip.%s.uncraftable_missing_material", "spartanweaponry"), new Object[]{this.material.getTagName()}).func_240699_a_(TextFormatting.RED));
        }
        if (stack.func_196082_o().func_74764_b(NBT_ORIGINAL) && !stack.func_77978_p().func_74767_n(NBT_ORIGINAL)) {
            tooltip.add((ITextComponent)new TranslationTextComponent(String.format("tooltip.%s.throwable.not_original", "spartanweaponry")).func_240699_a_(TextFormatting.DARK_RED));
        }
        if (stack.func_77978_p().func_186855_b(NBT_UUID) && flagIn.func_194127_a()) {
            tooltip.add((ITextComponent)new StringTextComponent("UUID: " + TextFormatting.GRAY.toString() + stack.func_77978_p().func_186857_a(NBT_UUID).toString()).func_240699_a_(TextFormatting.DARK_PURPLE));
        }
        int mxAmmo = this.getMaxAmmo(stack);
        tooltip.add((ITextComponent)new TranslationTextComponent(String.format("tooltip.%s.throwable.ammo", "spartanweaponry"), new Object[]{new TranslationTextComponent(String.format("tooltip.%s.throwable.ammo.value", "spartanweaponry"), new Object[]{mxAmmo - stack.func_77978_p().func_74762_e(NBT_AMMO_USED), mxAmmo}).func_240699_a_(TextFormatting.GRAY)}).func_240699_a_(TextFormatting.DARK_AQUA));
        tooltip.add((ITextComponent)new TranslationTextComponent(String.format("tooltip.%s.throwable.charge_time", "spartanweaponry"), new Object[]{new TranslationTextComponent(String.format("tooltip.%s.throwable.charge_time.value", "spartanweaponry"), new Object[]{Float.valueOf((float)this.getMaxChargeTicks(stack) / 20.0f)}).func_240699_a_(TextFormatting.GRAY)}).func_240699_a_(TextFormatting.DARK_AQUA));
        if (!this.traits.isEmpty() || this.material.hasAnyWeaponTrait()) {
            if (isShiftPressed) {
                tooltip.add((ITextComponent)new TranslationTextComponent(String.format("tooltip.%s.traits", "spartanweaponry"), new Object[]{new TranslationTextComponent("tooltip.spartanweaponry.showing_details").func_240699_a_(TextFormatting.DARK_GRAY)}).func_240699_a_(TextFormatting.GOLD));
            } else {
                tooltip.add((ITextComponent)new TranslationTextComponent(String.format("tooltip.%s.traits", "spartanweaponry"), new Object[]{new TranslationTextComponent("tooltip.spartanweaponry.show_details", new Object[]{TextFormatting.AQUA.toString() + "SHIFT"}).func_240699_a_(TextFormatting.DARK_GRAY)}).func_240699_a_(TextFormatting.GOLD));
            }
            for (WeaponTrait trait : this.traits) {
                trait.addTooltip(stack, tooltip, isShiftPressed);
            }
            if (!this.traits.isEmpty()) {
                tooltip.add((ITextComponent)new StringTextComponent(""));
            }
            if (this.material.hasAnyWeaponTrait()) {
                tooltip.add((ITextComponent)new TranslationTextComponent(String.format("tooltip.%s.traits.material_bonus", "spartanweaponry")).func_240699_a_(TextFormatting.AQUA));
                for (WeaponTrait matTrait : this.material.getAllWeaponTraits()) {
                    matTrait.addTooltip(stack, tooltip, isShiftPressed);
                }
            }
        }
        tooltip.add((ITextComponent)new StringTextComponent(""));
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlotType slot, ItemStack stack) {
        HashMultimap multimap = HashMultimap.create();
        if (slot == EquipmentSlotType.MAINHAND) {
            IMeleeTraitCallback callback;
            multimap.put((Object)Attributes.field_233823_f_, (Object)new AttributeModifier(field_111210_e, "Weapon modifier", (double)this.getDirectAttackDamage(), AttributeModifier.Operation.ADDITION));
            multimap.put((Object)Attributes.field_233825_h_, (Object)new AttributeModifier(field_185050_h, "Weapon modifier", this.attackSpeed - 4.0, AttributeModifier.Operation.ADDITION));
            if (this.traits != null) {
                for (WeaponTrait trait : this.traits) {
                    callback = trait.getMeleeCallback();
                    if (callback == null) continue;
                    callback.onModifyAttibutesMelee((Multimap<Attribute, AttributeModifier>)multimap);
                }
            }
            if (this.material.hasAnyWeaponTrait()) {
                for (WeaponTrait property : this.material.getAllWeaponTraits()) {
                    callback = property.getMeleeCallback();
                    if (callback == null) continue;
                    callback.onModifyAttibutesMelee((Multimap<Attribute, AttributeModifier>)multimap);
                }
            }
        }
        return multimap;
    }

    public boolean func_77644_a(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        IMeleeTraitCallback callback;
        for (WeaponTrait trait : this.traits) {
            callback = trait.getMeleeCallback();
            if (callback == null) continue;
            callback.onHitEntity(this.material, stack, target, attacker, null);
        }
        for (WeaponTrait trait : this.material.getAllWeaponTraits()) {
            callback = trait.getMeleeCallback();
            if (callback == null) continue;
            callback.onHitEntity(this.material, stack, target, attacker, null);
        }
        if (stack.func_196082_o().func_74762_e(NBT_AMMO_USED) < this.getMaxAmmo(stack)) {
            this.damageThrowingWeapon(stack, 2, attacker);
        }
        return true;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (stack.func_196082_o().func_74762_e(NBT_AMMO_USED) == this.getMaxAmmo(stack)) {
            return ActionResult.func_226251_d_((Object)stack);
        }
        player.func_184598_c(hand);
        return ActionResult.func_226249_b_((Object)stack);
    }

    public void func_77615_a(ItemStack stack, World worldIn, LivingEntity entityLiving, int timeLeft) {
        int maxAmmo;
        int ammoCount;
        if (entityLiving instanceof PlayerEntity && (ammoCount = (maxAmmo = this.getMaxAmmo(stack)) - stack.func_196082_o().func_74762_e(NBT_AMMO_USED)) > 0) {
            PlayerEntity player = (PlayerEntity)entityLiving;
            int maxCharge = this.getMaxChargeTicks(stack);
            int charge = Math.min(this.func_77626_a(stack) - timeLeft, maxCharge);
            if (!worldIn.field_72995_K && charge > 2) {
                ThrowingWeaponEntity thrown = this.createThrowingWeaponEntity(worldIn, player, stack, charge);
                float chargePerc = (float)charge / (float)maxCharge;
                if (thrown == null) {
                    return;
                }
                thrown.setWeapon(stack);
                int velocityBonus = EnchantmentHelper.func_77506_a((Enchantment)ModEnchantments.THROWING_RANGE, (ItemStack)stack);
                thrown.func_234612_a_((Entity)player, player.field_70125_A, player.field_70177_z, 0.0f, this.throwVelocity * ((float)velocityBonus * 0.2f + 1.0f) * (chargePerc * 0.9f + 0.1f), 0.5f);
                if (this.material.hasAnyWeaponTrait()) {
                    for (WeaponTrait trait : this.material.getAllWeaponTraits()) {
                        if (!trait.isThrowingTrait() || trait.getThrowingCallback() == null) continue;
                        trait.getThrowingCallback().onThrowingProjectileSpawn(this.material, thrown);
                    }
                }
                float damage = (this.getDirectAttackDamage() + 1.0f) * this.throwDamageMultiplier;
                thrown.func_70239_b(damage);
                int j = EnchantmentHelper.func_77506_a((Enchantment)ModEnchantments.THROWING_DAMAGE, (ItemStack)stack);
                if (j > 0) {
                    thrown.func_70239_b(thrown.func_70242_d() + (double)j * 0.5 + 0.5);
                }
                if (EnchantmentHelper.func_77506_a((Enchantment)ModEnchantments.THROWING_FIRE, (ItemStack)stack) > 0) {
                    thrown.func_70015_d(100);
                }
                if (player.field_71075_bZ.field_75098_d) {
                    thrown.field_70251_a = AbstractArrowEntity.PickupStatus.CREATIVE_ONLY;
                } else if (thrown.isValidThrowingWeapon()) {
                    stack.func_196082_o().func_74768_a(NBT_AMMO_USED, maxAmmo - --ammoCount);
                    if (ammoCount == 0 && !stack.func_77978_p().func_74767_n(NBT_ORIGINAL)) {
                        stack.func_190918_g(1);
                        if (stack.func_190916_E() <= 0) {
                            player.field_71071_by.func_184437_d(stack);
                        }
                    }
                }
                if (thrown.isValidThrowingWeapon()) {
                    stack.func_196085_b(0);
                    worldIn.func_184148_a((PlayerEntity)null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), this.getThrowingSound(), SoundCategory.PLAYERS, 0.5f, 0.4f / (field_77697_d.nextFloat() * 0.4f + 0.8f));
                    worldIn.func_217376_c((Entity)thrown);
                }
                player.func_71029_a(Stats.field_75929_E.func_199076_b((Object)this));
            }
        }
        super.func_77615_a(stack, worldIn, entityLiving, timeLeft);
    }

    public int func_77626_a(ItemStack stack) {
        return 72000;
    }

    public UseAction func_77661_b(ItemStack stack) {
        return UseAction.SPEAR;
    }

    public void func_77622_d(ItemStack stack, World worldIn, PlayerEntity playerIn) {
        IMeleeTraitCallback callback;
        for (WeaponTrait trait : this.traits) {
            callback = trait.getMeleeCallback();
            if (callback == null) continue;
            callback.onCreateItem(this.material, stack);
        }
        for (WeaponTrait trait : this.material.getAllWeaponTraits()) {
            callback = trait.getMeleeCallback();
            if (callback == null) continue;
            callback.onCreateItem(this.material, stack);
        }
        this.initNBT(stack, true);
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (this.func_194125_a(group)) {
            IMeleeTraitCallback callback;
            ItemStack stack = new ItemStack((IItemProvider)this);
            for (WeaponTrait trait : this.traits) {
                callback = trait.getMeleeCallback();
                if (callback == null) continue;
                callback.onCreateItem(this.material, stack);
            }
            for (WeaponTrait trait : this.material.getAllWeaponTraits()) {
                callback = trait.getMeleeCallback();
                if (callback == null) continue;
                callback.onCreateItem(this.material, stack);
            }
            this.initNBT(stack, false);
            items.add((Object)stack);
        }
    }

    public int getItemEnchantability(ItemStack stack) {
        return this.material.func_200927_e();
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return super.canApplyAtEnchantingTable(stack, enchantment) || enchantment == Enchantments.field_203193_C;
    }

    @Override
    public boolean hasWeaponTrait(WeaponTrait prop) {
        return this.traits.contains(prop);
    }

    @Override
    public ThrowingWeaponItem addWeaponTrait(WeaponTrait prop) {
        this.traits.add(prop);
        return this;
    }

    @Override
    public WeaponTrait getFirstWeaponTraitWithType(String type) {
        for (WeaponTrait property : this.traits) {
            if (property.getType() != type) continue;
            return property;
        }
        for (WeaponTrait trait : this.material.getAllWeaponTraits()) {
            if (trait.getType() != type) continue;
            return trait;
        }
        return null;
    }

    @Override
    public List<WeaponTrait> getAllWeaponTraitsWithType(String type) {
        ArrayList<WeaponTrait> result = new ArrayList<WeaponTrait>();
        for (WeaponTrait property : this.traits) {
            if (property.getType() != type) continue;
            result.add(property);
        }
        for (WeaponTrait trait : this.material.getAllWeaponTraits()) {
            if (trait.getType() != type) continue;
            result.add(trait);
        }
        if (result.isEmpty()) {
            return null;
        }
        return result;
    }

    @Override
    public List<WeaponTrait> getAllWeaponTraits() {
        return new ArrayList<WeaponTrait>(this.traits);
    }

    @Override
    public WeaponMaterial getMaterial() {
        return this.material;
    }

    public float getDirectAttackDamage() {
        return this.attackDamage;
    }

    public void setAttackDamage(float baseDamage, float damageMultiplier) {
        this.attackDamage = this.material.func_200929_c() * damageMultiplier + baseDamage - 1.0f;
    }

    public void setAttackSpeed(double speed) {
        this.attackSpeed = speed;
    }

    public void setChargeTicks(int chargeTicks) {
        this.maxChargeTicks = chargeTicks;
    }

    public void updateFromConfig(float baseDamage, float damageMultiplier, double speed, int chargeTicks) {
        this.setAttackDamage(baseDamage, damageMultiplier);
        this.setAttackSpeed(speed);
        this.setChargeTicks(chargeTicks);
    }

    public ThrowingWeaponEntity createThrowingWeaponEntity(World worldIn, PlayerEntity player, ItemStack stack, int charge) {
        return new ThrowingWeaponEntity(ModEntities.THROWING_WEAPON, (LivingEntity)player, worldIn);
    }

    protected SoundEvent getThrowingSound() {
        return ModSounds.THROWING_KNIFE_THROW;
    }

    protected void initNBT(ItemStack stack, boolean initUUID) {
        CompoundNBT tag = stack.func_196082_o();
        if (!tag.func_74764_b(NBT_AMMO_USED)) {
            if (stack.func_190916_E() > 1) {
                stack.func_190920_e(1);
            }
            tag.func_74768_a(NBT_AMMO_USED, 0);
        }
        if (initUUID && !tag.func_186855_b(NBT_UUID)) {
            stack.func_77978_p().func_186854_a(NBT_UUID, UUID.randomUUID());
            stack.func_77978_p().func_74757_a(NBT_ORIGINAL, true);
        }
    }

    public int getMaxAmmo(ItemStack stack) {
        int level = EnchantmentHelper.func_77506_a((Enchantment)ModEnchantments.THROWING_AMMO, (ItemStack)stack);
        int increasePerLevel = Math.max((int)((float)this.maxAmmo * 0.25f), 1);
        return this.maxAmmo + increasePerLevel * level;
    }

    public int getMaxAmmoBase() {
        return this.maxAmmo;
    }

    public int getMaxChargeTicks(ItemStack stack) {
        int chargeTicks = (int)((float)this.maxChargeTicks * (1.0f - (float)EnchantmentHelper.func_77506_a((Enchantment)ModEnchantments.THROWING_CHARGE, (ItemStack)stack) * 0.2f));
        if (this.material.hasAnyWeaponTrait()) {
            for (WeaponTrait trait : this.material.getAllWeaponTraits()) {
                IThrowingTraitCallback callback = trait.getThrowingCallback();
                if (!trait.isThrowingTrait() || callback == null) continue;
                chargeTicks = callback.modifyThrowingChargeTime(this.material, chargeTicks);
            }
        }
        return chargeTicks;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public HudElementCrosshair createHudElement() {
        return new HudElementCrosshairThrowingWeapon();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ResourceLocation getType() {
        return HudElementCrosshairThrowingWeapon.TYPE;
    }
}

